/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.services.blackboard;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.system.System;

public class RetrieverBlackboard
extends Blackboard<Object> {
    public static final String KEY_REPOSITORY = "org.palladiosimulator.retriever.repository";
    public static final String KEY_SEFF_ASSOCIATIONS = "org.palladiosimulator.retriever.seff_associations";
    private final Map<RepositoryComponent, CompilationUnit> repositoryComponentLocations = new HashMap<RepositoryComponent, CompilationUnit>();
    private final Map<Path, Set<CompilationUnit>> systemAssociations = new HashMap<Path, Set<CompilationUnit>>();
    private final Map<System, Path> systemPaths = new HashMap<System, Path>();
    private final Set<String> discovererIDs = new HashSet<String>();
    private Object pcmDetector;

    public RetrieverBlackboard(Object pcmDetector) {
        this.pcmDetector = pcmDetector;
        this.addPartition(KEY_SEFF_ASSOCIATIONS, new HashMap());
    }

    public CompilationUnit putRepositoryComponentLocation(RepositoryComponent repoComp, CompilationUnit compilationUnit) {
        return this.repositoryComponentLocations.put(repoComp, compilationUnit);
    }

    public Map<RepositoryComponent, CompilationUnit> getRepositoryComponentLocations() {
        return Collections.unmodifiableMap(this.repositoryComponentLocations);
    }

    public void setPCMDetector(Object pcmDetector) {
        this.pcmDetector = pcmDetector;
    }

    public Object getPCMDetector() {
        return this.pcmDetector;
    }

    public void addSystemAssociations(Path path, Set<CompilationUnit> compilationUnits) {
        this.systemAssociations.put(path, Collections.unmodifiableSet(compilationUnits));
    }

    public Map<Path, Set<CompilationUnit>> getSystemAssociations() {
        return Collections.unmodifiableMap(this.systemAssociations);
    }

    public void putSystemPath(System system, Path path) {
        this.systemPaths.put(system, path);
    }

    public void putSeffAssociation(ASTNode astNode, ServiceEffectSpecification seff) {
        Map seffAssociations = (Map)this.getPartition(KEY_SEFF_ASSOCIATIONS);
        seffAssociations.put(astNode, seff);
    }

    public ServiceEffectSpecification getSeffAssociation(ASTNode astNode) {
        Map seffAssociations = (Map)this.getPartition(KEY_SEFF_ASSOCIATIONS);
        return (ServiceEffectSpecification)seffAssociations.get(astNode);
    }

    public Map<ASTNode, ServiceEffectSpecification> getSeffAssociations() {
        Map seffAssociations = (Map)this.getPartition(KEY_SEFF_ASSOCIATIONS);
        return Collections.unmodifiableMap(seffAssociations);
    }

    public Map<System, Path> getSystemPaths() {
        return Collections.unmodifiableMap(this.systemPaths);
    }

    public <T> void putDiscoveredFiles(String discovererID, Map<Path, T> pathsToFiles) {
        this.discovererIDs.add(discovererID);
        this.addPartition(discovererID, pathsToFiles);
    }

    public <T> Map<Path, T> getDiscoveredFiles(String discovererID, Class<T> fileClass) {
        Object partition = this.getPartition(discovererID);
        if (!(partition instanceof Map)) {
            return new HashMap();
        }
        Map map = (Map)partition;
        if (map.isEmpty()) {
            return new HashMap();
        }
        boolean allEntriesHaveCorrectType = map.entrySet().stream().allMatch(entry -> entry.getKey() instanceof Path && fileClass.isInstance(entry.getValue()));
        if (!allEntriesHaveCorrectType) {
            return new HashMap();
        }
        return map.entrySet().stream().collect(Collectors.toMap(entry -> (Path)entry.getKey(), entry -> fileClass.cast(entry.getValue())));
    }

    public Set<Path> getDiscoveredPaths() {
        HashSet<Path> discoveredPaths = new HashSet<Path>();
        for (String discovererID : this.discovererIDs) {
            Map partition = (Map)this.getPartition(discovererID);
            discoveredPaths.addAll(partition.keySet());
        }
        return discoveredPaths;
    }
}

