/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.vulnerability.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.AttackerSystemSpecificationContainer;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.CategorySpecification;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.VulnerabilityContainer;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Vulnerability;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.impl.AttackerFactoryImpl;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.pcmIntegration.PCMElement;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.pcmIntegration.SystemIntegration;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.pcmIntegration.VulnerabilitySystemIntegration;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.pcmIntegration.impl.PcmIntegrationFactoryImpl;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.system.impl.SystemImpl;
import org.palladiosimulator.retriever.vulnerability.core.NistVulnerabilityDatabase;
import org.palladiosimulator.retriever.vulnerability.core.SnykIssue;
import org.palladiosimulator.retriever.vulnerability.core.StaticCodeAnalyisResult;
import org.palladiosimulator.retriever.vulnerability.core.api.IStaticCodeAnalysisIssue;
import org.palladiosimulator.retriever.vulnerability.core.api.IStaticCodeAnalysisResult;
import org.palladiosimulator.retriever.vulnerability.core.api.IStaticCodeAnalyst;
import org.palladiosimulator.retriever.vulnerability.core.api.IVulnerabilityDatabase;
import org.palladiosimulator.retriever.vulnerability.core.api.VulnerabilityDatabaseException;

public class SnykCLIStaticCodeAnalyst
implements IStaticCodeAnalyst {
    private static final Logger LOG = Logger.getLogger(SnykCLIStaticCodeAnalyst.class);
    private final IVulnerabilityDatabase vulnerabilityDatabase;
    private Path snykLocation;
    private Path outputLocation;
    private String snykToken;
    private boolean isSnykExeAuthenticated = false;
    private static String packagePattern;
    private static String issueNamePattern;
    private static String severityPattern;
    private static String urlPattern;
    private static String fullOutputPattern;

    static {
        LOG.setLevel(Level.DEBUG);
        LOG.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        packagePattern = "(?<package>[a-zA-Z0-9\\.:@\\-]*)";
        issueNamePattern = "(?<name>[a-z A-Z\\(\\)]*)";
        severityPattern = "\\[(?<severity>[a-z A-Z]*)\\]";
        urlPattern = "\\[(?<url>(?:https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])\\]";
        fullOutputPattern = String.valueOf(issueNamePattern) + severityPattern + urlPattern + " in " + packagePattern;
    }

    public SnykCLIStaticCodeAnalyst(Path snykLocation, Path outputLocation, String apiKey, String snykToken) {
        this.snykLocation = snykLocation;
        this.outputLocation = outputLocation;
        this.snykToken = snykToken;
        this.vulnerabilityDatabase = new NistVulnerabilityDatabase(apiKey);
    }

    @Override
    public IStaticCodeAnalysisResult analyze(Map<System, Path> systemPaths) {
        return this.analyze(systemPaths, true);
    }

    public IStaticCodeAnalysisResult analyze(Map<System, Path> systemPaths, boolean saveResult) {
        StaticCodeAnalyisResult result = null;
        for (System system : systemPaths.keySet()) {
            StaticCodeAnalyisResult thisResult;
            Path path = systemPaths.get(system);
            boolean isMaven = path.getFileName().toString().equals("pom.xml");
            boolean isDocker = path.getFileName().toString().equals("Dockerfile");
            boolean isGradle = path.getFileName().toString().equals("build.gradle");
            if (!isMaven && !isDocker && !isGradle) continue;
            String output = this.scanWithSnykCLI(path);
            result = thisResult = this.parseSnykCLIOutput(output);
            if (!saveResult) continue;
            AttackerSystemSpecificationContainer container = AttackerFactoryImpl.eINSTANCE.createAttackerSystemSpecificationContainer();
            EList systemIntegrations = container.getVulnerabilities();
            if (system instanceof SystemImpl) {
                ((SystemImpl)system).getAssemblyContexts__ComposedStructure().forEach(arg_0 -> this.lambda$0((List)systemIntegrations, thisResult, arg_0));
            } else {
                systemIntegrations.addAll(this.annotateResultToEntity((Entity)system, result));
            }
            String repositoryName = path.getParent().getFileName().toString();
            this.saveModel(repositoryName, container, this.vulnerabilityDatabase.getCategorySpecification());
            this.saveSnykOutput(repositoryName, output);
        }
        return result;
    }

    private List<VulnerabilitySystemIntegration> annotateResultToEntity(Entity entity, StaticCodeAnalyisResult result) {
        ArrayList<VulnerabilitySystemIntegration> sysIntegs = new ArrayList<VulnerabilitySystemIntegration>();
        for (IStaticCodeAnalysisIssue issue : result.getIssues()) {
            Vulnerability vul = this.getVulnerability(issue.getUrl());
            if (vul == null) continue;
            VulnerabilitySystemIntegration sysInteg = PcmIntegrationFactoryImpl.eINSTANCE.createVulnerabilitySystemIntegration();
            sysInteg.setVulnerability(vul);
            PCMElement pcmElement = PcmIntegrationFactoryImpl.eINSTANCE.createPCMElement();
            if (entity instanceof RepositoryComponent) {
                pcmElement.setBasiccomponent((RepositoryComponent)entity);
            } else if (entity instanceof AssemblyContext) {
                pcmElement.setBasiccomponent(((AssemblyContext)entity).getEncapsulatedComponent__AssemblyContext());
            } else {
                throw new IllegalArgumentException("Please use RepositoryComponents or AssemblyContexts as arguments");
            }
            sysInteg.setPcmelement(pcmElement);
            sysIntegs.add(sysInteg);
        }
        return sysIntegs;
    }

    private Vulnerability getVulnerability(String url) {
        Document doc = null;
        try {
            doc = Jsoup.connect((String)url).get();
        }
        catch (IOException iOException) {
            LOG.error((Object)("Could not get vulnerability definitions from \"" + url + "\"!"));
            return null;
        }
        List identifiers = doc.select("a[href]").stream().map(x -> x.ownText()).filter(x -> x.startsWith("CVE-")).collect(Collectors.toList());
        List<Integer> cweIdentifiers = doc.select("a[href]").stream().map(x -> x.ownText()).filter(x -> x.startsWith("CWE-")).map(x -> x.substring(4)).map(x -> {
            try {
                return Integer.parseInt(x);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }).filter(x -> x != null).collect(Collectors.toList());
        for (String identifier : identifiers) {
            try {
                return this.vulnerabilityDatabase.getCVEVulnerability(identifier, cweIdentifiers);
            }
            catch (VulnerabilityDatabaseException e) {
                LOG.warn((Object)("Database error for \"" + identifier + "\":\n" + e.getMessage()));
            }
        }
        return null;
    }

    private String scanWithSnykCLI(Path path) {
        if (!this.isSnykExeAuthenticated) {
            this.authenticateSnykExe();
        }
        if (path.toFile().exists()) {
            String result = this.runSnykCommand(path.getParent().toFile(), "test", "--all-sub-projects", "--file=" + path);
            if (result == null) {
                return "";
            }
            return result;
        }
        LOG.error((Object)"File does not exist.");
        return "";
    }

    private void authenticateSnykExe() {
        String currentSnykToken = this.runSnykCommand(false, null, "config", "get", "api");
        if (currentSnykToken != null && !currentSnykToken.isBlank()) {
            LOG.info((Object)"Snyk executable is already authenticated");
            return;
        }
        if (this.snykToken == null || this.snykToken.isBlank()) {
            LOG.warn((Object)"Snyk executable could not be authenticated!\nAuthenticate it manually by running \"snyk auth\" or supply an authentication token!\nIf the authentication token is supplied via an environment variable, ignore this warning.");
            return;
        }
        if (this.runSnykCommand("auth", this.snykToken) != null) {
            this.isSnykExeAuthenticated = true;
        }
    }

    private String runSnykCommand(String ... args) {
        return this.runSnykCommand((File)null, args);
    }

    private String runSnykCommand(File path, String ... args) {
        return this.runSnykCommand(true, path, args);
    }

    private String runSnykCommand(boolean logging, File path, String ... args) {
        ArrayList<String> commandParams = new ArrayList<String>();
        commandParams.add(this.snykLocation.toString());
        commandParams.addAll(List.of(args));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(commandParams);
        if (path != null) {
            processBuilder.directory(path);
        }
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (logging) {
                    LOG.debug((Object)line);
                }
                sb.append(line).append('\n');
            }
            int exitCode = process.waitFor();
            if (logging) {
                LOG.info((Object)("\nExited with error code : " + exitCode));
            }
            return sb.toString();
        }
        catch (IOException | InterruptedException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public StaticCodeAnalyisResult parseSnykCLIOutput(String output) {
        ArrayList<IStaticCodeAnalysisIssue> issues = new ArrayList<IStaticCodeAnalysisIssue>();
        String packetManager = null;
        if (output == null || output.isEmpty()) {
            return new StaticCodeAnalyisResult(issues, packetManager);
        }
        String[] issueStrings = output.split("\\u2717");
        if (issueStrings.length <= 1) {
            issueStrings = new String(output.getBytes(), StandardCharsets.UTF_8).split("\\u2717");
        }
        Pattern pattern = Pattern.compile(fullOutputPattern);
        int i = 1;
        while (i < issueStrings.length) {
            Matcher matcher = pattern.matcher(issueStrings[i]);
            if (matcher.find()) {
                SnykIssue issue = new SnykIssue(matcher.group("url"), matcher.group("name"), matcher.group("package"), matcher.group("severity"));
                issues.add(issue);
            }
            ++i;
        }
        return new StaticCodeAnalyisResult(issues, packetManager);
    }

    private void saveModel(String name, AttackerSystemSpecificationContainer model, CategorySpecification categories) {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("vulnerabilitySystemIntegration", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createURI((String)this.outputLocation.resolve(String.valueOf(name) + ".attacker").toUri().toString()));
        resource.getContents().add((Object)model);
        VulnerabilityContainer vulnContainer = AttackerFactoryImpl.eINSTANCE.createVulnerabilityContainer();
        for (SystemIntegration integ : model.getVulnerabilities()) {
            VulnerabilitySystemIntegration vulnInteg = (VulnerabilitySystemIntegration)integ;
            if (vulnInteg.getVulnerability() == null) continue;
            vulnContainer.getVulnerability().add((Object)vulnInteg.getVulnerability());
        }
        resource.getContents().add((Object)vulnContainer);
        resource.getContents().add((Object)categories);
        try {
            resource.save(Collections.emptyMap());
        }
        catch (IOException e) {
            LOG.error((Object)("An error occurred while saving the result:\n" + e.getMessage()));
        }
    }

    private void saveSnykOutput(String name, String output) {
        File snykOutputFile = this.outputLocation.resolve(String.valueOf(name) + ".log").toFile();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileWriter writer = new FileWriter(snykOutputFile);){
                ((Writer)writer).append(output);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error((Object)("An error occurred while saving the result:\n" + e.getMessage()));
        }
    }

    @Override
    public IStaticCodeAnalysisResult analyze(String path) {
        return this.parseSnykCLIOutput(path);
    }

    private /* synthetic */ void lambda$0(List list, StaticCodeAnalyisResult staticCodeAnalyisResult, AssemblyContext x) {
        boolean bl = list.addAll(this.annotateResultToEntity((Entity)x, staticCodeAnalyisResult));
    }
}

