/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.view.plantuml.generator;

import java.util.Comparator;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.core.entity.NamedElement;

public interface UmlDiagramSupplier
extends Supplier<String> {
    public static Comparator<NamedElement> byName() {
        return Comparator.comparing(x -> UmlDiagramSupplier.escape(x.getEntityName()));
    }

    private static String createMarkerLink(String markerType, String path, String ... args) {
        StringBuilder link = new StringBuilder("marker:/").append(markerType).append(path);
        if (args.length > 0) {
            link.append("?");
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    link.append("&");
                }
                link.append(args[i]).append("=").append(args[i + 1]);
                i += 2;
            }
        }
        return link.toString();
    }

    public static String escape(Object identifier) {
        return identifier == null ? "" : String.valueOf(identifier).strip().replaceAll("\\s+", ".").replaceAll("\\W+", "_");
    }

    public static String getEObjectHyperlink(EObject eObject) {
        URI uri = EcoreUtil.getURI((EObject)eObject);
        if (uri.isPlatformResource()) {
            String path = uri.path();
            if (path.startsWith("/resource")) {
                path = path.substring("/resource".length());
            }
            return UmlDiagramSupplier.createMarkerLink("org.eclipse.emf.ecore.diagnostic", path, "uri", URI.encodeQuery((String)uri.toString(), (boolean)false));
        }
        return uri.toString();
    }
}

