/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.vulnerability.analyst;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.retriever.services.Analyst;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;
import org.palladiosimulator.retriever.vulnerability.core.SnykCLIStaticCodeAnalyst;

public class SnykCodeAnalystJob
extends AbstractBlackboardInteractingJob<RetrieverBlackboard> {
    private final RetrieverConfiguration configuration;

    public SnykCodeAnalystJob(RetrieverConfiguration configuration, RetrieverBlackboard blackboard) {
        this.configuration = configuration;
        this.setBlackboard((Blackboard)blackboard);
    }

    public void execute(IProgressMonitor monitor) {
        Map snykAnalystConfig = this.configuration.getConfig(Analyst.class).getWholeConfig("org.palladiosimulator.retriever.vulnerability.core.analyst");
        String snykExeLocation = (String)snykAnalystConfig.get("SNYK_EXE_LOCATION");
        if (snykExeLocation != null) {
            Path snykExePath = Path.of(snykExeLocation, new String[0]);
            Path outputPath = Path.of(CommonPlugin.asLocalURI((URI)this.configuration.getOutputFolder()).devicePath(), new String[0]);
            String apiKey = (String)snykAnalystConfig.get("DATABASE_API_KEY");
            String snykToken = (String)snykAnalystConfig.get("SNYK_TOKEN");
            SnykCLIStaticCodeAnalyst analyst = new SnykCLIStaticCodeAnalyst(snykExePath, outputPath, apiKey, snykToken);
            analyst.analyze(((RetrieverBlackboard)this.getBlackboard()).getSystemPaths());
        }
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }

    public String getName() {
        return "Snyk Code Analyst Job";
    }
}

