package org.palladiosimulator.retriever.vulnerability.core.api;

/**
 * Parent interface for CodeAnalysts. Use this to enable new CodeAnalysts later
 * on.
 */
public interface ICodeAnalyst {

	/**
	 * Request a analysis result of a repository or docker image from the analysis
	 * provider.
	 * 
	 * @param path String that indicates the path to the repository or docker image
	 *             to analyze.
	 * @return A result object that holds all important analysis information.
	 */
	public ICodeAnalysisResult analyze(String path);

}
