/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.vulnerability.core;

import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AttackVector;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.AvailabilityImpact;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.ConfidentialityImpact;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.IntegrityImpact;
import org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification.Privileges;
import org.palladiosimulator.retriever.vulnerability.core.nvd.CvssV31Data;

public final class CvssConverter {
    private CvssConverter() {
        throw new IllegalStateException("This utility class should not be instantiated!");
    }

    public static ConfidentialityImpact toConfImpact(CvssV31Data.CiaType ciaType) {
        switch (ciaType) {
            case NONE: {
                return ConfidentialityImpact.NONE;
            }
            case HIGH: {
                return ConfidentialityImpact.HIGH;
            }
            case LOW: {
                return ConfidentialityImpact.LOW;
            }
        }
        return null;
    }

    public static IntegrityImpact toIntegImpact(CvssV31Data.CiaType ciaType) {
        switch (ciaType) {
            case NONE: {
                return IntegrityImpact.NONE;
            }
            case HIGH: {
                return IntegrityImpact.HIGH;
            }
            case LOW: {
                return IntegrityImpact.LOW;
            }
        }
        return null;
    }

    public static AvailabilityImpact toAvailImpact(CvssV31Data.CiaType ciaType) {
        switch (ciaType) {
            case NONE: {
                return AvailabilityImpact.NONE;
            }
            case HIGH: {
                return AvailabilityImpact.HIGH;
            }
            case LOW: {
                return AvailabilityImpact.LOW;
            }
        }
        return null;
    }

    public static AttackVector convert(CvssV31Data.AttackVectorType attackVectorType) {
        switch (attackVectorType) {
            case ADJACENT_NETWORK: {
                return AttackVector.ADJACENT_NETWORK;
            }
            case LOCAL: {
                return AttackVector.LOCAL;
            }
            case NETWORK: {
                return AttackVector.NETWORK;
            }
        }
        return null;
    }

    public static Privileges convert(CvssV31Data.PrivilegesRequiredType privilegesRequired) {
        switch (privilegesRequired) {
            case HIGH: {
                return Privileges.SPECIAL;
            }
            case LOW: {
                return Privileges.LOW;
            }
            case NONE: {
                return Privileges.NONE;
            }
        }
        return null;
    }
}

