/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.gui;

import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeEditListener
implements Listener {
    private final TreeItem[] lastItem = new TreeItem[1];
    private final TreeEditor editor;
    private final Tree tree;
    private final ModifyListener modifyListener;
    private final int column;

    public TreeEditListener(Tree tree, ModifyListener modifyListener, int column) {
        this.tree = tree;
        this.modifyListener = modifyListener;
        this.column = column;
        this.editor = new TreeEditor(tree);
    }

    public void handleEvent(Event event) {
        TreeItem item = (TreeItem)event.item;
        if (item != null && item == this.lastItem[0] && item.getParentItem() != null) {
            Composite composite = new Composite((Composite)this.tree, 0);
            composite.setBackground(new Color(0, 0, 0));
            Text text = new Text(composite, 0);
            composite.addListener(11, e1 -> {
                Rectangle rect1 = composite.getClientArea();
                text.setBounds(rect1.x + 1, rect1.y + 1, rect1.width - 2, rect1.height - 2);
            });
            Listener textListener = e2 -> {
                switch (e2.type) {
                    case 16: {
                        item.setText(this.column, text.getText());
                        this.modifyListener.modifyText(null);
                        composite.dispose();
                        break;
                    }
                    case 25: {
                        String newText = text.getText();
                        String leftText = newText.substring(0, e2.start);
                        String rightText = newText.substring(e2.end);
                        GC gc = new GC((Drawable)text);
                        Point size = gc.textExtent(String.valueOf(leftText) + e2.text + rightText);
                        gc.dispose();
                        size = text.computeSize(size.x, -1);
                        this.editor.horizontalAlignment = 16384;
                        this.editor.setColumn(this.column);
                        Rectangle itemRect = item.getBounds(this.column);
                        Rectangle rect2 = this.tree.getClientArea();
                        this.editor.minimumWidth = Math.max(size.x, itemRect.width) + 2;
                        int left = itemRect.x;
                        int right = rect2.x + rect2.width;
                        this.editor.minimumWidth = Math.min(this.editor.minimumWidth, right - left);
                        this.editor.minimumHeight = size.y + 2;
                        this.editor.layout();
                        break;
                    }
                    case 31: {
                        switch (e2.detail) {
                            case 4: {
                                item.setText(this.column, text.getText());
                                this.modifyListener.modifyText(null);
                            }
                            case 2: {
                                composite.dispose();
                                e2.doit = false;
                            }
                        }
                        break;
                    }
                }
            };
            text.addListener(16, textListener);
            text.addListener(31, textListener);
            text.addListener(25, textListener);
            this.editor.setEditor((Control)composite, item);
            text.setText(item.getText(this.column));
            text.selectAll();
            text.setFocus();
        }
        this.lastItem[0] = item;
    }
}

