/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.workflow;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.generator.fluent.shared.util.ModelSaver;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.system.System;

public class PersistenceJob
implements IBlackboardInteractingJob<Blackboard<Object>> {
    private static final String JOB_NAME = "Model Persistence Job";
    private Blackboard<Object> blackboard;
    private final String repositoryKey;
    private final String systemKey;
    private final String allocationKey;
    private final String resourceEnvironmentKey;
    private final String outputFolder;
    private final String projectName;

    public PersistenceJob(Blackboard<Object> blackboard, URI inputFolder, URI outputFolder, String repositoryKey, String systemKey, String allocationKey, String resourceEnvironmentKey) {
        this.blackboard = Objects.requireNonNull(blackboard);
        this.repositoryKey = Objects.requireNonNull(repositoryKey);
        this.systemKey = Objects.requireNonNull(systemKey);
        this.allocationKey = Objects.requireNonNull(allocationKey);
        this.resourceEnvironmentKey = Objects.requireNonNull(resourceEnvironmentKey);
        this.outputFolder = CommonPlugin.asLocalURI((URI)outputFolder).devicePath();
        String lastInputSegment = inputFolder.lastSegment();
        if (lastInputSegment.isEmpty()) {
            lastInputSegment = inputFolder.trimSegments(1).lastSegment();
        }
        this.projectName = lastInputSegment;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        monitor.subTask("Retrieving job input from blackboard");
        Repository repository = (Repository)this.blackboard.getPartition(this.repositoryKey);
        System system = (System)this.blackboard.getPartition(this.systemKey);
        ResourceEnvironment resourceEnvironment = (ResourceEnvironment)this.blackboard.getPartition(this.resourceEnvironmentKey);
        Allocation allocation = (Allocation)this.blackboard.getPartition(this.allocationKey);
        monitor.subTask("Persisting models");
        ModelSaver.saveRepository((Repository)repository, (String)this.outputFolder, (String)this.projectName);
        ModelSaver.saveSystem((System)system, (String)this.outputFolder, (String)this.projectName);
        ModelSaver.saveResourceEnvironment((ResourceEnvironment)resourceEnvironment, (String)this.outputFolder, (String)this.projectName);
        ModelSaver.saveAllocation((Allocation)allocation, (String)this.outputFolder, (String)this.projectName);
        monitor.done();
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return JOB_NAME;
    }

    public void setBlackboard(Blackboard<Object> blackboard) {
        this.blackboard = Objects.requireNonNull(blackboard);
    }
}

