/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.workflow;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.extension.AbstractExtendableJob;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.ParallelJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.palladiosimulator.retriever.core.workflow.PersistenceJob;
import org.palladiosimulator.retriever.core.workflow.PlantUmlJob;
import org.palladiosimulator.retriever.core.workflow.RetrieverBlackboardInteractingJob;
import org.palladiosimulator.retriever.core.workflow.SeffMergerJob;
import org.palladiosimulator.retriever.core.workflow.TypeMergerJob;
import org.palladiosimulator.retriever.extraction.engine.PCMDetector;
import org.palladiosimulator.retriever.mocore.workflow.MoCoReJob;
import org.palladiosimulator.retriever.services.Analyst;
import org.palladiosimulator.retriever.services.Discoverer;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;
import org.palladiosimulator.somox.ast2seff.jobs.Ast2SeffJob;

public class RetrieverJob
extends AbstractExtendableJob<RetrieverBlackboard> {
    public RetrieverJob(RetrieverConfiguration configuration) {
        super.setBlackboard((Blackboard)new RetrieverBlackboard((Object)new PCMDetector()));
        super.addAll(this.createDiscovererJobs(configuration));
        super.addAll(this.createRuleJobs(configuration));
        super.addAll(this.createBuildRulesJob(configuration));
        super.add((IJob)new RetrieverBlackboardInteractingJob(configuration, (RetrieverBlackboard)this.getBlackboard()));
        super.addAll(this.createAnalystJobs(configuration));
        super.add((IJob)new Ast2SeffJob(this.getBlackboard(), "org.palladiosimulator.retriever.seff_associations", "org.palladiosimulator.retriever.core.configuration.ast2seff.output.repository"));
        super.add((IJob)new SeffMergerJob((Blackboard<Object>)this.myBlackboard, "org.palladiosimulator.retriever.core.configuration.ast2seff.output.repository", "org.palladiosimulator.retriever.repository"));
        super.add((IJob)new MoCoReJob(this.getBlackboard(), "org.palladiosimulator.retriever.repository", "org.palladiosimulator.retriever.core.configuration.mocore.output.repository", "org.palladiosimulator.retriever.core.configuration.mocore.output.system", "org.palladiosimulator.retriever.core.configuration.mocore.output.allocation", "org.palladiosimulator.retriever.core.configuration.mocore.output.resource_environment"));
        super.add((IJob)new TypeMergerJob((Blackboard<Object>)this.getBlackboard(), "org.palladiosimulator.retriever.repository", "org.palladiosimulator.retriever.core.configuration.mocore.output.repository"));
        super.add((IJob)new PersistenceJob((Blackboard<Object>)this.getBlackboard(), configuration.getInputFolder(), configuration.getOutputFolder(), "org.palladiosimulator.retriever.core.configuration.mocore.output.repository", "org.palladiosimulator.retriever.core.configuration.mocore.output.system", "org.palladiosimulator.retriever.core.configuration.mocore.output.allocation", "org.palladiosimulator.retriever.core.configuration.mocore.output.resource_environment"));
        super.add((IJob)new PlantUmlJob((RetrieverBlackboard)this.getBlackboard(), configuration.getOutputFolder(), "org.palladiosimulator.retriever.core.configuration.mocore.output.repository", "org.palladiosimulator.retriever.core.configuration.mocore.output.system", "org.palladiosimulator.retriever.core.configuration.mocore.output.allocation"));
    }

    private List<ParallelJob> createRuleJobs(RetrieverConfiguration configuration) {
        ArrayList<ParallelJob> jobs = new ArrayList<ParallelJob>();
        for (Collection step : configuration.getConfig(Rule.class).getExecutionOrder()) {
            ParallelJob parentJob = new ParallelJob();
            for (Rule rule : step) {
                if (rule.isBuildRule()) continue;
                IBlackboardInteractingJob ruleJob = rule.create(configuration, (RetrieverBlackboard)this.myBlackboard);
                parentJob.add((IJob)ruleJob);
                this.logger.info((Object)("Adding rule job \"" + ruleJob.getName() + "\""));
            }
            jobs.add(parentJob);
        }
        return jobs;
    }

    private List<ParallelJob> createBuildRulesJob(RetrieverConfiguration configuration) {
        ArrayList<ParallelJob> jobs = new ArrayList<ParallelJob>();
        for (Collection step : configuration.getConfig(Rule.class).getExecutionOrder()) {
            ParallelJob parentJob = new ParallelJob();
            for (Rule rule : step) {
                if (!rule.isBuildRule()) continue;
                IBlackboardInteractingJob ruleJob = rule.create(configuration, (RetrieverBlackboard)this.myBlackboard);
                parentJob.add((IJob)ruleJob);
                this.logger.info((Object)("Adding build rule job \"" + ruleJob.getName() + "\""));
            }
            jobs.add(parentJob);
        }
        return jobs;
    }

    private List<ParallelJob> createDiscovererJobs(RetrieverConfiguration configuration) {
        ArrayList<ParallelJob> jobs = new ArrayList<ParallelJob>();
        for (Collection step : configuration.getConfig(Discoverer.class).getExecutionOrder()) {
            ParallelJob parentJob = new ParallelJob();
            for (Discoverer discoverer : step) {
                IBlackboardInteractingJob discovererJob = discoverer.create(configuration, (RetrieverBlackboard)this.myBlackboard);
                parentJob.add((IJob)discovererJob);
                this.logger.info((Object)("Adding discoverer job \"" + discovererJob.getName() + "\""));
            }
            jobs.add(parentJob);
        }
        return jobs;
    }

    private List<ParallelJob> createAnalystJobs(RetrieverConfiguration configuration) {
        ArrayList<ParallelJob> jobs = new ArrayList<ParallelJob>();
        for (Collection step : configuration.getConfig(Analyst.class).getExecutionOrder()) {
            ParallelJob parentJob = new ParallelJob();
            for (Analyst analyst : step) {
                IBlackboardInteractingJob analystJob = analyst.create(configuration, (RetrieverBlackboard)this.myBlackboard);
                parentJob.add((IJob)analystJob);
                this.logger.info((Object)("Adding analyst job \"" + analystJob.getName() + "\""));
            }
            jobs.add(parentJob);
        }
        return jobs;
    }
}

