/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.gui;

import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.palladiosimulator.retriever.services.Service;
import org.palladiosimulator.retriever.services.ServiceConfiguration;

public class ServiceConfigurationManager<T extends Service> {
    private final ServiceConfiguration<T> serviceConfiguration;

    public ServiceConfigurationManager(ServiceConfiguration<T> serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.serviceConfiguration.applyAttributeMap(configuration.getAttributes());
        }
        catch (CoreException e) {
            LaunchConfigPlugin.log((int)4, (String)e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.writeServiceConfigAttributes(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.writeServiceConfigAttributes(configuration);
    }

    private void writeServiceConfigAttributes(ILaunchConfigurationWorkingCopy configuration) {
        Map attributes = this.serviceConfiguration.toMap();
        for (Map.Entry attribute : attributes.entrySet()) {
            configuration.setAttribute((String)attribute.getKey(), attribute.getValue());
        }
    }

    public ServiceConfiguration<T> getServiceConfiguration() {
        return this.serviceConfiguration;
    }
}

