/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.workflow;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.retriever.core.main.Retriever;
import org.palladiosimulator.retriever.core.main.RetrieverException;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class RetrieverBlackboardInteractingJob
extends AbstractBlackboardInteractingJob<RetrieverBlackboard> {
    private static final String NAME = "Retriever Blackboard Interacting Job";
    private final RetrieverConfiguration configuration;

    public RetrieverBlackboardInteractingJob(RetrieverConfiguration configuration, RetrieverBlackboard blackboard) {
        super.setBlackboard((Blackboard)blackboard);
        this.configuration = Objects.requireNonNull(configuration);
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        try {
            new Retriever((RetrieverBlackboard)this.getBlackboard()).analyze(this.configuration, monitor);
        }
        catch (RetrieverException e) {
            throw new JobFailedException("Retriever Blackboard Interacting Job Failed", (Throwable)e);
        }
    }

    public String getName() {
        return NAME;
    }
}

