package org.palladiosimulator.retriever.extraction.rules.util;

import com.google.common.base.Objects;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.jdom2.Document;
import org.jdom2.Element;

@SuppressWarnings("all")
public final class SpringHelper {
  private static final Logger LOG = Logger.getLogger(SpringHelper.class);

  public SpringHelper() {
    try {
      throw new IllegalAccessException();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  public static Path findConfigRoot(final Map<Path, Document> poms) {
    if ((poms == null)) {
      return null;
    }
    final Function<Map.Entry<Path, Document>, Pair<Path, Element>> _function = (Map.Entry<Path, Document> entry) -> {
      Path _key = entry.getKey();
      Element _child = entry.getValue().getRootElement().getChild("dependencies", entry.getValue().getRootElement().getNamespace());
      return Pair.<Path, Element>of(_key, _child);
    };
    final Predicate<Pair<Path, Element>> _function_1 = (Pair<Path, Element> entry) -> {
      Element _value = entry.getValue();
      return (_value != null);
    };
    final Function<Pair<Path, Element>, Pair<Path, List<Element>>> _function_2 = (Pair<Path, Element> entry) -> {
      Path _key = entry.getKey();
      List<Element> _children = entry.getValue().getChildren("dependency", entry.getValue().getNamespace());
      return Pair.<Path, List<Element>>of(_key, _children);
    };
    final Predicate<Pair<Path, List<Element>>> _function_3 = (Pair<Path, List<Element>> entry) -> {
      boolean _isEmpty = entry.getValue().isEmpty();
      return (!_isEmpty);
    };
    final Predicate<Pair<Path, List<Element>>> _function_4 = (Pair<Path, List<Element>> entry) -> {
      final Function1<Element, Boolean> _function_5 = (Element dependency) -> {
        String _childTextTrim = dependency.getChildTextTrim("groupId", dependency.getNamespace());
        return Boolean.valueOf(Objects.equal(_childTextTrim, "org.springframework.cloud"));
      };
      final Function1<Element, Boolean> _function_6 = (Element dependency) -> {
        String _childTextTrim = dependency.getChildTextTrim("artifactId", dependency.getNamespace());
        return Boolean.valueOf(Objects.equal(_childTextTrim, "spring-cloud-config-server"));
      };
      return IterableExtensions.<Element>exists(IterableExtensions.<Element>filter(entry.getValue(), _function_5), _function_6);
    };
    final List<Pair<Path, List<Element>>> configRoots = poms.entrySet().stream().<Pair<Path, Element>>map(_function).filter(_function_1).<Pair<Path, List<Element>>>map(_function_2).filter(_function_3).filter(_function_4).collect(Collectors.<Pair<Path, List<Element>>>toList());
    int _size = configRoots.size();
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      Path _parent = configRoots.get(0).getKey().getParent();
      String _plus = ("Multiple Spring config servers, choosing \"" + _parent);
      String _plus_1 = (_plus + "\" arbitrarily");
      SpringHelper.LOG.warn(_plus_1);
    } else {
      boolean _isEmpty = configRoots.isEmpty();
      if (_isEmpty) {
        return null;
      }
    }
    return configRoots.get(0).getKey().getParent();
  }

  public static Path findFile(final Set<Path> paths, final Path directory, final Set<String> possibleNames) {
    if ((((paths == null) || (directory == null)) || (possibleNames == null))) {
      return null;
    }
    final Predicate<Path> _function = (Path path) -> {
      Path _parent = path.getParent();
      return Objects.equal(_parent, directory);
    };
    final Predicate<Path> _function_1 = (Path path) -> {
      return possibleNames.contains(path.getFileName().toString());
    };
    final List<Path> candidates = paths.stream().filter(_function).filter(_function_1).collect(Collectors.<Path>toList());
    int _size = candidates.size();
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      final String fileName = possibleNames.iterator().next();
      Path _relativize = directory.relativize(candidates.get(0));
      String _plus = ((((("Multiple " + fileName) + " in ") + directory) + ", choosing ") + _relativize);
      String _plus_1 = (_plus + 
        " arbitrarily");
      SpringHelper.LOG.warn(_plus_1);
    } else {
      boolean _isEmpty = candidates.isEmpty();
      if (_isEmpty) {
        return null;
      }
    }
    return candidates.get(0);
  }

  public static String getFromYamlOrProperties(final String key, final Function<String, Optional<String>> yamlMapper, final Properties properties) {
    if ((yamlMapper != null)) {
      final Optional<String> result = yamlMapper.apply(key);
      boolean _isPresent = result.isPresent();
      if (_isPresent) {
        return result.get();
      }
    }
    if ((properties != null)) {
      return properties.getProperty(key);
    }
    return null;
  }
}
