package org.palladiosimulator.retriever.extraction.rules;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

@SuppressWarnings("all")
public class GradleRules implements Rule {
  private static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.gradle";

  private static final String JAVA_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.java";

  private static final String GRADLE_FILE_NAME = "build.gradle";

  @Override
  public void processRules(final RetrieverBlackboard blackboard, final Path path) {
    if (((path != null) && path.getFileName().toString().equals(GradleRules.GRADLE_FILE_NAME))) {
      HashSet<CompilationUnit> children = new HashSet<CompilationUnit>();
      Path parentPath = path.getParent();
      Set<Map.Entry<Path, CompilationUnit>> _entrySet = blackboard.<CompilationUnit>getDiscoveredFiles(GradleRules.JAVA_DISCOVERER_ID, CompilationUnit.class).entrySet();
      for (final Map.Entry<Path, CompilationUnit> entry : _entrySet) {
        boolean _startsWith = entry.getKey().startsWith(parentPath);
        if (_startsWith) {
          children.add(entry.getValue());
        }
      }
      blackboard.addSystemAssociations(path, children);
    }
  }

  @Override
  public boolean isBuildRule() {
    return true;
  }

  @Override
  public Set<String> getConfigurationKeys() {
    return Set.<String>of();
  }

  @Override
  public String getID() {
    return GradleRules.RULE_ID;
  }

  @Override
  public String getName() {
    return "Gradle Rules";
  }

  @Override
  public Set<String> getRequiredServices() {
    return Set.<String>of(GradleRules.JAVA_DISCOVERER_ID);
  }

  @Override
  public Set<String> getDependentServices() {
    return Set.<String>of();
  }
}
