/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.rules;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.retriever.extraction.rules.data.GatewayRoute;
import org.palladiosimulator.retriever.extraction.rules.util.ProjectHelper;
import org.palladiosimulator.retriever.extraction.rules.util.SpringHelper;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class SpringGatewayRules
implements Rule {
    private static final Logger LOG = Logger.getLogger(SpringGatewayRules.class);
    public static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.spring.cloudgateway";
    public static final String YAML_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.yaml";
    public static final String YAML_MAPPERS_KEY = "org.palladiosimulator.retriever.extraction.discoverers.yaml.mappers";
    public static final String XML_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.xml";
    public static final String PROPERTIES_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.properties";
    public static final String ECMASCRIPT_RULE_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript";
    public static final String ECMASCRIPT_ROUTES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.routes";
    public static final String ECMASCRIPT_HOSTNAMES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.hostnames";

    public void processRules(RetrieverBlackboard blackboard, Path path) {
        boolean _containsKey;
        Object _partition = blackboard.getPartition(YAML_DISCOVERER_ID);
        Map rawYamls = (Map)_partition;
        Object _partition_1 = blackboard.getPartition(YAML_MAPPERS_KEY);
        Map yamlMappers = (Map)_partition_1;
        Map propertyFiles = blackboard.getDiscoveredFiles(PROPERTIES_DISCOVERER_ID, Properties.class);
        Path projectRoot = ProjectHelper.findProjectRoot(path, "pom.xml");
        Map<Path, List<GatewayRoute>> routeMap = new HashMap();
        boolean _hasPartition = blackboard.hasPartition(RULE_ID);
        if (_hasPartition) {
            Object _partition_2 = blackboard.getPartition(RULE_ID);
            routeMap = (Map)_partition_2;
        }
        if (_containsKey = routeMap.containsKey(projectRoot)) {
            return;
        }
        Function _xifexpression = null;
        _xifexpression = projectRoot == null ? null : (Function)yamlMappers.get(SpringHelper.findFile(yamlMappers.keySet(), projectRoot.resolve("src/main/resources"), Set.of("bootstrap.yaml", "bootstrap.yml")));
        Function bootstrapYaml = _xifexpression;
        Properties _xifexpression_1 = null;
        _xifexpression_1 = projectRoot == null ? null : (Properties)propertyFiles.get(SpringHelper.findFile(propertyFiles.keySet(), projectRoot.resolve("src/main/resources"), Set.of("application.properties")));
        Properties applicationProperties = _xifexpression_1;
        String applicationName = SpringHelper.getFromYamlOrProperties("spring.application.name", bootstrapYaml, applicationProperties);
        Iterable _xifexpression_2 = null;
        _xifexpression_2 = projectRoot == null ? null : (Iterable)rawYamls.get(SpringHelper.findFile(yamlMappers.keySet(), projectRoot.resolve("src/main/resources"), Set.of("application.yaml", "application.yml")));
        Iterable rawApplicationYaml = _xifexpression_2;
        List<GatewayRoute> routes = this.collectRoutes(rawApplicationYaml);
        for (GatewayRoute route : routes) {
            String _path = route.getPath();
            String _plus = "Route in " + applicationName + ": " + _path;
            String _plus_1 = String.valueOf(_plus) + " -> ";
            String _targetHost = route.getTargetHost();
            String _plus_2 = String.valueOf(_plus_1) + _targetHost;
            LOG.warn((Object)_plus_2);
        }
        routeMap.put(projectRoot, routes);
        boolean _hasPartition_1 = blackboard.hasPartition(RULE_ID);
        if (_hasPartition_1) {
            Object _partition_3 = blackboard.getPartition(RULE_ID);
            ((Map)_partition_3).putAll(routeMap);
        } else {
            blackboard.addPartition(RULE_ID, routeMap);
        }
        boolean _hasPartition_2 = blackboard.hasPartition(ECMASCRIPT_ROUTES_ID);
        if (_hasPartition_2) {
            Object _partition_4 = blackboard.getPartition(ECMASCRIPT_ROUTES_ID);
            Map ecmaScriptRouteMap = (Map)_partition_4;
            boolean _containsKey_1 = ecmaScriptRouteMap.containsKey(projectRoot);
            if (_containsKey_1) {
                ((List)ecmaScriptRouteMap.get(projectRoot)).addAll(routes);
            } else {
                ecmaScriptRouteMap.put(projectRoot, routes);
            }
        } else {
            blackboard.addPartition(ECMASCRIPT_ROUTES_ID, routeMap);
        }
        if (applicationName != null) {
            boolean _not;
            Map<Path, String> hostnameMap = new HashMap<Path, String>();
            boolean _hasPartition_3 = blackboard.hasPartition(ECMASCRIPT_HOSTNAMES_ID);
            if (_hasPartition_3) {
                Object _partition_5 = blackboard.getPartition(ECMASCRIPT_HOSTNAMES_ID);
                hostnameMap = (Map)_partition_5;
            }
            hostnameMap.put(projectRoot, applicationName);
            boolean _hasPartition_4 = blackboard.hasPartition(ECMASCRIPT_HOSTNAMES_ID);
            boolean bl = _not = !_hasPartition_4;
            if (_not) {
                blackboard.addPartition(ECMASCRIPT_HOSTNAMES_ID, hostnameMap);
            }
        }
    }

    public List<GatewayRoute> collectRoutes(Iterable<Map<String, Object>> applicationYamlIter) {
        ArrayList<GatewayRoute> result = new ArrayList<GatewayRoute>();
        if (applicationYamlIter == null || IterableExtensions.isEmpty(applicationYamlIter)) {
            return result;
        }
        Map _get = ((Map[])Conversions.unwrapArray(applicationYamlIter, Map.class))[0];
        Map applicationYaml = _get;
        if (applicationYaml == null) {
            return result;
        }
        Object springObject = applicationYaml.get("spring");
        if (!(springObject instanceof Map)) {
            return result;
        }
        Map spring = (Map)springObject;
        Object cloudObject = spring.get("cloud");
        if (!(cloudObject instanceof Map)) {
            return result;
        }
        Map cloud = (Map)cloudObject;
        Object gatewayObject = cloud.get("gateway");
        if (!(gatewayObject instanceof Map)) {
            return result;
        }
        Map gateway = (Map)gatewayObject;
        Object routesObject = gateway.get("routes");
        if (!(routesObject instanceof List)) {
            return result;
        }
        List routes = (List)routesObject;
        for (Map route : routes) {
            boolean hasUri;
            Object uriObject = route.get("uri");
            Object predicatesObject = route.get("predicates");
            Object filtersObject = route.get("filters");
            Optional<Object> path = Optional.empty();
            if (predicatesObject != null && predicatesObject instanceof List && ((List)predicatesObject).get(0) instanceof String) {
                path = this.getPath((List)predicatesObject);
            }
            int stripPrefixLength = 0;
            if (filtersObject != null && filtersObject instanceof List && ((List)filtersObject).get(0) instanceof String) {
                stripPrefixLength = this.getStripPrefixLength((List)filtersObject);
            }
            boolean bl = hasUri = uriObject != null && uriObject instanceof String;
            if (!path.isPresent() || !hasUri) continue;
            String uri = (String)uriObject;
            String _get_1 = (String)path.get();
            String _hostname = this.toHostname(uri);
            GatewayRoute _gatewayRoute = new GatewayRoute(_get_1, _hostname, stripPrefixLength);
            result.add(_gatewayRoute);
        }
        return result;
    }

    public Optional<String> getPath(List<String> predicates) {
        for (String predicate : predicates) {
            boolean _startsWith = predicate.startsWith("Path=");
            if (!_startsWith) continue;
            return Optional.of(predicate.substring("Path=".length()));
        }
        return Optional.empty();
    }

    public int getStripPrefixLength(List<String> filters) {
        for (String filter : filters) {
            boolean _startsWith = filter.startsWith("StripPrefix=");
            if (!_startsWith) continue;
            String stripPrefixLength = filter.substring("StripPrefix=".length());
            try {
                return Integer.parseInt(stripPrefixLength);
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) {
                    return 0;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return 0;
    }

    public String toHostname(String url) {
        int pathIndex;
        int hostnameStart;
        int portIndex;
        int schemaEnd = url.lastIndexOf("://");
        if (schemaEnd == -1) {
            schemaEnd = -3;
        }
        if ((portIndex = url.indexOf(":", hostnameStart = schemaEnd + 3)) == -1) {
            portIndex = url.length();
        }
        if ((pathIndex = url.indexOf("/", hostnameStart)) == -1) {
            pathIndex = url.length();
        }
        int hostnameEnd = Math.min(portIndex, pathIndex);
        return url.substring(hostnameStart, hostnameEnd);
    }

    public boolean isBuildRule() {
        return false;
    }

    public Set<String> getConfigurationKeys() {
        return Set.of();
    }

    public String getID() {
        return RULE_ID;
    }

    public String getName() {
        return "Spring Cloud Gateway Rules";
    }

    public Set<String> getRequiredServices() {
        return Set.of(YAML_DISCOVERER_ID, XML_DISCOVERER_ID, PROPERTIES_DISCOVERER_ID);
    }

    public Set<String> getDependentServices() {
        return Set.of(ECMASCRIPT_RULE_ID);
    }
}

