/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.rules;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.jdom2.Document;
import org.palladiosimulator.retriever.extraction.commonalities.CompUnitOrName;
import org.palladiosimulator.retriever.extraction.commonalities.HTTPMethod;
import org.palladiosimulator.retriever.extraction.commonalities.InterfaceName;
import org.palladiosimulator.retriever.extraction.commonalities.OperationName;
import org.palladiosimulator.retriever.extraction.commonalities.RESTName;
import org.palladiosimulator.retriever.extraction.commonalities.RESTOperationName;
import org.palladiosimulator.retriever.extraction.engine.PCMDetector;
import org.palladiosimulator.retriever.extraction.engine.RuleHelper;
import org.palladiosimulator.retriever.extraction.rules.util.ProjectHelper;
import org.palladiosimulator.retriever.extraction.rules.util.RESTHelper;
import org.palladiosimulator.retriever.extraction.rules.util.SpringHelper;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class SpringRules
implements Rule {
    private static final Logger LOG = Logger.getLogger(SpringRules.class);
    public static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.spring";
    public static final String JAVA_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.java";
    public static final String YAML_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.yaml";
    public static final String YAML_MAPPERS_KEY = "org.palladiosimulator.retriever.extraction.discoverers.yaml.mappers";
    public static final String XML_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.xml";
    public static final String PROPERTIES_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.properties";
    public static final String ZUUL_RULE_ID = "org.palladiosimulator.retriever.extraction.rules.spring.zuul";
    public static final String CLOUD_GATEWAY_RULE_ID = "org.palladiosimulator.retriever.extraction.rules.spring.cloudgateway";

    public void processRules(RetrieverBlackboard blackboard, Path path) {
        CompilationUnit unit = (CompilationUnit)blackboard.getDiscoveredFiles(JAVA_DISCOVERER_ID, CompilationUnit.class).get(path);
        if (unit == null) {
            return;
        }
        Object _partition = blackboard.getPartition(YAML_DISCOVERER_ID);
        Map rawYamls = (Map)_partition;
        Object _partition_1 = blackboard.getPartition(YAML_MAPPERS_KEY);
        Map yamlMappers = (Map)_partition_1;
        Map poms = blackboard.getDiscoveredFiles(XML_DISCOVERER_ID, Document.class);
        Map propertyFiles = blackboard.getDiscoveredFiles(PROPERTIES_DISCOVERER_ID, Properties.class);
        Path projectRoot = ProjectHelper.findProjectRoot(path, "pom.xml");
        Path configRoot = SpringHelper.findConfigRoot(poms);
        Function _xifexpression = null;
        _xifexpression = projectRoot == null ? null : (Function)yamlMappers.get(SpringHelper.findFile(yamlMappers.keySet(), projectRoot.resolve("src/main/resources"), Set.of("bootstrap.yaml", "bootstrap.yml")));
        Function bootstrapYaml = _xifexpression;
        Properties _xifexpression_1 = null;
        _xifexpression_1 = projectRoot == null ? null : (Properties)propertyFiles.get(SpringHelper.findFile(propertyFiles.keySet(), projectRoot.resolve("src/main/resources"), Set.of("application.properties")));
        Properties applicationProperties = _xifexpression_1;
        String applicationName = SpringHelper.getFromYamlOrProperties("spring.application.name", bootstrapYaml, applicationProperties);
        if (applicationName == null) {
            applicationName = "SPRING-APPLICATION";
        }
        Function _xifexpression_2 = null;
        _xifexpression_2 = configRoot == null ? null : (Function)yamlMappers.get(SpringHelper.findFile(yamlMappers.keySet(), configRoot.resolve("src/main/resources/shared"), Set.of(String.valueOf(applicationName) + ".yaml", String.valueOf(applicationName) + ".yml")));
        Function projectConfigYaml = _xifexpression_2;
        Function<Function, Optional> _function = x -> (Optional)x.apply("server.servlet.context-path");
        Optional contextPathOption = Optional.ofNullable(projectConfigYaml).flatMap(_function);
        String contextPath = contextPathOption.orElse("/");
        Iterable _xifexpression_3 = null;
        _xifexpression_3 = projectRoot == null ? null : (Iterable)rawYamls.get(SpringHelper.findFile(yamlMappers.keySet(), projectRoot.resolve("src/main/resources"), Set.of("application.yaml", "application.yml")));
        Iterable rawApplicationYaml = _xifexpression_3;
        Map<String, String> contextVariables = this.collectContextVariables(rawApplicationYaml);
        this.processRuleForCompUnit(blackboard, unit, applicationName, contextPath, contextVariables);
    }

    public Map<String, String> collectContextVariables(Iterable<Map<String, Object>> applicationYaml) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (applicationYaml == null || IterableExtensions.isEmpty(applicationYaml)) {
            return result;
        }
        return this.collectContextVariables(((Map[])Conversions.unwrapArray(applicationYaml, Map.class))[0]);
    }

    public Map<String, String> collectContextVariables(Map<String, Object> applicationYaml) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (applicationYaml == null) {
            return result;
        }
        Set<Map.Entry<String, Object>> _entrySet = applicationYaml.entrySet();
        for (Map.Entry<String, Object> entry : _entrySet) {
            Object _value = entry.getValue();
            if (_value instanceof Map) {
                Object _value_1 = entry.getValue();
                Map mapValue = (Map)_value_1;
                Set<Map.Entry<String, String>> _entrySet_1 = this.collectContextVariables(mapValue).entrySet();
                for (Map.Entry<String, String> mapEntry : _entrySet_1) {
                    String _key = entry.getKey();
                    String _plus = String.valueOf(_key) + ".";
                    String _key_1 = mapEntry.getKey();
                    String _plus_1 = String.valueOf(_plus) + _key_1;
                    result.put(_plus_1, mapEntry.getValue());
                }
                continue;
            }
            Object _value_2 = entry.getValue();
            if (_value_2 instanceof List) {
                Object _value_3 = entry.getValue();
                List extendedMapValue = (List)_value_3;
                for (Map extendedEntry : extendedMapValue) {
                    Object _get = extendedEntry.get("key");
                    String extendedKey = (String)_get;
                    Object _get_1 = extendedEntry.get("value");
                    String extendedValue = (String)_get_1;
                    if (extendedKey == null || extendedValue == null) continue;
                    boolean _startsWith = extendedValue.startsWith("${");
                    if (_startsWith) {
                        int startIndex = extendedValue.indexOf(":");
                        int endIndex = extendedValue.indexOf("}", startIndex);
                        extendedValue = extendedValue.substring(startIndex + 1, endIndex);
                    }
                    String _key_2 = entry.getKey();
                    String _plus_2 = String.valueOf(_key_2) + ".";
                    String _plus_3 = String.valueOf(_plus_2) + extendedKey;
                    result.put(_plus_3, extendedValue);
                }
                continue;
            }
            Object _value_4 = entry.getValue();
            if (!(_value_4 instanceof String)) continue;
            Object _value_5 = entry.getValue();
            String stringValue = (String)_value_5;
            boolean _startsWith = stringValue.startsWith("${");
            if (_startsWith) {
                int startIndex = stringValue.indexOf(":");
                int endIndex = stringValue.indexOf("}", startIndex);
                stringValue = stringValue.substring(startIndex + 1, endIndex);
            }
            result.put(entry.getKey(), stringValue);
        }
        return result;
    }

    public void processRuleForCompUnit(RetrieverBlackboard blackboard, CompilationUnit unit, String applicationName, String contextPath, Map<String, String> contextVariables) {
        Object _pCMDetector = blackboard.getPCMDetector();
        PCMDetector pcmDetector = (PCMDetector)_pCMDetector;
        if (pcmDetector == null) {
            return;
        }
        if (unit == null) {
            return;
        }
        boolean isService = RuleHelper.isUnitAnnotatedWithName((CompilationUnit)unit, (String[])new String[]{"Service"});
        boolean isController = RuleHelper.isUnitAnnotatedWithName((CompilationUnit)unit, (String[])new String[]{"RestController"}) || RuleHelper.isUnitAnnotatedWithName((CompilationUnit)unit, (String[])new String[]{"Controller"});
        boolean isClient = RuleHelper.isUnitAnnotatedWithName((CompilationUnit)unit, (String[])new String[]{"FeignClient"});
        boolean isRepository = this.isRepository(unit);
        boolean isComponent = isService || isController || isClient || isRepository || RuleHelper.isUnitAnnotatedWithName((CompilationUnit)unit, (String[])new String[]{"Component"});
        CompUnitOrName identifier = new CompUnitOrName(unit);
        boolean _endsWith = identifier.toString().endsWith("Test");
        if (_endsWith) {
            return;
        }
        if (RuleHelper.isAbstraction((CompilationUnit)unit) && !isClient && !isRepository) {
            return;
        }
        if (!isComponent) {
            return;
        }
        pcmDetector.detectComponent(identifier);
        Predicate<MethodDeclaration> _function = c -> RuleHelper.isMethodAnnotatedWithName((MethodDeclaration)c, (String[])new String[]{"Autowired"});
        Function<MethodDeclaration, Stream> _function_1 = c -> RuleHelper.getParameters((MethodDeclaration)c).stream();
        Predicate<SingleVariableDeclaration> _function_2 = p -> {
            boolean _isParameterAnnotatedWith = RuleHelper.isParameterAnnotatedWith((SingleVariableDeclaration)p, (String)"Value");
            return !_isParameterAnnotatedWith;
        };
        Consumer<SingleVariableDeclaration> _function_3 = p -> pcmDetector.detectRequiredInterface(identifier, p);
        RuleHelper.getConstructors((CompilationUnit)unit).stream().filter(_function).flatMap(_function_1).filter(_function_2).forEach(_function_3);
        if (isService || isController) {
            List _fields = RuleHelper.getFields((CompilationUnit)unit);
            for (FieldDeclaration f : _fields) {
                boolean annotated = RuleHelper.isFieldAnnotatedWithName((BodyDeclaration)f, (String)"Autowired");
                if (!annotated && !this.isRepository(f.getType().resolveBinding())) continue;
                pcmDetector.detectRequiredInterface(identifier, f);
            }
            pcmDetector.detectPartOfComposite(identifier, RuleHelper.getUnitName((CompilationUnit)unit));
        }
        if (isController) {
            String requestedUnitMapping = RuleHelper.getUnitAnnotationStringValue((CompilationUnit)unit, (String)"RequestMapping");
            String ifaceName = contextPath;
            if (requestedUnitMapping != null) {
                String _ifaceName = ifaceName;
                ifaceName = String.valueOf(_ifaceName) + requestedUnitMapping;
            }
            List _methods = RuleHelper.getMethods((CompilationUnit)unit);
            for (MethodDeclaration m : _methods) {
                String requestedMapping;
                boolean annotated = this.hasMapping(m);
                if (!annotated || (requestedMapping = this.getMapping(m)) == null) continue;
                requestedMapping = this.substituteVariables(requestedMapping, contextVariables);
                String methodName = String.valueOf(ifaceName) + "/" + requestedMapping;
                methodName = RESTHelper.replaceArgumentsWithWildcards(methodName);
                HTTPMethod httpMethod = this.getHTTPMethod(m);
                IMethodBinding _resolveBinding = m.resolveBinding();
                RESTOperationName _rESTOperationName = new RESTOperationName(applicationName, methodName, new HTTPMethod[]{httpMethod});
                pcmDetector.detectCompositeProvidedOperation(identifier, _resolveBinding, (OperationName)_rESTOperationName);
            }
        }
        if (isClient) {
            String serviceIdentifier = RuleHelper.getUnitAnnotationStringValue((CompilationUnit)unit, (String)"FeignClient", (String)"name");
            if (serviceIdentifier == null) {
                serviceIdentifier = RuleHelper.getUnitAnnotationStringValue((CompilationUnit)unit, (String)"FeignClient");
            }
            String requestedUnitMapping_1 = RuleHelper.getUnitAnnotationStringValue((CompilationUnit)unit, (String)"RequestMapping");
            String ifaceName_1 = "";
            if (requestedUnitMapping_1 != null) {
                String _ifaceName_1 = ifaceName_1;
                ifaceName_1 = String.valueOf(_ifaceName_1) + requestedUnitMapping_1;
            }
            List _methods_1 = RuleHelper.getMethods((CompilationUnit)unit);
            for (MethodDeclaration m_1 : _methods_1) {
                String requestedMapping;
                boolean annotated = this.hasMapping(m_1);
                if (!annotated || (requestedMapping = this.getMapping(m_1)) == null) continue;
                requestedMapping = this.substituteVariables(requestedMapping, contextVariables);
                String methodName = String.valueOf(ifaceName_1) + "/" + requestedMapping;
                methodName = RESTHelper.replaceArgumentsWithWildcards(methodName);
                RESTName _rESTName = new RESTName(serviceIdentifier, methodName);
                pcmDetector.detectCompositeRequiredInterface(identifier, (InterfaceName)_rESTName);
            }
        }
        List _allAbstractParents = RuleHelper.getAllAbstractParents((CompilationUnit)unit);
        for (Type parent : _allAbstractParents) {
            ITypeBinding parentBinding = parent.resolveBinding();
            if (parentBinding == null || parentBinding.getName().endsWith("Repository")) continue;
            pcmDetector.detectProvidedInterfaceWeakly(identifier, parentBinding);
            List _methods_2 = RuleHelper.getMethods((Type)parent);
            for (IMethodBinding m_2 : _methods_2) {
                pcmDetector.detectProvidedOperationWeakly(identifier, parentBinding, m_2);
            }
        }
    }

    public String substituteVariables(String string, Map<String, String> contextVariables) {
        String result = string;
        while (result.contains("${")) {
            String _plus_3;
            int endIndex;
            int startIndex = result.indexOf("${");
            String key = result.substring(startIndex + 2, endIndex = result.indexOf("}", startIndex));
            String value = contextVariables.get(key);
            if (value != null) {
                String _plus_1;
                String _substring = result.substring(0, startIndex);
                String _plus = String.valueOf(_substring) + value;
                String _substring_1 = result.substring(endIndex + 1);
                result = _plus_1 = String.valueOf(_plus) + _substring_1;
                continue;
            }
            String _substring_2 = result.substring(0, startIndex);
            String _plus_2 = String.valueOf(_substring_2) + "ERROR_COULD_NOT_RESOLVE";
            String _substring_3 = result.substring(endIndex + 1);
            result = _plus_3 = String.valueOf(_plus_2) + _substring_3;
            LOG.error((Object)("Could not resolve key " + key));
        }
        return result;
    }

    public boolean hasMapping(MethodDeclaration m) {
        return RuleHelper.isMethodAnnotatedWithName((MethodDeclaration)m, (String[])new String[]{"RequestMapping"}) || RuleHelper.isMethodAnnotatedWithName((MethodDeclaration)m, (String[])new String[]{"GetMapping"}) || RuleHelper.isMethodAnnotatedWithName((MethodDeclaration)m, (String[])new String[]{"PostMapping"}) || RuleHelper.isMethodAnnotatedWithName((MethodDeclaration)m, (String[])new String[]{"PutMapping"}) || RuleHelper.isMethodAnnotatedWithName((MethodDeclaration)m, (String[])new String[]{"DeleteMapping"}) || RuleHelper.isMethodAnnotatedWithName((MethodDeclaration)m, (String[])new String[]{"PatchMapping"});
    }

    public String getMapping(MethodDeclaration m) {
        String requestMapping = this.getMappingString(m, "RequestMapping");
        if (requestMapping != null) {
            return requestMapping;
        }
        String getMapping = this.getMappingString(m, "GetMapping");
        if (getMapping != null) {
            return getMapping;
        }
        String postMapping = this.getMappingString(m, "PostMapping");
        if (postMapping != null) {
            return postMapping;
        }
        String putMapping = this.getMappingString(m, "PutMapping");
        if (putMapping != null) {
            return putMapping;
        }
        String deleteMapping = this.getMappingString(m, "DeleteMapping");
        if (deleteMapping != null) {
            return deleteMapping;
        }
        String patchMapping = this.getMappingString(m, "PatchMapping");
        if (patchMapping != null) {
            return patchMapping;
        }
        return null;
    }

    public HTTPMethod getHTTPMethod(MethodDeclaration m) {
        String requestMapping = this.getMappingString(m, "RequestMapping");
        if (requestMapping != null) {
            return HTTPMethod.WILDCARD;
        }
        String getMapping = this.getMappingString(m, "GetMapping");
        if (getMapping != null) {
            return HTTPMethod.GET;
        }
        String postMapping = this.getMappingString(m, "PostMapping");
        if (postMapping != null) {
            return HTTPMethod.POST;
        }
        String putMapping = this.getMappingString(m, "PutMapping");
        if (putMapping != null) {
            return HTTPMethod.PUT;
        }
        String deleteMapping = this.getMappingString(m, "DeleteMapping");
        if (deleteMapping != null) {
            return HTTPMethod.DELETE;
        }
        String patchMapping = this.getMappingString(m, "PatchMapping");
        if (patchMapping != null) {
            return HTTPMethod.PATCH;
        }
        return null;
    }

    public String getMappingString(MethodDeclaration m, String annotationName) {
        String value = RuleHelper.getMethodAnnotationStringValue((MethodDeclaration)m, (String)annotationName);
        if (value != null) {
            return value;
        }
        String path = RuleHelper.getMethodAnnotationStringValue((MethodDeclaration)m, (String)annotationName, (String)"path");
        return path;
    }

    public boolean isRepository(ITypeBinding binding) {
        return RuleHelper.isImplementingOrExtending((ITypeBinding)binding, (String)"Repository") || RuleHelper.isImplementingOrExtending((ITypeBinding)binding, (String)"CrudRepository") || RuleHelper.isImplementingOrExtending((ITypeBinding)binding, (String)"JpaRepository") || RuleHelper.isImplementingOrExtending((ITypeBinding)binding, (String)"PagingAndSortingRepository") || RuleHelper.isImplementingOrExtending((ITypeBinding)binding, (String)"MongoRepository");
    }

    public boolean isRepository(CompilationUnit unit) {
        return RuleHelper.isUnitAnnotatedWithName((CompilationUnit)unit, (String[])new String[]{"Repository"}) || RuleHelper.isImplementingOrExtending((CompilationUnit)unit, (String)"Repository") || RuleHelper.isImplementingOrExtending((CompilationUnit)unit, (String)"CrudRepository") || RuleHelper.isImplementingOrExtending((CompilationUnit)unit, (String)"JpaRepository") || RuleHelper.isImplementingOrExtending((CompilationUnit)unit, (String)"PagingAndSortingRepository") || RuleHelper.isImplementingOrExtending((CompilationUnit)unit, (String)"MongoRepository");
    }

    public boolean isBuildRule() {
        return false;
    }

    public Set<String> getConfigurationKeys() {
        return Set.of();
    }

    public String getID() {
        return RULE_ID;
    }

    public String getName() {
        return "Spring Rules";
    }

    public Set<String> getRequiredServices() {
        return Set.of(JAVA_DISCOVERER_ID, YAML_DISCOVERER_ID, XML_DISCOVERER_ID, PROPERTIES_DISCOVERER_ID, ZUUL_RULE_ID, CLOUD_GATEWAY_RULE_ID);
    }

    public Set<String> getDependentServices() {
        return Set.of();
    }
}

