/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.rules.data;

import java.util.List;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.retriever.extraction.commonalities.RESTName;

public class GatewayRoute {
    private static final String TRAILING_WILDCARD = "/**";
    private String pathPattern;
    private String targetHost;
    private int stripPrefixLength;

    public GatewayRoute(String path, String serviceId, boolean stripPrefix) {
        this.pathPattern = path;
        this.targetHost = serviceId;
        int _xifexpression = 0;
        _xifexpression = stripPrefix ? GatewayRoute.calculateStripPrefixLength(this.pathPattern) : 0;
        this.stripPrefixLength = _xifexpression;
    }

    public GatewayRoute(String path, String serviceId, int stripPrefixLength) {
        this.pathPattern = path;
        this.targetHost = serviceId;
        this.stripPrefixLength = stripPrefixLength;
    }

    public String getPath() {
        return this.pathPattern;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public boolean matches(String url) {
        boolean _endsWith = this.pathPattern.endsWith(TRAILING_WILDCARD);
        if (_endsWith) {
            int _length = this.pathPattern.length();
            int _length_1 = TRAILING_WILDCARD.length();
            int _minus = _length - _length_1;
            String prefix = this.pathPattern.substring(0, _minus);
            return url.startsWith(prefix);
        }
        return this.pathPattern.equals(url);
    }

    public RESTName applyTo(String url) {
        boolean _lessThan;
        String[] urlSegments = GatewayRoute.toSegments(url);
        String newUrl = "";
        int _length = urlSegments.length;
        boolean bl = _lessThan = this.stripPrefixLength < _length;
        if (_lessThan) {
            List newUrlSegments = ((List)Conversions.doWrapArray((Object)urlSegments)).subList(this.stripPrefixLength, urlSegments.length);
            newUrl = GatewayRoute.toPath((String[])Conversions.unwrapArray(newUrlSegments, String.class));
        }
        return new RESTName(this.targetHost, newUrl);
    }

    private static int calculateStripPrefixLength(String pathPattern) {
        boolean _endsWith = pathPattern.endsWith(TRAILING_WILDCARD);
        if (_endsWith) {
            return GatewayRoute.toSegments(pathPattern).length;
        }
        return 0;
    }

    private static String[] toSegments(String path) {
        String[] segments = path.split("/");
        if (segments.length > 0 && segments[0].isEmpty()) {
            return (String[])Conversions.unwrapArray(((List)Conversions.doWrapArray((Object)segments)).subList(1, segments.length), String.class);
        }
        return segments;
    }

    private static String toPath(String[] segments) {
        String _join = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)segments)), (CharSequence)"/");
        return "/" + _join;
    }
}

