/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.rules;

import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.core.XtendInjectorSingleton;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class ProjectSpecificRulesProxy
implements Rule {
    public static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.project_specific";
    public static final String LOADED_CLASS_NAME = "org.palladiosimulator.retriever.extraction.rules.ProjectSpecificRules";
    public static final String RULE_PATH_KEY = "xtend_dir_path";
    private Optional<Rule> innerRule = Optional.empty();

    public IBlackboardInteractingJob<RetrieverBlackboard> create(RetrieverConfiguration config, RetrieverBlackboard blackboard) {
        try {
            IBlackboardInteractingJob _xblockexpression = null;
            File rulesDirectory = this.getConfiguredRulesDirectory(config);
            String _string = rulesDirectory.toString();
            String _plus = String.valueOf(_string) + "-xtend-gen";
            File xtendGenDirectory = new File(_plus);
            if (!xtendGenDirectory.exists() && !xtendGenDirectory.mkdirs()) {
                throw new IOException("Could not create intermediate compilation directory at " + xtendGenDirectory);
            }
            this.compileXtend(rulesDirectory, xtendGenDirectory);
            this.compileJava(xtendGenDirectory);
            URL classDirectoryURL = xtendGenDirectory.toURI().toURL();
            ClassLoader _classLoader = this.getClass().getClassLoader();
            URLClassLoader classLoader = new URLClassLoader(new URL[]{classDirectoryURL}, _classLoader);
            Object _xtrycatchfinallyexpression = null;
            try {
                Object _xblockexpression_1 = null;
                Class<?> loadedClass = classLoader.loadClass(LOADED_CLASS_NAME);
                _xtrycatchfinallyexpression = _xblockexpression_1 = loadedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable _t) {
                if (_t instanceof ClassNotFoundException) {
                    ClassNotFoundException exception = (ClassNotFoundException)_t;
                    throw new IllegalArgumentException("Could not find project-specific rule. It must have the fully qualified name org.palladiosimulator.retriever.extraction.rules.ProjectSpecificRules", exception);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Object ruleInstance = _xtrycatchfinallyexpression;
            this.innerRule = Optional.of(ruleInstance);
            _xblockexpression = this.innerRule.get().create(config, blackboard);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public File getConfiguredRulesDirectory(RetrieverConfiguration config) {
        boolean _tripleNotEquals;
        String configuredValue = config.getConfig(Rule.class).getConfig(RULE_ID, RULE_PATH_KEY);
        if (configuredValue != null && !configuredValue.isBlank()) {
            return new File(configuredValue);
        }
        URI _rulesFolder = config.getRulesFolder();
        boolean bl = _tripleNotEquals = _rulesFolder != null;
        if (_tripleNotEquals) {
            URI localURI = CommonPlugin.asLocalURI((URI)config.getRulesFolder());
            String _devicePath = localURI.devicePath();
            return new File(_devicePath);
        }
        throw new IllegalArgumentException("No path for project-specific rules is specified");
    }

    public void compileXtend(File inputDirectory, File outputDirectory) {
        boolean _not;
        XtendBatchCompiler compiler = (XtendBatchCompiler)XtendInjectorSingleton.INJECTOR.getInstance(XtendBatchCompiler.class);
        compiler.setSourcePath(inputDirectory.toString());
        compiler.setOutputPath(outputDirectory.toString());
        compiler.setCurrentClassLoader(this.getClass().getClassLoader());
        compiler.setUseCurrentClassLoaderAsParent(true);
        boolean _compile = compiler.compile();
        boolean bl = _not = !_compile;
        if (_not) {
            throw new IllegalArgumentException("Could not compile xtend files located in " + inputDirectory);
        }
    }

    public void compileJava(File inOutDirectory) {
        boolean _not;
        Path sourcePath = inOutDirectory.toPath().resolve("org").resolve("palladiosimulator").resolve("retriever").resolve("extraction").resolve("rules").resolve("ProjectSpecificRules.java");
        String _path = Platform.getInstallLocation().getURL().getPath();
        Path workingDirectory = new File(_path).toPath();
        Path jarpath = workingDirectory.resolve("plugins").resolve("*");
        String classpath = this.buildClassPath(jarpath.toString());
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        List<String> compilerOptions = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"-classpath", classpath}));
        Iterable<? extends JavaFileObject> sourceFile = fileManager.getJavaFileObjects(sourcePath);
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, fileManager, null, compilerOptions, null, sourceFile);
        Boolean _call = compilationTask.call();
        boolean bl = _not = _call == false;
        if (_not) {
            throw new IllegalArgumentException("Could not compile java files generated from xtend files located in " + inOutDirectory);
        }
    }

    public String buildClassPath(String ... paths) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            boolean _endsWith = path.endsWith("*");
            if (_endsWith) {
                File[] _listFiles;
                int _length = path.length();
                int _minus = _length - 1;
                String subPath = path.substring(0, _minus);
                File pathFile = new File(subPath);
                File[] fileArray = _listFiles = pathFile.listFiles();
                int n3 = _listFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray[n4];
                    if (file.isFile() && file.getName().endsWith(".jar")) {
                        sb.append(subPath);
                        sb.append(file.getName());
                        sb.append(System.getProperty("path.separator"));
                    }
                    ++n4;
                }
            } else {
                sb.append(path);
                sb.append(System.getProperty("path.separator"));
            }
            ++n2;
        }
        return sb.toString();
    }

    public boolean isBuildRule() {
        return false;
    }

    public void processRules(RetrieverBlackboard blackboard, Path path) {
        Consumer<Rule> _function = x -> x.processRules(blackboard, path);
        this.innerRule.ifPresent(_function);
    }

    public Set<String> getConfigurationKeys() {
        return Set.of(RULE_PATH_KEY);
    }

    public Set<String> getDependentServices() {
        return Set.of();
    }

    public String getID() {
        return RULE_ID;
    }

    public String getName() {
        return "Project-Specific Rules";
    }

    public Set<String> getRequiredServices() {
        HashSet<String> _xblockexpression = null;
        HashSet<String> requirements = new HashSet<String>();
        requirements.add(null);
        _xblockexpression = requirements;
        return _xblockexpression;
    }
}

