/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.rules;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openjdk.nashorn.api.tree.BinaryTree;
import org.openjdk.nashorn.api.tree.CompilationUnitTree;
import org.openjdk.nashorn.api.tree.ExpressionTree;
import org.openjdk.nashorn.api.tree.FunctionCallTree;
import org.openjdk.nashorn.api.tree.FunctionDeclarationTree;
import org.openjdk.nashorn.api.tree.IdentifierTree;
import org.openjdk.nashorn.api.tree.LiteralTree;
import org.openjdk.nashorn.api.tree.MemberSelectTree;
import org.openjdk.nashorn.api.tree.ObjectLiteralTree;
import org.openjdk.nashorn.api.tree.PropertyTree;
import org.openjdk.nashorn.api.tree.SimpleTreeVisitorES6;
import org.openjdk.nashorn.api.tree.Tree;
import org.openjdk.nashorn.api.tree.TreeVisitor;
import org.openjdk.nashorn.api.tree.VariableTree;
import org.palladiosimulator.retriever.extraction.commonalities.CompUnitOrName;
import org.palladiosimulator.retriever.extraction.commonalities.HTTPMethod;
import org.palladiosimulator.retriever.extraction.commonalities.InterfaceName;
import org.palladiosimulator.retriever.extraction.commonalities.OperationName;
import org.palladiosimulator.retriever.extraction.commonalities.RESTName;
import org.palladiosimulator.retriever.extraction.commonalities.RESTOperationName;
import org.palladiosimulator.retriever.extraction.engine.PCMDetector;
import org.palladiosimulator.retriever.extraction.rules.data.GatewayRoute;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class EcmaScriptRules
implements Rule {
    public static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript";
    public static final String ECMASCRIPT_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.ecmascript";
    public static final String HOSTNAMES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.hostnames";
    public static final String GATEWAY_ROUTES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.routes";
    public static final String DONE_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.done";
    private static final CompUnitOrName GATEWAY_NAME = new CompUnitOrName("Gateway");
    private static final String START_NONWORD_CHARS = "^[\\W]+";
    private static final String SEPARATOR = ".";
    private static final String URL_KEYWORD = "url";
    private static final String HTTP_KEYWORD = "http";
    private static final String[] HTTP_REQUESTS = new String[]{"connect", "delete", "get", "head", "options", "patch", "post", "put", "trace"};
    private static final String VARIABLE_PREFIX = ":";
    private static final String BLANK = "";

    public void processRules(RetrieverBlackboard blackboard, Path path) {
        boolean _isEmpty_1;
        boolean _not;
        boolean _hasPartition = blackboard.hasPartition(DONE_ID);
        if (_hasPartition) {
            return;
        }
        Map compilationUnits = blackboard.getDiscoveredFiles(ECMASCRIPT_DISCOVERER_ID, CompilationUnitTree.class);
        CompilationUnitTree compilationUnit = (CompilationUnitTree)compilationUnits.get(path);
        if (compilationUnit == null && !compilationUnits.isEmpty()) {
            return;
        }
        Object _partition = blackboard.getPartition(GATEWAY_ROUTES_ID);
        Map gatewayRouteMap = (Map)_partition;
        if (gatewayRouteMap == null) {
            gatewayRouteMap = Map.of();
        }
        List gatewayRoutes = List.of();
        Path mostSpecificGatewayPath = null;
        Set _keySet = gatewayRouteMap.keySet();
        for (Path gatewayPath : _keySet) {
            if (gatewayPath == null || !path.startsWith(gatewayPath) || mostSpecificGatewayPath != null && !gatewayPath.startsWith(mostSpecificGatewayPath)) continue;
            gatewayRoutes = (List)gatewayRouteMap.get(gatewayPath);
            mostSpecificGatewayPath = gatewayPath;
        }
        Map hostnameMap = Map.of();
        boolean _hasPartition_1 = blackboard.hasPartition(HOSTNAMES_ID);
        if (_hasPartition_1) {
            Object _partition_1 = blackboard.getPartition(HOSTNAMES_ID);
            hostnameMap = (Map)_partition_1;
        }
        String hostname = "API-HOST";
        Path mostSpecificHostnamePath = null;
        Set _keySet_1 = hostnameMap.keySet();
        for (Path hostnamePath : _keySet_1) {
            if (hostnamePath == null || !path.startsWith(hostnamePath) || mostSpecificHostnamePath != null && !hostnamePath.startsWith(mostSpecificHostnamePath)) continue;
            hostname = (String)hostnameMap.get(hostnamePath);
            mostSpecificHostnamePath = hostnamePath;
        }
        Map<Object, Object> httpRequests = Map.of();
        Object _pCMDetector = blackboard.getPCMDetector();
        PCMDetector pcmDetector = (PCMDetector)_pCMDetector;
        boolean _isEmpty = compilationUnits.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            httpRequests = this.findAllHttpRequests(blackboard, compilationUnit);
            Set<Object> _keySet_2 = httpRequests.keySet();
            for (String string : _keySet_2) {
                Set _get = (Set)httpRequests.get(string);
                for (String url : _get) {
                    boolean _not_1;
                    RESTName mappedURL = this.mapURL(hostname, "/" + url, gatewayRoutes);
                    boolean _isPartOf = mappedURL.isPartOf("/" + hostname);
                    boolean bl2 = _not_1 = !_isPartOf;
                    if (_not_1) {
                        pcmDetector.detectCompositeRequiredInterface(GATEWAY_NAME, (InterfaceName)mappedURL);
                    }
                    RESTOperationName _rESTOperationName = new RESTOperationName(hostname, "/" + url, new HTTPMethod[0]);
                    pcmDetector.detectProvidedOperation(GATEWAY_NAME, null, (OperationName)_rESTOperationName);
                }
            }
        }
        if (_isEmpty_1 = httpRequests.isEmpty()) {
            for (GatewayRoute gatewayRoute : gatewayRoutes) {
                boolean _not_1;
                String _targetHost = gatewayRoute.getTargetHost();
                RESTName mappedURL = new RESTName(_targetHost, "/");
                boolean _isPartOf = mappedURL.isPartOf("/" + hostname);
                boolean bl3 = _not_1 = !_isPartOf;
                if (_not_1) {
                    pcmDetector.detectCompositeRequiredInterface(GATEWAY_NAME, (InterfaceName)mappedURL);
                }
                RESTOperationName _rESTOperationName = new RESTOperationName(hostname, "/", new HTTPMethod[0]);
                pcmDetector.detectProvidedOperation(GATEWAY_NAME, null, (OperationName)_rESTOperationName);
            }
            blackboard.addPartition(DONE_ID, (Object)true);
        }
    }

    public Map<String, Set<String>> findAllHttpRequests(RetrieverBlackboard blackboard, CompilationUnitTree unit) {
        String _sourceName = unit.getSourceName();
        int _lastIndexOf = unit.getSourceName().lastIndexOf(SEPARATOR);
        int _plus = _lastIndexOf + 1;
        String source = _sourceName.substring(0, _plus);
        HashMap<String, String> assignments = this.findVariableAssignments((Tree)unit);
        HashMap<String, Collection<String>> requests = EcmaScriptRules.join(this.findFunctionCallsWithUrls((Tree)unit), this.findFunctionDeclarationsWithUrls((Tree)unit), this.findDirectHttpRequest((Tree)unit));
        HashMap<String, Set<String>> normalizedRequests = new HashMap<String, Set<String>>();
        Set<String> _keySet = requests.keySet();
        for (String key : _keySet) {
            HashSet<String> resolvedUrls = new HashSet<String>();
            Collection<String> _get = requests.get(key);
            for (String url : _get) {
                boolean _startsWith = url.startsWith(VARIABLE_PREFIX);
                if (_startsWith) {
                    boolean _containsKey = assignments.containsKey(url);
                    if (!_containsKey) continue;
                    resolvedUrls.add(assignments.get(url));
                    continue;
                }
                resolvedUrls.add(url);
            }
            HashSet<String> urlsWithWildcards = new HashSet<String>();
            for (String url_1 : resolvedUrls) {
                String urlWithoutInteriorParameters = url_1.replaceAll(":.+?/", "*/");
                String urlWithoutParameters = urlWithoutInteriorParameters.replaceAll(":.*", "*");
                urlsWithWildcards.add(urlWithoutParameters);
            }
            String _replaceAll = key.replaceAll(START_NONWORD_CHARS, BLANK);
            String _plus_1 = String.valueOf(source) + _replaceAll;
            normalizedRequests.put(_plus_1, urlsWithWildcards);
        }
        return normalizedRequests;
    }

    public Map<String, Set<String>> findDirectHttpRequest(Tree element) {
        final HashMap<String, Set<String>> calls = new HashMap<String, Set<String>>();
        element.accept((TreeVisitor)new SimpleTreeVisitorES6<Void, Void>(){

            public Void visitFunctionCall(FunctionCallTree node, Void v) {
                ExpressionTree memberObject = node.getFunctionSelect();
                if (memberObject instanceof MemberSelectTree && Arrays.stream(HTTP_REQUESTS).filter(r -> r.equalsIgnoreCase(((MemberSelectTree)memberObject).getIdentifier())).findAny().isPresent() && ((MemberSelectTree)memberObject).getExpression() instanceof IdentifierTree && ((IdentifierTree)((MemberSelectTree)memberObject).getExpression()).getName().toLowerCase().contains(EcmaScriptRules.HTTP_KEYWORD)) {
                    boolean _not;
                    MemberSelectTree member = (MemberSelectTree)memberObject;
                    ExpressionTree _expression = member.getExpression();
                    IdentifierTree identifier = (IdentifierTree)_expression;
                    String _name = identifier.getName();
                    String _plus = String.valueOf(_name) + EcmaScriptRules.SEPARATOR;
                    String _identifier = member.getIdentifier();
                    String caller = String.valueOf(_plus) + _identifier;
                    HashSet<String> urls = EcmaScriptRules.this.findLiteralsInArguments(node.getArguments());
                    boolean _isEmpty = urls.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        boolean _containsKey = calls.containsKey(caller);
                        if (_containsKey) {
                            ((Set)calls.get(caller)).addAll(urls);
                        } else {
                            calls.put(caller, urls);
                        }
                    }
                }
                return (Void)super.visitFunctionCall(node, null);
            }
        }, null);
        return calls;
    }

    public HashMap<String, HashSet<String>> findFunctionCallsWithUrls(Tree element) {
        final HashMap<String, HashSet<String>> calls = new HashMap<String, HashSet<String>>();
        element.accept((TreeVisitor)new SimpleTreeVisitorES6<Void, Void>(){

            public Void visitFunctionCall(FunctionCallTree functionCallTree, Void v) {
                boolean _isBlank;
                boolean _not;
                HashSet<String> urls = new HashSet<String>();
                String literalValue = EcmaScriptRules.BLANK;
                List _arguments = functionCallTree.getArguments();
                for (ExpressionTree argument : _arguments) {
                    urls.addAll(EcmaScriptRules.this.findLiteralsForIdentifier((Tree)argument, EcmaScriptRules.URL_KEYWORD));
                }
                boolean _isEmpty = urls.isEmpty();
                if (_isEmpty) {
                    return null;
                }
                if (functionCallTree.getFunctionSelect() instanceof MemberSelectTree && ((MemberSelectTree)functionCallTree.getFunctionSelect()).getExpression() instanceof FunctionCallTree) {
                    ExpressionTree _functionSelect = functionCallTree.getFunctionSelect();
                    ExpressionTree _expression = ((MemberSelectTree)_functionSelect).getExpression();
                    boolean _isEmpty_1 = ((FunctionCallTree)_expression).getArguments().isEmpty();
                    if (_isEmpty_1) {
                        return (Void)super.visitFunctionCall(functionCallTree, null);
                    }
                    ExpressionTree _functionSelect_1 = functionCallTree.getFunctionSelect();
                    ExpressionTree _expression_1 = ((MemberSelectTree)_functionSelect_1).getExpression();
                    ExpressionTree _get = (ExpressionTree)((FunctionCallTree)_expression_1).getArguments().get(0);
                    if (_get instanceof LiteralTree) {
                        ExpressionTree _functionSelect_2 = functionCallTree.getFunctionSelect();
                        ExpressionTree _expression_2 = ((MemberSelectTree)_functionSelect_2).getExpression();
                        ExpressionTree _get_1 = (ExpressionTree)((FunctionCallTree)_expression_2).getArguments().get(0);
                        LiteralTree literal = (LiteralTree)_get_1;
                        literalValue = String.valueOf(literal.getValue());
                    }
                }
                boolean bl = _not = !(_isBlank = literalValue.isBlank());
                if (_not) {
                    calls.put(literalValue, urls);
                }
                return (Void)super.visitFunctionCall(functionCallTree, null);
            }
        }, null);
        return calls;
    }

    public Map<String, Set<String>> findFunctionDeclarationsWithUrls(Tree element) {
        final HashMap<String, Set<String>> declarations = new HashMap<String, Set<String>>();
        element.accept((TreeVisitor)new SimpleTreeVisitorES6<Void, Void>(){

            public Void visitFunctionDeclaration(FunctionDeclarationTree functionDeclaration, Void v) {
                boolean _not;
                HashSet<String> urls = EcmaScriptRules.this.findLiteralsForIdentifier((Tree)functionDeclaration, EcmaScriptRules.URL_KEYWORD);
                boolean _isEmpty = urls.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    boolean _containsKey = declarations.containsKey(functionDeclaration);
                    if (_containsKey) {
                        ((Set)declarations.get(functionDeclaration.getName().getName())).addAll(urls);
                    } else {
                        declarations.put(functionDeclaration.getName().getName(), urls);
                    }
                }
                return (Void)super.visitFunctionDeclaration(functionDeclaration, null);
            }
        }, null);
        return declarations;
    }

    public String findLiteralInExpression(ExpressionTree expression) {
        if (expression != null) {
            boolean _matched = false;
            if (expression instanceof LiteralTree) {
                _matched = true;
                return String.valueOf(((LiteralTree)expression).getValue());
            }
            if (!_matched && expression instanceof IdentifierTree) {
                _matched = true;
                String _valueOf = String.valueOf(((IdentifierTree)expression).getName());
                return VARIABLE_PREFIX + _valueOf;
            }
            if (!_matched && expression instanceof MemberSelectTree) {
                _matched = true;
                String _valueOf = String.valueOf(((MemberSelectTree)expression).getIdentifier());
                return VARIABLE_PREFIX + _valueOf;
            }
            if (!_matched && expression instanceof BinaryTree) {
                _matched = true;
                String _findLiteralInExpression = this.findLiteralInExpression(((BinaryTree)expression).getLeftOperand());
                String _findLiteralInExpression_1 = this.findLiteralInExpression(((BinaryTree)expression).getRightOperand());
                return String.valueOf(_findLiteralInExpression) + _findLiteralInExpression_1;
            }
        }
        return BLANK;
    }

    public HashSet<String> findLiteralsForIdentifier(Tree element, final String identifier) {
        final HashSet<String> literals = new HashSet<String>();
        element.accept((TreeVisitor)new SimpleTreeVisitorES6<Void, Void>(){

            public Void visitObjectLiteral(ObjectLiteralTree objectLiteral, Void v) {
                List _properties = objectLiteral.getProperties();
                for (PropertyTree property : _properties) {
                    if (!(property.getKey() instanceof IdentifierTree) || !identifier.equalsIgnoreCase(((IdentifierTree)property.getKey()).getName())) continue;
                    literals.add(EcmaScriptRules.this.findLiteralInExpression(property.getValue()));
                    return (Void)super.visitObjectLiteral(objectLiteral, null);
                }
                return (Void)super.visitObjectLiteral(objectLiteral, null);
            }
        }, null);
        return literals;
    }

    public HashSet<String> findLiteralsInArguments(List<? extends ExpressionTree> arguments) {
        HashSet<String> urls = new HashSet<String>();
        for (ExpressionTree expressionTree : arguments) {
            boolean _not;
            String url = this.findLiteralInExpression(expressionTree);
            boolean _isBlank = url.isBlank();
            boolean bl = _not = !_isBlank;
            if (!_not) continue;
            urls.add(url);
        }
        return urls;
    }

    public HashMap<String, String> findVariableAssignments(Tree element) {
        final HashMap<String, String> assignments = new HashMap<String, String>();
        element.accept((TreeVisitor)new SimpleTreeVisitorES6<Void, Void>(){

            public Void visitVariable(VariableTree node, Void v) {
                ExpressionTree binding = node.getBinding();
                String _switchResult = null;
                boolean _matched = false;
                if (binding instanceof MemberSelectTree) {
                    _matched = true;
                    _switchResult = ((MemberSelectTree)binding).getIdentifier();
                }
                if (!_matched && binding instanceof IdentifierTree) {
                    _matched = true;
                    _switchResult = ((IdentifierTree)binding).getName();
                }
                if (!_matched) {
                    _switchResult = EcmaScriptRules.BLANK;
                }
                String id = _switchResult;
                String url = EcmaScriptRules.this.findLiteralInExpression(node.getInitializer());
                if (!id.isBlank() && !url.isBlank()) {
                    assignments.put(EcmaScriptRules.VARIABLE_PREFIX + id, url);
                }
                return (Void)super.visitVariable(node, null);
            }
        }, null);
        return assignments;
    }

    public static HashMap<String, Collection<String>> join(Map<String, ? extends Set<String>> ... maps) {
        HashMap<String, Collection<String>> join = new HashMap<String, Collection<String>>();
        Map<String, ? extends Set<String>>[] mapArray = maps;
        int n = maps.length;
        int n2 = 0;
        while (n2 < n) {
            Map<String, ? extends Set<String>> map = mapArray[n2];
            Set<String> _keySet = map.keySet();
            for (String key : _keySet) {
                boolean _containsKey = join.containsKey(key);
                if (_containsKey) {
                    Iterables.addAll(join.get(key), (Iterable)map.get(key));
                    continue;
                }
                join.put(key, (Collection<String>)map.get(key));
            }
            ++n2;
        }
        return join;
    }

    public RESTName mapURL(String host, String url, List<GatewayRoute> routes) {
        for (GatewayRoute route : routes) {
            boolean _matches = route.matches(url);
            if (!_matches) continue;
            return route.applyTo(url);
        }
        return new RESTName(host, url);
    }

    public boolean isBuildRule() {
        return false;
    }

    public Set<String> getConfigurationKeys() {
        return Set.of();
    }

    public String getID() {
        return RULE_ID;
    }

    public String getName() {
        return "ECMAScript Rules";
    }

    public Set<String> getRequiredServices() {
        return Set.of(ECMASCRIPT_DISCOVERER_ID);
    }

    public Set<String> getDependentServices() {
        return Set.of();
    }
}

