/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class CompUnitOrName {
    private final Optional<CompilationUnit> compilationUnit;
    private final String name;

    public CompUnitOrName(String name) {
        this.compilationUnit = Optional.empty();
        this.name = name;
    }

    public CompUnitOrName(CompilationUnit compilationUnit) {
        this.compilationUnit = Optional.of(compilationUnit);
        this.name = CompUnitOrName.toName(compilationUnit);
    }

    public boolean isUnit() {
        return this.compilationUnit.isPresent();
    }

    public Optional<CompilationUnit> compilationUnit() {
        return this.compilationUnit;
    }

    public String name() {
        return this.name;
    }

    private static String toName(CompilationUnit compilationUnit) {
        List types = compilationUnit.types();
        if (types.isEmpty()) {
            return "void";
        }
        AbstractTypeDeclaration firstTypeDecl = (AbstractTypeDeclaration)types.get(0);
        ITypeBinding binding = firstTypeDecl.resolveBinding();
        if (binding == null) {
            return firstTypeDecl.getName().getFullyQualifiedName();
        }
        return binding.getQualifiedName();
    }

    public int hashCode() {
        return Objects.hash(this.compilationUnit, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompUnitOrName other = (CompUnitOrName)obj;
        return Objects.equals(this.compilationUnit, other.compilationUnit) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return this.name();
    }
}

