/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.retriever.extraction.commonalities.CompUnitOrName;
import org.palladiosimulator.retriever.extraction.commonalities.Component;
import org.palladiosimulator.retriever.extraction.commonalities.ComponentBuilder;
import org.palladiosimulator.retriever.extraction.commonalities.Composite;
import org.palladiosimulator.retriever.extraction.commonalities.CompositeBuilder;
import org.palladiosimulator.retriever.extraction.commonalities.Operation;
import org.palladiosimulator.retriever.extraction.commonalities.OperationInterface;
import org.palladiosimulator.retriever.extraction.commonalities.ProvisionsBuilder;
import org.palladiosimulator.retriever.extraction.commonalities.RequirementsBuilder;
import org.palladiosimulator.retriever.extraction.engine.MapMerger;

public class PCMDetectionResult {
    private final Set<Component> components;
    private final Set<Composite> composites;
    private final Map<OperationInterface, Set<Operation>> operationInterfaces;

    public PCMDetectionResult(Map<CompUnitOrName, ComponentBuilder> components, Map<String, CompositeBuilder> composites, ProvisionsBuilder compositeProvisions, RequirementsBuilder compositeRequirements) {
        Set<Component> temporaryComponents = PCMDetectionResult.createComponents(components, compositeProvisions, compositeRequirements, Set.of());
        Set<Component> connectedComponents = PCMDetectionResult.collectConnectedComponents(temporaryComponents, composites, compositeProvisions, compositeRequirements);
        Set<Composite> temporaryComposites = PCMDetectionResult.createCompositeComponents(connectedComponents, composites, compositeProvisions, compositeRequirements, Set.of());
        Set<OperationInterface> visibleProvisions = PCMDetectionResult.collectVisibleProvisions(connectedComponents, temporaryComposites);
        Map<CompUnitOrName, ComponentBuilder> connectedComponentBuilders = connectedComponents.stream().map(Component::identifier).map(components::get).collect(Collectors.toMap(ComponentBuilder::identifier, x -> x));
        this.components = PCMDetectionResult.createComponents(connectedComponentBuilders, compositeProvisions, compositeRequirements, visibleProvisions);
        this.composites = PCMDetectionResult.createCompositeComponents(this.components, composites, compositeProvisions, compositeRequirements, visibleProvisions);
        this.operationInterfaces = this.createOperationInterfaces();
    }

    private static Set<Component> collectConnectedComponents(Set<Component> temporaryComponents, Map<String, CompositeBuilder> composites, ProvisionsBuilder compositeProvisions, RequirementsBuilder compositeRequirements) {
        CompositeBuilder metaCompositeBuilder = new CompositeBuilder("Meta Composite");
        for (CompositeBuilder composite : composites.values()) {
            for (ComponentBuilder part : composite.getParts()) {
                metaCompositeBuilder.addPart(part);
            }
        }
        Composite metaComposite = metaCompositeBuilder.construct(temporaryComponents, new RequirementsBuilder().create(Set.of(), Set.of()), new ProvisionsBuilder().create(Set.of()), Set.of());
        Set<Component> connectedComponents = metaComposite.parts();
        if (connectedComponents.isEmpty()) {
            return temporaryComponents;
        }
        return connectedComponents;
    }

    private static Set<Component> createComponents(Map<CompUnitOrName, ComponentBuilder> components, ProvisionsBuilder compositeProvisions, RequirementsBuilder compositeRequirements, Set<OperationInterface> visibleProvisions) {
        LinkedList<OperationInterface> allDependencies = new LinkedList<OperationInterface>();
        allDependencies.addAll(compositeRequirements.toList());
        allDependencies.addAll(compositeProvisions.toList());
        return components.values().stream().map(x -> x.create(allDependencies, visibleProvisions)).collect(Collectors.toSet());
    }

    private static Set<Composite> createCompositeComponents(Set<Component> freeComponents, Map<String, CompositeBuilder> composites, ProvisionsBuilder compositeProvisions, RequirementsBuilder compositeRequirements, Set<OperationInterface> visibleProvisions) {
        List allComposites = composites.values().stream().map(x -> x.construct(freeComponents, compositeRequirements.create(visibleProvisions, visibleProvisions), compositeProvisions.create(visibleProvisions), visibleProvisions)).collect(Collectors.toList());
        HashSet<Composite> redundantComposites = new HashSet<Composite>();
        HashSet<Composite> remainingComposites = new HashSet<Composite>();
        for (Composite subject : allComposites) {
            Optional<Composite> other = allComposites.stream().filter(x -> !subject.equals(x)).filter(x -> !redundantComposites.contains(x)).filter(x -> subject.isSubsetOf((Composite)x)).findFirst();
            if (other.isPresent()) {
                redundantComposites.add(subject);
                continue;
            }
            remainingComposites.add(subject);
        }
        HashSet<Composite> collectivelyContainedComposites = new HashSet<Composite>();
        for (Composite subject : remainingComposites) {
            Set allOtherParts = remainingComposites.stream().filter(x -> !subject.equals(x)).map(Composite::parts).flatMap(Collection::stream).collect(Collectors.toSet());
            boolean isContainedInOthers = subject.parts().stream().allMatch(allOtherParts::contains);
            if (!isContainedInOthers) continue;
            collectivelyContainedComposites.add(subject);
        }
        HashSet<Composite> actuallyContainedComposites = new HashSet<Composite>();
        for (Composite subject : collectivelyContainedComposites) {
            Set allOtherParts = remainingComposites.stream().filter(x -> !subject.equals(x)).filter(x -> !collectivelyContainedComposites.contains(x)).map(Composite::parts).flatMap(Collection::stream).collect(Collectors.toSet());
            boolean isContainedInOthers = subject.parts().stream().allMatch(allOtherParts::contains);
            if (!isContainedInOthers) continue;
            actuallyContainedComposites.add(subject);
        }
        remainingComposites.removeAll(actuallyContainedComposites);
        return remainingComposites;
    }

    private static Set<OperationInterface> collectVisibleProvisions(Set<Component> components, Set<Composite> composites) {
        HashSet<OperationInterface> provisions = new HashSet<OperationInterface>();
        composites.stream().flatMap(x -> x.provisions().stream()).forEach(provisions::add);
        Set containedComponents = composites.stream().flatMap(x -> x.parts().stream()).collect(Collectors.toSet());
        Set bareComponents = components.stream().filter(x -> !containedComponents.contains(x)).collect(Collectors.toSet());
        bareComponents.stream().flatMap(x -> x.provisions().getGrouped().keySet().stream()).forEach(provisions::add);
        return provisions;
    }

    private Map<OperationInterface, Set<Operation>> createOperationInterfaces() {
        List constructedOperationInterfaces = this.getComponents().stream().map(x -> x.provisions().simplified()).collect(Collectors.toList());
        this.getComponents().stream().map(x -> x.requirements().simplified()).forEach(x -> {
            boolean bl = constructedOperationInterfaces.add(x);
        });
        this.getCompositeComponents().stream().flatMap(x -> x.provisions().stream()).forEach(x -> {
            boolean bl = constructedOperationInterfaces.add(x.simplified());
        });
        this.getCompositeComponents().stream().flatMap(x -> x.requirements().stream()).forEach(x -> {
            boolean bl = constructedOperationInterfaces.add(x.simplified());
        });
        return MapMerger.merge(constructedOperationInterfaces);
    }

    public Set<Component> getComponents() {
        return this.components;
    }

    public Set<Composite> getCompositeComponents() {
        return this.composites;
    }

    public Map<OperationInterface, Set<Operation>> getOperationInterfaces() {
        return this.operationInterfaces;
    }
}

