/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.mocore.transformation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.generator.fluent.repository.api.Repo;
import org.palladiosimulator.generator.fluent.repository.factory.FluentRepositoryFactory;
import org.palladiosimulator.generator.fluent.repository.structure.components.BasicComponentCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.CompositeComponentCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.OperationInterfaceCreator;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.retriever.mocore.surrogate.PcmSurrogate;
import org.palladiosimulator.retriever.mocore.surrogate.element.AtomicComponent;
import org.palladiosimulator.retriever.mocore.surrogate.element.Component;
import org.palladiosimulator.retriever.mocore.surrogate.element.Composite;
import org.palladiosimulator.retriever.mocore.surrogate.element.Interface;
import org.palladiosimulator.retriever.mocore.surrogate.relation.ComponentAssemblyRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.ComponentSignatureProvisionRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.CompositeProvisionDelegationRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.CompositeRequirementDelegationRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.CompositionRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.InterfaceProvisionRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.InterfaceRequirementRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.ServiceEffectSpecificationRelation;
import org.palladiosimulator.retriever.mocore.surrogate.relation.SignatureProvisionRelation;
import tools.mdsd.mocore.framework.surrogate.Relation;
import tools.mdsd.mocore.framework.surrogate.Replaceable;
import tools.mdsd.mocore.framework.transformation.Transformer;

public class RepositoryTransformer
implements Transformer<PcmSurrogate, Repository> {
    private static final Logger LOG = Logger.getLogger(RepositoryTransformer.class);
    private static final String DELEGATION_EXCLUSION_NAME_PATTERN = "%s";
    private static final String ROLE_PROVIDES_NAME_PATTERN = "%s Provider";
    private static final String ROLE_REQUIRES_NAME_PATTERN = "%s Consumer";

    public Repository transform(PcmSurrogate model) {
        CompositeComponent repositoryComposite;
        Interface innerInterfaceWrapper;
        Interface outerInterfaceWrapper;
        Component childWrapper;
        Composite compositeWrapper;
        FluentRepositoryFactory repositoryFactory = new FluentRepositoryFactory();
        Repo fluentRepository = repositoryFactory.newRepository();
        List seffRelations = model.getByType(ServiceEffectSpecificationRelation.class);
        List provisionRelations = model.getByType(InterfaceProvisionRelation.class);
        List requirementRelations = model.getByType(InterfaceRequirementRelation.class);
        List signatureRelations = model.getByType(SignatureProvisionRelation.class);
        List interfaces = model.getByType(Interface.class);
        for (Interface interfaceInstance : interfaces) {
            OperationInterfaceCreator interfaceCreator = this.getCreator(repositoryFactory, interfaceInstance);
            fluentRepository.addToRepository((org.palladiosimulator.generator.fluent.repository.structure.interfaces.Interface)interfaceCreator);
            OperationInterface repositoryInterface = repositoryFactory.fetchOfOperationInterface(((OperationInterface)interfaceInstance.getValue()).getEntityName());
            for (Object relation2 : signatureRelations) {
                if (!((Interface)relation2.getDestination()).equals((Object)interfaceInstance)) continue;
                org.palladiosimulator.retriever.mocore.surrogate.element.Signature signature = (org.palladiosimulator.retriever.mocore.surrogate.element.Signature)relation2.getSource();
                ((OperationSignature)signature.getValue()).setInterface__OperationSignature(repositoryInterface);
            }
        }
        for (AtomicComponent component2 : model.getByType(AtomicComponent.class)) {
            OperationInterface operationInterface;
            String interfaceName;
            Object interfaceInstance;
            BasicComponentCreator componentCreator = this.getCreator(repositoryFactory, component2);
            for (Relation relation3 : provisionRelations) {
                interfaceInstance = (Interface)relation3.getDestination();
                if (!((Component)relation3.getSource()).equals((Object)component2)) continue;
                interfaceName = ((OperationInterface)interfaceInstance.getValue()).getEntityName();
                operationInterface = repositoryFactory.fetchOfOperationInterface(interfaceName);
                componentCreator.provides(operationInterface, RepositoryTransformer.getProvidedRoleName((Interface)((Object)interfaceInstance)));
            }
            for (Relation relation3 : requirementRelations) {
                interfaceInstance = (Interface)relation3.getDestination();
                if (!((Component)relation3.getSource()).equals((Object)component2)) continue;
                interfaceName = ((OperationInterface)interfaceInstance.getValue()).getEntityName();
                operationInterface = repositoryFactory.fetchOfOperationInterface(interfaceName);
                componentCreator.requires(operationInterface, RepositoryTransformer.getRequiredRoleName((Interface)((Object)interfaceInstance)));
            }
            BasicComponent repositoryComponent = componentCreator.build();
            for (Object interfaceProvision : provisionRelations) {
                if (!((Component)interfaceProvision.getSource()).equals((Object)component2)) continue;
                OperationInterface operationInterface2 = repositoryFactory.fetchOfOperationInterface(((OperationInterface)((Interface)interfaceProvision.getDestination()).getValue()).getEntityName());
                for (OperationSignature signature : operationInterface2.getSignatures__OperationInterface()) {
                    Predicate<ServiceEffectSpecificationRelation> filter = relation -> {
                        org.palladiosimulator.retriever.mocore.surrogate.element.Signature wrappedSignature = (org.palladiosimulator.retriever.mocore.surrogate.element.Signature)((SignatureProvisionRelation)((ComponentSignatureProvisionRelation)relation.getSource()).getDestination()).getSource();
                        Interface wrappedInterface = (Interface)((InterfaceProvisionRelation)((ComponentSignatureProvisionRelation)relation.getSource()).getSource()).getDestination();
                        return RepositoryTransformer.representSameSignature(signature, (OperationSignature)wrappedSignature.getValue()) && RepositoryTransformer.representSameInterface(operationInterface2, (OperationInterface)wrappedInterface.getValue());
                    };
                    ServiceEffectSpecification seff = (ServiceEffectSpecification)seffRelations.stream().filter(relation -> ((Component)((InterfaceProvisionRelation)((ComponentSignatureProvisionRelation)relation.getSource()).getSource()).getSource()).equals((Object)component2)).filter(filter).map(relation -> (ResourceDemandingSEFF)((org.palladiosimulator.retriever.mocore.surrogate.element.ServiceEffectSpecification)relation.getDestination()).getValue()).findFirst().orElse((ResourceDemandingSEFF)org.palladiosimulator.retriever.mocore.surrogate.element.ServiceEffectSpecification.getUniquePlaceholder().getValue());
                    seff.setBasicComponent_ServiceEffectSpecification(repositoryComponent);
                    seff.setDescribedService__SEFF((Signature)signature);
                    if (!(seff instanceof ResourceDemandingSEFF)) continue;
                    ResourceDemandingSEFF rdSeff = (ResourceDemandingSEFF)seff;
                    EList behavior = rdSeff.getSteps_Behaviour();
                    List<ExternalCallAction> externalCallActions = RepositoryTransformer.filterExternalCallActions((Collection<AbstractAction>)behavior);
                    Iterator iterator = externalCallActions.iterator();
                    while (iterator.hasNext()) {
                        ExternalCallAction externalCallAction = (ExternalCallAction)iterator.next();
                        OperationSignature externalSignature = externalCallAction.getCalledService_ExternalService();
                        Optional<OperationRequiredRole> requiredRoleOption = repositoryComponent.getRequiredRoles_InterfaceRequiringEntity().stream().filter(role -> role instanceof OperationRequiredRole).map(role -> (OperationRequiredRole)role).filter(role -> role.getRequiredInterface__OperationRequiredRole().getSignatures__OperationInterface().contains((Object)externalSignature)).findFirst();
                        if (requiredRoleOption.isEmpty()) {
                            LOG.warn((Object)("Failed to find required role for external call to " + externalSignature.getInterface__OperationSignature().getEntityName() + "#" + externalSignature.getEntityName() + "!"));
                            continue;
                        }
                        OperationRequiredRole requiredRole = requiredRoleOption.get();
                        externalCallAction.setRole_ExternalService(requiredRole);
                    }
                }
            }
            fluentRepository.addToRepository((RepositoryComponent)repositoryComponent);
        }
        List compositionRelations = model.getByType(CompositionRelation.class);
        List composites = model.getByType(Composite.class);
        HashMultimap compositesChildren = HashMultimap.create();
        for (Composite composite2 : composites) {
            List children = compositionRelations.stream().filter(relation -> ((Composite)relation.getSource()).equals((Object)composite2)).map(relation -> (Component)relation.getDestination()).collect(Collectors.toList());
            compositesChildren.putAll((Object)composite2, children);
        }
        LinkedList sortedComposites = new LinkedList(composites);
        sortedComposites.sort((arg_0, arg_1) -> this.lambda$8((Multimap)compositesChildren, arg_0, arg_1));
        LinkedList<InterfaceProvisionRelation> nonRequiredProvisionRelations = new LinkedList<InterfaceProvisionRelation>(provisionRelations);
        nonRequiredProvisionRelations.removeIf(provisionRelation -> requirementRelations.stream().anyMatch(requirementRelation -> ((Interface)requirementRelation.getDestination()).equals(provisionRelation.getDestination())));
        for (Composite composite3 : sortedComposites) {
            int i = 0;
            while (i < nonRequiredProvisionRelations.size()) {
                InterfaceProvisionRelation nonRequiredProvision = (InterfaceProvisionRelation)((Object)nonRequiredProvisionRelations.get(i));
                Component provider = (Component)nonRequiredProvision.getSource();
                Interface providedInterface = (Interface)nonRequiredProvision.getDestination();
                if (this.isDirectChild(provider, composite3, (Multimap<Composite, Component<?>>)compositesChildren)) {
                    boolean existsDelegation = false;
                    for (CompositeProvisionDelegationRelation delegationRelation : model.getByType(CompositeProvisionDelegationRelation.class)) {
                        if (!((InterfaceProvisionRelation)delegationRelation.getDestination()).equals((Object)nonRequiredProvision) || !((Component)((InterfaceProvisionRelation)delegationRelation.getSource()).getSource()).equals((Object)composite3)) continue;
                        existsDelegation = true;
                        break;
                    }
                    boolean excludeDelegation = RepositoryTransformer.isExcludedFromDelegation(provider, providedInterface);
                    if (!existsDelegation && !excludeDelegation) {
                        InterfaceProvisionRelation provisionRelation2 = null;
                        for (InterfaceProvisionRelation provision : provisionRelations) {
                            if (!((Component)provision.getSource()).equals((Object)composite3) || !((Interface)provision.getDestination()).equals((Object)providedInterface)) continue;
                            provisionRelation2 = provision;
                        }
                        if (Objects.isNull(provisionRelation2)) {
                            provisionRelation2 = new InterfaceProvisionRelation(composite3, providedInterface, true);
                            model.add((Replaceable)provisionRelation2);
                            nonRequiredProvisionRelations.add(provisionRelation2);
                            provisionRelations = model.getByType(InterfaceProvisionRelation.class);
                        }
                        CompositeProvisionDelegationRelation provisionDelegation = new CompositeProvisionDelegationRelation(provisionRelation2, nonRequiredProvision, true);
                        model.add((Replaceable)provisionDelegation);
                    }
                }
                ++i;
            }
        }
        for (Composite composite3 : composites) {
            OperationInterface operationInterface;
            String interfaceName;
            Interface interfaceInstance;
            CompositeComponentCreator compositeCreator = this.getCreator(repositoryFactory, composite3);
            for (Relation relation4 : provisionRelations) {
                interfaceInstance = (Interface)relation4.getDestination();
                if (!((Component)relation4.getSource()).equals((Object)composite3)) continue;
                interfaceName = ((OperationInterface)interfaceInstance.getValue()).getEntityName();
                operationInterface = repositoryFactory.fetchOfOperationInterface(interfaceName);
                compositeCreator.provides(operationInterface, RepositoryTransformer.getProvidedRoleName(interfaceInstance));
            }
            for (Relation relation4 : requirementRelations) {
                interfaceInstance = (Interface)relation4.getDestination();
                if (!((Component)relation4.getSource()).equals((Object)composite3)) continue;
                interfaceName = ((OperationInterface)interfaceInstance.getValue()).getEntityName();
                operationInterface = repositoryFactory.fetchOfOperationInterface(interfaceName);
                compositeCreator.requires(operationInterface, RepositoryTransformer.getRequiredRoleName(interfaceInstance));
            }
            fluentRepository.addToRepository((org.palladiosimulator.generator.fluent.repository.structure.components.Component)compositeCreator);
        }
        for (CompositionRelation relation5 : compositionRelations) {
            Composite composite4 = (Composite)relation5.getSource();
            Component destination = (Component)relation5.getDestination();
            CompositeComponent persistedCompositeComponent = repositoryFactory.fetchOfCompositeComponent(((CompositeComponent)composite4.getValue()).getEntityName());
            persistedCompositeComponent.getAssemblyContexts__ComposedStructure();
            CompositeComponentCreator temporaryCreator = repositoryFactory.newCompositeComponent();
            if (destination instanceof AtomicComponent) {
                temporaryCreator.withAssemblyContext((RepositoryComponent)repositoryFactory.fetchOfBasicComponent(((RepositoryComponent)destination.getValue()).getEntityName()), new VariableUsageCreator[0]);
            } else if (destination instanceof Composite) {
                temporaryCreator.withAssemblyContext((RepositoryComponent)repositoryFactory.fetchOfCompositeComponent(((RepositoryComponent)destination.getValue()).getEntityName()), new VariableUsageCreator[0]);
            }
            CompositeComponent temporaryComposite = (CompositeComponent)temporaryCreator.build();
            persistedCompositeComponent.getAssemblyContexts__ComposedStructure().addAll((Collection)temporaryComposite.getAssemblyContexts__ComposedStructure());
        }
        Repository repository = fluentRepository.createRepositoryNow();
        for (ComponentAssemblyRelation assemblyRelation : model.getByType(ComponentAssemblyRelation.class)) {
            Component provider = (Component)((InterfaceProvisionRelation)assemblyRelation.getSource()).getSource();
            Component consumer = (Component)((InterfaceRequirementRelation)assemblyRelation.getDestination()).getSource();
            Interface interFace = (Interface)((InterfaceProvisionRelation)assemblyRelation.getSource()).getDestination();
            List providerComposites = compositionRelations.stream().filter(relation -> ((Component)relation.getDestination()).equals((Object)provider)).map(Relation::getSource).collect(Collectors.toList());
            List consumerComposites = compositionRelations.stream().filter(relation -> ((Component)relation.getDestination()).equals((Object)consumer)).map(Relation::getSource).collect(Collectors.toList());
            List commonComposites = providerComposites.stream().filter(composite -> consumerComposites.contains(composite)).collect(Collectors.toList());
            ArrayList<CompositeComponent> commonRepositoryComposites = new ArrayList<CompositeComponent>();
            for (RepositoryComponent repositoryComponent : repository.getComponents__Repository()) {
                for (Composite commonComposite : commonComposites) {
                    if (!repositoryComponent.getEntityName().equals(((CompositeComponent)commonComposite.getValue()).getEntityName())) continue;
                    commonRepositoryComposites.add((CompositeComponent)repositoryComponent);
                }
            }
            for (CompositeComponent repositoryComposite2 : commonRepositoryComposites) {
                AssemblyContext providerContext = repositoryComposite2.getAssemblyContexts__ComposedStructure().stream().filter(context -> context.getEncapsulatedComponent__AssemblyContext().getEntityName().equals(((RepositoryComponent)provider.getValue()).getEntityName())).findFirst().orElseThrow();
                AssemblyContext consumerContext = repositoryComposite2.getAssemblyContexts__ComposedStructure().stream().filter(context -> context.getEncapsulatedComponent__AssemblyContext().getEntityName().equals(((RepositoryComponent)consumer.getValue()).getEntityName())).findFirst().orElseThrow();
                OperationProvidedRole providerRole = (OperationProvidedRole)providerContext.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().stream().filter(role -> role instanceof OperationProvidedRole && ((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole().getEntityName().equals(((OperationInterface)interFace.getValue()).getEntityName())).findFirst().orElseThrow();
                OperationRequiredRole consumerRole = (OperationRequiredRole)consumerContext.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity().stream().filter(role -> role instanceof OperationRequiredRole && ((OperationRequiredRole)role).getRequiredInterface__OperationRequiredRole().getEntityName().equals(((OperationInterface)interFace.getValue()).getEntityName())).findFirst().orElseThrow();
                AssemblyConnector assemblyConnector = CompositionFactory.eINSTANCE.createAssemblyConnector();
                assemblyConnector.setProvidedRole_AssemblyConnector(providerRole);
                assemblyConnector.setProvidingAssemblyContext_AssemblyConnector(providerContext);
                assemblyConnector.setRequiredRole_AssemblyConnector(consumerRole);
                assemblyConnector.setRequiringAssemblyContext_AssemblyConnector(consumerContext);
                repositoryComposite2.getConnectors__ComposedStructure().add((Object)assemblyConnector);
            }
        }
        for (Relation delegationRelation : model.getByType(CompositeProvisionDelegationRelation.class)) {
            compositeWrapper = (Composite)((InterfaceProvisionRelation)delegationRelation.getSource()).getSource();
            childWrapper = (Component)((InterfaceProvisionRelation)delegationRelation.getDestination()).getSource();
            outerInterfaceWrapper = (Interface)((InterfaceProvisionRelation)delegationRelation.getSource()).getDestination();
            innerInterfaceWrapper = (Interface)((InterfaceProvisionRelation)delegationRelation.getDestination()).getDestination();
            repositoryComposite = (CompositeComponent)repository.getComponents__Repository().stream().filter(CompositeComponent.class::isInstance).filter(component -> component.getEntityName().equals(((CompositeComponent)compositeWrapper.getValue()).getEntityName())).findFirst().orElseThrow();
            AssemblyContext childContext = repositoryComposite.getAssemblyContexts__ComposedStructure().stream().filter(context -> context.getEncapsulatedComponent__AssemblyContext().getEntityName().equals(((RepositoryComponent)childWrapper.getValue()).getEntityName())).findFirst().orElseThrow();
            OperationProvidedRole innerRole = (OperationProvidedRole)childContext.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity().stream().filter(role -> role instanceof OperationProvidedRole && ((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole().getEntityName().equals(((OperationInterface)innerInterfaceWrapper.getValue()).getEntityName())).findFirst().orElseThrow();
            OperationProvidedRole outerRole = (OperationProvidedRole)repositoryComposite.getProvidedRoles_InterfaceProvidingEntity().stream().filter(role -> role instanceof OperationProvidedRole && ((OperationProvidedRole)role).getProvidedInterface__OperationProvidedRole().getEntityName().equals(((OperationInterface)outerInterfaceWrapper.getValue()).getEntityName())).findFirst().orElseThrow();
            ProvidedDelegationConnector delegationConnector = CompositionFactory.eINSTANCE.createProvidedDelegationConnector();
            delegationConnector.setAssemblyContext_ProvidedDelegationConnector(childContext);
            delegationConnector.setInnerProvidedRole_ProvidedDelegationConnector(innerRole);
            delegationConnector.setOuterProvidedRole_ProvidedDelegationConnector(outerRole);
            repositoryComposite.getConnectors__ComposedStructure().add((Object)delegationConnector);
        }
        for (Relation delegationRelation : model.getByType(CompositeRequirementDelegationRelation.class)) {
            compositeWrapper = (Composite)((InterfaceRequirementRelation)delegationRelation.getSource()).getSource();
            childWrapper = (Component)((InterfaceRequirementRelation)delegationRelation.getDestination()).getSource();
            outerInterfaceWrapper = (Interface)((InterfaceRequirementRelation)delegationRelation.getSource()).getDestination();
            innerInterfaceWrapper = (Interface)((InterfaceRequirementRelation)delegationRelation.getDestination()).getDestination();
            repositoryComposite = (CompositeComponent)repository.getComponents__Repository().stream().filter(component -> component.getEntityName().equals(((CompositeComponent)compositeWrapper.getValue()).getEntityName())).findFirst().orElseThrow();
            AssemblyContext childContext = repositoryComposite.getAssemblyContexts__ComposedStructure().stream().filter(context -> context.getEncapsulatedComponent__AssemblyContext().getEntityName().equals(((RepositoryComponent)childWrapper.getValue()).getEntityName())).findFirst().orElseThrow();
            OperationRequiredRole innerRole = (OperationRequiredRole)childContext.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity().stream().filter(role -> role instanceof OperationRequiredRole && ((OperationRequiredRole)role).getRequiredInterface__OperationRequiredRole().getEntityName().equals(((OperationInterface)innerInterfaceWrapper.getValue()).getEntityName())).findFirst().orElseThrow();
            OperationRequiredRole outerRole = (OperationRequiredRole)repositoryComposite.getRequiredRoles_InterfaceRequiringEntity().stream().filter(role -> role instanceof OperationRequiredRole && ((OperationRequiredRole)role).getRequiredInterface__OperationRequiredRole().getEntityName().equals(((OperationInterface)outerInterfaceWrapper.getValue()).getEntityName())).findFirst().orElseThrow();
            RequiredDelegationConnector delegationConnector = CompositionFactory.eINSTANCE.createRequiredDelegationConnector();
            delegationConnector.setAssemblyContext_RequiredDelegationConnector(childContext);
            delegationConnector.setInnerRequiredRole_RequiredDelegationConnector(innerRole);
            delegationConnector.setOuterRequiredRole_RequiredDelegationConnector(outerRole);
            repositoryComposite.getConnectors__ComposedStructure().add((Object)delegationConnector);
        }
        return repository;
    }

    private boolean isDirectChild(Component<?> child, Composite parent, Multimap<Composite, Component<?>> compositesChildren) {
        return compositesChildren.get((Object)parent).contains(child);
    }

    private boolean isRecursiveChild(Component<?> child, Composite parent, Multimap<Composite, Component<?>> compositesChildren) {
        if (this.isDirectChild(child, parent, compositesChildren)) {
            return true;
        }
        for (Component childOfParent : compositesChildren.get((Object)parent)) {
            if (!(childOfParent instanceof Composite)) continue;
            return this.isRecursiveChild(child, (Composite)childOfParent, compositesChildren);
        }
        return false;
    }

    protected static boolean isExcludedFromDelegation(Component<?> provider, Interface providedInterface) {
        String providerName = ((RepositoryComponent)provider.getValue()).getEntityName();
        String providedInterfaceName = ((OperationInterface)providedInterface.getValue()).getEntityName();
        return providedInterfaceName.equals(String.format(DELEGATION_EXCLUSION_NAME_PATTERN, providerName));
    }

    private int compareComposites(Composite a, Composite b, Multimap<Composite, Component<?>> compositesChildren) {
        if (this.isRecursiveChild(a, b, compositesChildren)) {
            return -1;
        }
        if (this.isRecursiveChild(b, a, compositesChildren)) {
            return 1;
        }
        return 0;
    }

    private BasicComponentCreator getCreator(FluentRepositoryFactory fluentFactory, AtomicComponent component) {
        BasicComponentCreator componentCreator = fluentFactory.newBasicComponent();
        BasicComponent wrappedComponent = (BasicComponent)component.getValue();
        componentCreator.withName(wrappedComponent.getEntityName());
        return componentCreator;
    }

    private CompositeComponentCreator getCreator(FluentRepositoryFactory fluentFactory, Composite component) {
        CompositeComponentCreator compositeCreator = fluentFactory.newCompositeComponent();
        RepositoryComponent wrappedComponent = (RepositoryComponent)component.getValue();
        compositeCreator.withName(wrappedComponent.getEntityName());
        return compositeCreator;
    }

    private OperationInterfaceCreator getCreator(FluentRepositoryFactory fluentFactory, Interface interfaceInstance) {
        OperationInterfaceCreator interfaceCreator = fluentFactory.newOperationInterface();
        OperationInterface wrappedInterface = (OperationInterface)interfaceInstance.getValue();
        interfaceCreator.withName(wrappedInterface.getEntityName());
        return interfaceCreator;
    }

    protected static String getProvidedRoleName(Interface interfaceInstance) {
        String interfaceEntityName = ((OperationInterface)interfaceInstance.getValue()).getEntityName();
        return String.format(ROLE_PROVIDES_NAME_PATTERN, interfaceEntityName);
    }

    protected static String getRequiredRoleName(Interface interfaceInstance) {
        String interfaceEntityName = ((OperationInterface)interfaceInstance.getValue()).getEntityName();
        return String.format(ROLE_REQUIRES_NAME_PATTERN, interfaceEntityName);
    }

    private static List<ExternalCallAction> filterExternalCallActions(Collection<AbstractAction> actions) {
        ArrayList<ExternalCallAction> externalCallActions = new ArrayList<ExternalCallAction>();
        for (AbstractAction action : actions) {
            if (action instanceof BranchAction var4_4) {
                for (ExternalCallAction branch : branchAction.getBranches_Branch()) {
                    EList branchActions = branch.getBranchBehaviour_BranchTransition().getSteps_Behaviour();
                    externalCallActions.addAll(RepositoryTransformer.filterExternalCallActions((Collection<AbstractAction>)branchActions));
                }
                continue;
            }
            if (!(action instanceof ExternalCallAction branch)) continue;
            externalCallActions.add((ExternalCallAction)externalCallAction);
        }
        return externalCallActions;
    }

    private static boolean representSameSignature(OperationSignature signature, OperationSignature otherSignature) {
        boolean equalParameters;
        boolean equalName = Objects.equals(signature.getEntityName(), otherSignature.getEntityName());
        boolean equalReturn = Objects.equals(signature.getReturnType__OperationSignature(), otherSignature.getReturnType__OperationSignature());
        boolean bl = equalParameters = signature.getParameters__OperationSignature().containsAll((Collection)otherSignature.getParameters__OperationSignature()) && otherSignature.getParameters__OperationSignature().containsAll((Collection)signature.getParameters__OperationSignature());
        return equalName && equalReturn && equalParameters;
    }

    private static boolean representSameInterface(OperationInterface interFace, OperationInterface otherInterFace) {
        boolean equalName = Objects.equals(interFace.getEntityName(), otherInterFace.getEntityName());
        return equalName;
    }

    private /* synthetic */ int lambda$8(Multimap multimap, Composite a, Composite b) {
        return this.compareComposites(a, b, multimap);
    }
}

