/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.somox.ast2seff.visitors;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.palladiosimulator.generator.fluent.repository.api.seff.ActionSeff;
import org.palladiosimulator.generator.fluent.repository.api.seff.Seff;
import org.palladiosimulator.generator.fluent.repository.factory.FluentRepositoryFactory;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.BranchActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.ExternalCallActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.LoopActionCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SetVariableActionCreator;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.VariableCharacterisationType;
import org.palladiosimulator.pcm.reliability.ResourceTimeoutFailureType;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.somox.ast2seff.util.NameUtil;
import org.palladiosimulator.somox.ast2seff.util.SwitchStatementUtil;

public class Ast2SeffVisitor
extends ASTVisitor {
    private static final Logger LOGGER = Logger.getLogger(Ast2SeffVisitor.class);
    private ActionSeff actionSeff;
    private ASTNode rootNode;
    private Map<ASTNode, ServiceEffectSpecification> externalNodes;
    private FluentRepositoryFactory fluentFactory;
    private int methodInliningDepth = 0;

    public Ast2SeffVisitor(ActionSeff actionSeff, ASTNode rootNode, Map<ASTNode, ServiceEffectSpecification> externalNodes, FluentRepositoryFactory fluentFactory) {
        this.actionSeff = actionSeff;
        this.rootNode = rootNode;
        this.externalNodes = externalNodes;
        this.fluentFactory = fluentFactory;
    }

    private Ast2SeffVisitor(ActionSeff actionSeff, ASTNode rootNode, Map<ASTNode, ServiceEffectSpecification> externalNodes, FluentRepositoryFactory fluentFactory, int methodInliningDepth) {
        this.actionSeff = actionSeff;
        this.rootNode = rootNode;
        this.externalNodes = externalNodes;
        this.fluentFactory = fluentFactory;
        this.methodInliningDepth = methodInliningDepth;
    }

    public static ActionSeff perform(ActionSeff actionSeff, ASTNode rootNode, Map<ASTNode, ServiceEffectSpecification> externalNodes, FluentRepositoryFactory fluentFactory) {
        Ast2SeffVisitor newFunctionCallClassificationVisitor = new Ast2SeffVisitor(actionSeff, rootNode, externalNodes, fluentFactory);
        rootNode.accept((ASTVisitor)newFunctionCallClassificationVisitor);
        return actionSeff;
    }

    private ActionSeff perform(ASTNode node, ActionSeff actionSeff) {
        Ast2SeffVisitor newFunctionCallClassificationVisitor = new Ast2SeffVisitor(actionSeff, this.rootNode, this.externalNodes, this.fluentFactory);
        node.accept((ASTVisitor)newFunctionCallClassificationVisitor);
        return actionSeff;
    }

    private ActionSeff perform(ASTNode node, ActionSeff actionSeff, int methodInliningDepth) {
        Ast2SeffVisitor newFunctionCallClassificationVisitor = new Ast2SeffVisitor(actionSeff, this.rootNode, this.externalNodes, this.fluentFactory, methodInliningDepth);
        node.accept((ASTVisitor)newFunctionCallClassificationVisitor);
        return actionSeff;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        LOGGER.debug((Object)"Visit Expression Statement");
        Expression expression = expressionStatement.getExpression();
        if (!(expression instanceof Assignment)) {
            if (expression instanceof MethodInvocation && this.isExternal((MethodInvocation)expression)) {
                MethodInvocation methodInvocation = (MethodInvocation)expression;
                OperationInterface operationInterface = this.getOperationInterfaceOfInvocation(methodInvocation).orElseThrow();
                OperationSignature operationSignature = this.getOperationSignatureOfInvocation(methodInvocation).orElseThrow();
                if (!this.getOperationInterfaceOfRootNode().getEntityName().equals(operationInterface.getEntityName())) {
                    this.createExternalCallAction(methodInvocation, operationInterface, operationSignature);
                } else if (this.methodInliningDepth < 1) {
                    this.createMethodInlining();
                } else {
                    this.createInternalAction(expressionStatement);
                }
            } else {
                this.createInternalAction(expressionStatement);
            }
        }
        return false;
    }

    private void createMethodInlining() {
        LOGGER.debug((Object)"Expression Statement is Method Inlining");
        this.perform(this.rootNode, this.actionSeff, this.methodInliningDepth + 1);
    }

    private void createExternalCallAction(MethodInvocation methodInvocation, OperationInterface operationInterface, OperationSignature operationSignature) {
        VariableUsageCreator variableUsage;
        LOGGER.debug((Object)"Expression Statement is External Call Action");
        ExternalCallActionCreator externalCallActionCreator = this.actionSeff.externalCallAction();
        OperationRequiredRole requiredRole = this.addRequiredInterfaceToComponent(operationInterface.getEntityName());
        externalCallActionCreator.withCalledService(operationSignature);
        externalCallActionCreator.withRequiredRole(requiredRole);
        OperationSignature calledFunctionSignature = (OperationSignature)this.getServiceEffectSpecificationOfInvocation(methodInvocation).orElseThrow().getDescribedService__SEFF();
        if (!methodInvocation.arguments().isEmpty()) {
            if (calledFunctionSignature != null && calledFunctionSignature.getParameters__OperationSignature().size() == methodInvocation.arguments().size()) {
                EList calledFunctParameterList = calledFunctionSignature.getParameters__OperationSignature();
                int i = 0;
                while (i < calledFunctParameterList.size()) {
                    Parameter para = (Parameter)calledFunctParameterList.get(i);
                    Expression castedArgument = (Expression)methodInvocation.arguments().get(i);
                    variableUsage = this.generateInputVariableUsage(castedArgument, para);
                    externalCallActionCreator.withInputVariableUsage(variableUsage);
                    ++i;
                }
            } else {
                LOGGER.error((Object)"Called Function Signature Not Found Or Wrong Parameter Size");
            }
        }
        if (calledFunctionSignature != null && calledFunctionSignature.getReturnType__OperationSignature() != null) {
            DataType returnType = calledFunctionSignature.getReturnType__OperationSignature();
            variableUsage = this.generateOutputVariableUsage(returnType);
            externalCallActionCreator.withReturnVariableUsage(variableUsage);
        }
        this.actionSeff = externalCallActionCreator.withName(NameUtil.getEntityName(methodInvocation)).followedBy();
    }

    private OperationRequiredRole addRequiredInterfaceToComponent(String requiredInterfaceName) {
        OperationRequiredRole requiredRole2;
        OperationInterface requiredInterface = this.fluentFactory.fetchOfOperationInterface(requiredInterfaceName);
        BasicComponent rootComponent = this.getComponentOfRootNode();
        for (OperationRequiredRole requiredRole2 : rootComponent.getRequiredRoles_InterfaceRequiringEntity()) {
            OperationRequiredRole operationRequiredRole = requiredRole2;
            if (!operationRequiredRole.getRequiredInterface__OperationRequiredRole().getEntityName().equals(requiredInterface.getEntityName())) continue;
            return operationRequiredRole;
        }
        requiredRole2 = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        requiredRole2.setRequiredInterface__OperationRequiredRole(requiredInterface);
        rootComponent.getRequiredRoles_InterfaceRequiringEntity().add((Object)requiredRole2);
        return requiredRole2;
    }

    private void createInternalAction(ExpressionStatement expressionStatement) {
        LOGGER.debug((Object)"Expression Statement is Internal Action");
        this.actionSeff = this.actionSeff.internalAction().withName(NameUtil.getEntityName(expressionStatement)).followedBy();
    }

    public boolean visit(IfStatement ifStatement) {
        LOGGER.debug((Object)"Visit If Statement");
        BranchActionCreator branchActionCreator = this.actionSeff.branchAction();
        branchActionCreator = this.generateBranchAction((ASTNode)ifStatement, branchActionCreator);
        if (ifStatement.getElseStatement() != null) {
            branchActionCreator = this.handleElseStatement(ifStatement.getElseStatement(), branchActionCreator);
        }
        this.actionSeff = branchActionCreator.withName(NameUtil.getEntityName(ifStatement)).followedBy();
        return false;
    }

    public boolean visit(SynchronizedStatement synchronizedStatement) {
        LOGGER.debug((Object)"Visit Synchronized Statement");
        if (this.getComponentOfRootNode().getPassiveResource_BasicComponent().isEmpty()) {
            PCMRandomVariable randomVariable = CoreFactory.eINSTANCE.createPCMRandomVariable();
            randomVariable.setSpecification("1");
            PassiveResource pass = RepositoryFactory.eINSTANCE.createPassiveResource();
            pass.setCapacity_PassiveResource(randomVariable);
            pass.setResourceTimeoutFailureType__PassiveResource((ResourceTimeoutFailureType)this.fluentFactory.newResourceTimeoutFailureType("PassiveResourceTimeoutFailure").build());
            pass.setEntityName("Passive Resource");
            this.getComponentOfRootNode().getPassiveResource_BasicComponent().add((Object)pass);
        }
        PassiveResource passiveResource = this.getComponentOfRootNode().getPassiveResource_BasicComponent().stream().filter(resource -> resource.getEntityName().equals("Passive Resource")).findFirst().orElseThrow();
        this.actionSeff.acquireAction().withName("Acquire Action").withPassiveResource(passiveResource).followedBy();
        this.actionSeff = this.perform((ASTNode)synchronizedStatement.getBody(), this.actionSeff);
        this.actionSeff.releaseAction().withName("Release Action").withPassiveResource(passiveResource).followedBy();
        return false;
    }

    public boolean visit(TryStatement tryStatement) {
        LOGGER.debug((Object)"Visit Try Statement");
        BranchActionCreator branchActionCreator = this.actionSeff.branchAction();
        branchActionCreator = this.generateBranchAction((ASTNode)tryStatement, branchActionCreator);
        List catchClauseList = tryStatement.catchClauses();
        for (CatchClause catchClause : catchClauseList) {
            ActionSeff innerActionSeff = this.fluentFactory.newSeff().withSeffBehaviour().withStartAction().withName("Start Action").followedBy();
            innerActionSeff = this.perform((ASTNode)catchClause.getBody(), innerActionSeff);
            SeffCreator seffCreator = innerActionSeff.stopAction().withName("Stop Action").createBehaviourNow();
            String condition = NameUtil.getCatchClauseConditionString(catchClause);
            branchActionCreator = branchActionCreator.withGuardedBranchTransition(condition, (Seff)seffCreator, NameUtil.getEntityName(tryStatement));
        }
        this.actionSeff = branchActionCreator.withName(NameUtil.getEntityName(tryStatement)).followedBy();
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        LOGGER.debug((Object)"Visit For Statement");
        LoopActionCreator loopActionCreator = this.actionSeff.loopAction();
        Expression forStatementExpression = forStatement.getExpression();
        if (forStatementExpression != null && forStatementExpression instanceof InfixExpression) {
            loopActionCreator.withIterationCount(((InfixExpression)forStatementExpression).getRightOperand().toString());
        }
        loopActionCreator = this.generateLoopAction((ASTNode)forStatement.getBody(), loopActionCreator);
        this.actionSeff = loopActionCreator.withName(NameUtil.getEntityName(forStatement)).followedBy();
        return false;
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        LOGGER.debug((Object)"Visit Enhanced For Statement");
        LoopActionCreator loopActionCreator = this.actionSeff.loopAction();
        Expression forStatementExpression = enhancedForStatement.getExpression();
        if (forStatementExpression != null && forStatementExpression instanceof SimpleName) {
            loopActionCreator.withIterationCount("1");
        }
        loopActionCreator = this.generateLoopAction((ASTNode)enhancedForStatement.getBody(), loopActionCreator);
        this.actionSeff = loopActionCreator.withName(NameUtil.getEntityName(enhancedForStatement)).followedBy();
        return false;
    }

    public boolean visit(WhileStatement whileStatement) {
        LOGGER.debug((Object)"Visit While Statement");
        LoopActionCreator loopActionCreator = this.actionSeff.loopAction();
        Expression whileStatementExpression = whileStatement.getExpression();
        if (whileStatementExpression != null && whileStatementExpression instanceof SimpleName) {
            loopActionCreator.withIterationCount("1");
        }
        loopActionCreator = this.generateLoopAction((ASTNode)whileStatement.getBody(), loopActionCreator);
        this.actionSeff = loopActionCreator.withName(NameUtil.getEntityName(whileStatement)).followedBy();
        return false;
    }

    public boolean visit(SwitchStatement switchStatement) {
        LOGGER.debug((Object)"Visit Switch Statement");
        BranchActionCreator branchActionCreator = this.actionSeff.branchAction();
        branchActionCreator.withName(NameUtil.getEntityName(switchStatement));
        List<List<Statement>> blockList = SwitchStatementUtil.createBlockListFromSwitchStatement(switchStatement);
        LOGGER.debug((Object)"Generate Inner Branch Behaviour");
        for (List<Statement> block : blockList) {
            ActionSeff innerActionSeff = this.fluentFactory.newSeff().withSeffBehaviour().withStartAction().withName("Start Action").followedBy();
            for (Statement statement : block) {
                innerActionSeff = this.perform((ASTNode)statement, innerActionSeff);
            }
            SeffCreator seffCreator = innerActionSeff.stopAction().withName("Stop Action").createBehaviourNow();
            SwitchCase switchCase = (SwitchCase)block.get(0);
            String condition = NameUtil.getSwitchCaseConditionString(switchCase);
            branchActionCreator = branchActionCreator.withGuardedBranchTransition(condition, seffCreator);
        }
        this.actionSeff = branchActionCreator.withName(NameUtil.getEntityName(switchStatement)).followedBy();
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        LOGGER.debug((Object)"Visit Return Statement");
        Expression returnExpression = returnStatement.getExpression();
        if (returnExpression == null) {
            return false;
        }
        String entityName = NameUtil.getEntityName(returnStatement);
        SetVariableActionCreator setVariableActionCreator = this.actionSeff.setVariableAction().withName(entityName);
        VariableUsageCreator returnVariable = this.generateInputVariableUsage(returnExpression);
        setVariableActionCreator.withLocalVariableUsage(returnVariable);
        this.actionSeff = setVariableActionCreator.followedBy();
        return false;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        LOGGER.debug((Object)"Visit Variable Declaration Statement");
        return false;
    }

    private VariableUsageCreator generateInputVariableUsage(Expression expression, Parameter parameter) {
        VariableUsageCreator variableUsage = this.fluentFactory.newVariableUsage();
        DataType paraDataType = parameter.getDataType__Parameter();
        if (paraDataType instanceof PrimitiveDataType) {
            variableUsage.withNamespaceReference(((PrimitiveDataType)paraDataType).getType().toString(), new String[]{expression.toString()});
            String randomPCMName = String.valueOf(((PrimitiveDataType)paraDataType).getType().toString()) + "." + expression.toString();
            variableUsage.withVariableCharacterisation(randomPCMName, VariableCharacterisationType.VALUE);
        } else if (paraDataType instanceof CompositeDataType) {
            variableUsage.withNamespaceReference(((CompositeDataType)paraDataType).getEntityName(), new String[]{expression.toString()});
            String randomPCMName = String.valueOf(((CompositeDataType)paraDataType).getEntityName()) + "." + expression.toString();
            variableUsage.withVariableCharacterisation(randomPCMName, VariableCharacterisationType.BYTESIZE);
        } else {
            variableUsage.withNamespaceReference(parameter.getParameterName(), new String[]{expression.toString()});
            String randomPCMName = String.valueOf(parameter.getParameterName()) + "." + expression.toString();
            variableUsage.withVariableCharacterisation(randomPCMName, VariableCharacterisationType.VALUE);
        }
        return variableUsage;
    }

    private VariableUsageCreator generateInputVariableUsage(Expression expression) {
        VariableUsageCreator variableUsage = this.fluentFactory.newVariableUsage();
        variableUsage.withNamespaceReference("PrimitiveType", new String[]{NameUtil.getExpressionClassName(expression)});
        String randomPCMName = "PrimitiveType." + NameUtil.getExpressionClassName(expression);
        variableUsage.withVariableCharacterisation(randomPCMName, VariableCharacterisationType.VALUE);
        return variableUsage;
    }

    private VariableUsageCreator generateOutputVariableUsage(DataType returnType) {
        VariableUsageCreator variableUsage = this.fluentFactory.newVariableUsage();
        String randomPCMName = "tempVariable";
        if (returnType instanceof PrimitiveDataType) {
            variableUsage.withNamespaceReference(((PrimitiveDataType)returnType).getType().toString(), new String[]{randomPCMName});
            randomPCMName = String.valueOf(((PrimitiveDataType)returnType).getType().toString()) + "." + randomPCMName;
            variableUsage.withVariableCharacterisation(randomPCMName, VariableCharacterisationType.VALUE);
        } else if (returnType instanceof CompositeDataType) {
            variableUsage.withNamespaceReference(((CompositeDataType)returnType).getEntityName(), new String[]{randomPCMName});
            randomPCMName = String.valueOf(((CompositeDataType)returnType).getEntityName()) + "." + randomPCMName;
            variableUsage.withVariableCharacterisation(randomPCMName, VariableCharacterisationType.BYTESIZE);
        } else {
            variableUsage.withNamespaceReference(null, new String[]{randomPCMName});
            variableUsage.withVariableCharacterisation(randomPCMName, VariableCharacterisationType.VALUE);
        }
        return variableUsage;
    }

    private BranchActionCreator generateBranchAction(ASTNode node, BranchActionCreator branchActionCreator) {
        String condition = "";
        if (node instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)node;
            node = ifStatement.getThenStatement();
            condition = NameUtil.getIfStatementConditionString(ifStatement);
        } else if (node instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)node;
            node = tryStatement.getBody();
            condition = NameUtil.getTryStatementConditionString();
        }
        LOGGER.debug((Object)"Generate Inner Branch Behaviour");
        ActionSeff innerActionSeff = this.fluentFactory.newSeff().withSeffBehaviour().withStartAction().withName("Start Action").followedBy();
        innerActionSeff = this.perform(node, innerActionSeff);
        SeffCreator seffCreator = innerActionSeff.stopAction().withName("Stop Action").createBehaviourNow();
        branchActionCreator.withGuardedBranchTransition(condition, (Seff)seffCreator, "Guarded Branch Transition").withName("Branch Action");
        return branchActionCreator;
    }

    private BranchActionCreator handleElseStatement(Statement statement, BranchActionCreator branchActionCreator) {
        IfStatement elseIfStatement;
        Statement elseStatement;
        ActionSeff innerActionSeff = this.fluentFactory.newSeff().withSeffBehaviour().withStartAction().withName("Start Action").followedBy();
        String condition = "condition";
        if (statement instanceof IfStatement) {
            LOGGER.debug((Object)"Else Statement is If Else Statement");
            IfStatement elseIfStatement2 = (IfStatement)statement;
            innerActionSeff = this.perform((ASTNode)elseIfStatement2.getThenStatement(), innerActionSeff);
            condition = NameUtil.getIfStatementConditionString(elseIfStatement2);
        } else {
            LOGGER.debug((Object)"If Statement is Else Statement");
            innerActionSeff = this.perform((ASTNode)statement, innerActionSeff);
            condition = NameUtil.getElseStatementConditionString();
        }
        SeffCreator seffCreator = innerActionSeff.stopAction().withName("Stop Action").createBehaviourNow();
        branchActionCreator = branchActionCreator.withGuardedBranchTransition(condition, (Seff)seffCreator, "Guarded Branch Transition");
        if (statement instanceof IfStatement && (elseStatement = (elseIfStatement = (IfStatement)statement).getElseStatement()) != null) {
            branchActionCreator = this.handleElseStatement(elseStatement, branchActionCreator);
        }
        return branchActionCreator;
    }

    private LoopActionCreator generateLoopAction(ASTNode node, LoopActionCreator loopActionCreator) {
        LOGGER.debug((Object)"Generate Inner Loop Behaviour");
        ActionSeff innerActionSeff = this.fluentFactory.newSeff().withSeffBehaviour().withStartAction().withName("Start Action").followedBy();
        innerActionSeff = this.perform(node, innerActionSeff);
        SeffCreator seffCreator = innerActionSeff.stopAction().withName("Stop Action").createBehaviourNow();
        loopActionCreator.withLoopBody((Seff)seffCreator);
        return loopActionCreator;
    }

    private BasicComponent getComponentOfRootNode() {
        return this.externalNodes.get(this.rootNode).getBasicComponent_ServiceEffectSpecification();
    }

    private OperationInterface getOperationInterfaceOfRootNode() {
        ResourceDemandingSEFF seff = (ResourceDemandingSEFF)this.externalNodes.get(this.rootNode);
        OperationSignature signature = (OperationSignature)seff.getDescribedService__SEFF();
        return signature.getInterface__OperationSignature();
    }

    private boolean isExternal(MethodInvocation invocation) {
        BasicComponent rootComponent = this.getComponentOfRootNode();
        Optional<ServiceEffectSpecification> optionalSeff = this.getServiceEffectSpecificationOfInvocation(invocation);
        return optionalSeff.isPresent() && !optionalSeff.get().getBasicComponent_ServiceEffectSpecification().getEntityName().equals(rootComponent.getEntityName());
    }

    private Optional<OperationInterface> getOperationInterfaceOfInvocation(MethodInvocation invocation) {
        Optional<ServiceEffectSpecification> optionalSeff = this.getServiceEffectSpecificationOfInvocation(invocation);
        if (optionalSeff.isPresent()) {
            OperationSignature signature = (OperationSignature)optionalSeff.get().getDescribedService__SEFF();
            return Optional.of(signature.getInterface__OperationSignature());
        }
        return Optional.empty();
    }

    private Optional<OperationSignature> getOperationSignatureOfInvocation(MethodInvocation invocation) {
        Optional<ServiceEffectSpecification> optionalSeff = this.getServiceEffectSpecificationOfInvocation(invocation);
        if (optionalSeff.isPresent()) {
            return Optional.of((OperationSignature)optionalSeff.get().getDescribedService__SEFF());
        }
        return Optional.empty();
    }

    private Optional<ServiceEffectSpecification> getServiceEffectSpecificationOfInvocation(MethodInvocation invocation) {
        IMethodBinding invocationBinding = invocation.resolveMethodBinding();
        for (ASTNode node : this.externalNodes.keySet()) {
            ServiceEffectSpecification seff = this.externalNodes.get(node);
            MethodDeclaration methodDeclaration = (MethodDeclaration)node;
            IMethodBinding declarationBinding = methodDeclaration.resolveBinding();
            if (!Objects.nonNull(declarationBinding) || !Objects.nonNull(invocationBinding) || !declarationBinding.getKey().equals(invocationBinding.getKey())) continue;
            return Optional.of(seff);
        }
        return Optional.empty();
    }
}

