/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.somox.ast2seff.jobs;

import com.google.common.collect.ArrayListMultimap;
import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.net4j.util.om.monitor.SubMonitor;
import org.palladiosimulator.generator.fluent.repository.api.Repo;
import org.palladiosimulator.generator.fluent.repository.api.RepoAddition;
import org.palladiosimulator.generator.fluent.repository.api.seff.ActionSeff;
import org.palladiosimulator.generator.fluent.repository.factory.FluentRepositoryFactory;
import org.palladiosimulator.generator.fluent.repository.structure.components.seff.SeffCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.Interface;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.OperationInterfaceCreator;
import org.palladiosimulator.generator.fluent.repository.structure.interfaces.OperationSignatureCreator;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.somox.ast2seff.visitors.Ast2SeffVisitor;

public class Ast2SeffJob
implements IBlackboardInteractingJob<Blackboard<Object>> {
    private static final Logger LOGGER = Logger.getLogger(Ast2SeffJob.class);
    private static final FluentRepositoryFactory fluentFactory = new FluentRepositoryFactory();
    private Blackboard<Object> blackboard;
    private final String ast2SeffMapKey;
    private final String repositoryOutputKey;
    private Map<ASTNode, ServiceEffectSpecification> ast2SeffMap;

    public Ast2SeffJob(Blackboard<Object> blackboard, String ast2SeffMapKey, String repositoryOutputKey) {
        this.blackboard = Objects.requireNonNull(blackboard);
        this.ast2SeffMapKey = Objects.requireNonNull(ast2SeffMapKey);
        this.repositoryOutputKey = Objects.requireNonNull(repositoryOutputKey);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        LOGGER.info((Object)"Starting SEFF Creation Job.");
        monitor.subTask("Loading AST node to SEFF association map from blackboard");
        this.ast2SeffMap = (Map)this.blackboard.getPartition(this.ast2SeffMapKey);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.setTaskName("Creating SEFF behaviour");
        LOGGER.info((Object)("Creating " + this.ast2SeffMap.size() + " SEFFs."));
        Repo repoAddition = fluentFactory.newRepository().withName("Repository");
        this.createSeffsForComponents((RepoAddition)repoAddition, monitor);
        LOGGER.info((Object)"Created SEFFs. Creating Repository.");
        Repository repository = repoAddition.createRepositoryNow();
        LOGGER.info((Object)"Created Repository. Writing Result to Blackboard.");
        this.blackboard.addPartition(this.repositoryOutputKey, (Object)repository);
        LOGGER.info((Object)"Task finished.");
        subMonitor.done();
    }

    private void createSeffsForComponents(RepoAddition repoAddition, IProgressMonitor monitor) {
        List<OperationInterface> persistedInterfaces = this.ast2SeffMap.values().stream().map(seff -> ((OperationSignature)seff.getDescribedService__SEFF()).getInterface__OperationSignature()).distinct().toList();
        for (OperationInterface persistedInterface : persistedInterfaces) {
            OperationInterfaceCreator operationInterfaceCreator = fluentFactory.newOperationInterface().withName(persistedInterface.getEntityName());
            List<OperationSignature> persistedSignatures = this.ast2SeffMap.values().stream().map(seff -> (OperationSignature)seff.getDescribedService__SEFF()).filter(signature -> signature.getInterface__OperationSignature().getEntityName().equals(persistedInterface.getEntityName())).distinct().toList();
            for (OperationSignature persistedSignature : persistedSignatures) {
                OperationSignatureCreator operationSignatureCreator = fluentFactory.newOperationSignature().withName(persistedSignature.getEntityName());
                DataType returnType = persistedSignature.getReturnType__OperationSignature();
                if (returnType != null) {
                    operationSignatureCreator.withReturnType(returnType);
                }
                for (Parameter parameter : persistedSignature.getParameters__OperationSignature()) {
                    operationSignatureCreator.withParameter(parameter.getParameterName(), parameter.getDataType__Parameter(), parameter.getModifier__Parameter());
                }
                operationInterfaceCreator.withOperationSignature(operationSignatureCreator);
            }
            repoAddition.addToRepository((Interface)operationInterfaceCreator);
        }
        ArrayListMultimap componentNodeMap = ArrayListMultimap.create();
        for (ASTNode node : this.ast2SeffMap.keySet()) {
            ServiceEffectSpecification placeholderSeff = this.ast2SeffMap.get(node);
            BasicComponent persistedComponent = placeholderSeff.getBasicComponent_ServiceEffectSpecification();
            componentNodeMap.put((Object)persistedComponent, (Object)node);
        }
        ArrayListMultimap fluentComponentNodeMap = ArrayListMultimap.create();
        for (BasicComponent persistedComponent : componentNodeMap.keySet()) {
            BasicComponent placeholderComponent = fluentFactory.newBasicComponent().withName(persistedComponent.getEntityName()).build();
            repoAddition.addToRepository((RepositoryComponent)placeholderComponent);
            Collection nodes = componentNodeMap.get((Object)persistedComponent);
            fluentComponentNodeMap.putAll((Object)placeholderComponent, (Iterable)nodes);
        }
        HashMap<ASTNode, ServiceEffectSpecification> ast2FluentSeffMap = new HashMap<ASTNode, ServiceEffectSpecification>();
        for (ASTNode node : this.ast2SeffMap.keySet()) {
            ServiceEffectSpecification realSeff = this.ast2SeffMap.get(node);
            BasicComponent fluentComponent = fluentFactory.fetchOfBasicComponent(realSeff.getBasicComponent_ServiceEffectSpecification().getEntityName());
            OperationSignature fluentSignature = fluentFactory.fetchOfOperationSignature(realSeff.getDescribedService__SEFF().getEntityName());
            ServiceEffectSpecification fluentSeff = fluentFactory.newSeff().onSignature((Signature)fluentSignature).withSeffBehaviour().withStartAction().withName("Start Action").followedBy().stopAction().withName("Stop Action").createBehaviourNow().build();
            fluentComponent.getServiceEffectSpecifications__BasicComponent().add((Object)fluentSeff);
            ast2FluentSeffMap.put(node, fluentSeff);
        }
        for (BasicComponent fluentComponent : fluentComponentNodeMap.keySet()) {
            for (ASTNode node : fluentComponentNodeMap.get((Object)fluentComponent)) {
                ServiceEffectSpecification fluentSeff = (ServiceEffectSpecification)ast2FluentSeffMap.get(node);
                OperationSignature fluentSignature = (OperationSignature)fluentSeff.getDescribedService__SEFF();
                OperationInterface fluentInterface = fluentSignature.getInterface__OperationSignature();
                boolean providedRoleMissing = fluentComponent.getProvidedRoles_InterfaceProvidingEntity().stream().map(role -> (OperationProvidedRole)role).map(role -> role.getProvidedInterface__OperationProvidedRole()).noneMatch(operationInterface2 -> operationInterface2.getEntityName().equals(fluentInterface.getEntityName()));
                if (providedRoleMissing) {
                    OperationProvidedRole providedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
                    providedRole.setProvidedInterface__OperationProvidedRole(fluentInterface);
                    fluentComponent.getProvidedRoles_InterfaceProvidingEntity().add((Object)providedRole);
                }
                ActionSeff actionSeff = fluentFactory.newSeff().onSignature((Signature)fluentSignature).withSeffBehaviour().withStartAction().withName("Start Action").followedBy();
                SeffCreator actionSeffCreator = Ast2SeffVisitor.perform(actionSeff, node, ast2FluentSeffMap, fluentFactory).stopAction().withName("Stop Action").createBehaviourNow();
                fluentComponent.getServiceEffectSpecifications__BasicComponent().add((Object)actionSeffCreator.build());
            }
            monitor.worked(1);
        }
        for (BasicComponent fluentComponent : fluentComponentNodeMap.keySet()) {
            for (ASTNode node : fluentComponentNodeMap.get((Object)fluentComponent)) {
                ServiceEffectSpecification emptySeffPlaceholder = (ServiceEffectSpecification)ast2FluentSeffMap.get(node);
                fluentComponent.getServiceEffectSpecifications__BasicComponent().remove((Object)emptySeffPlaceholder);
            }
        }
    }

    public String getName() {
        return "AST 2 SEFF Transformation Job";
    }

    public void setBlackboard(Blackboard<Object> blackboard) {
        this.blackboard = blackboard;
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }
}

