/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder.util;

import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.repository.Signature;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.OperationBuilder;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;
import org.somox.util.SourceCodeDecoratorHelper;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.types.Type;

public class PcmModelCreationHelper {
    private static final Logger logger = Logger.getLogger((String)PcmModelCreationHelper.class.getSimpleName());
    private final OperationBuilder operationBuilder;
    private final SourceCodeDecoratorHelper sourceCodeDecoratorHelper;

    public PcmModelCreationHelper(OperationBuilder operationBuilder, SourceCodeDecoratorRepository sourceCodeDecorator, SourceCodeDecoratorHelper sourceCodeDecoratorHelper) {
        this.operationBuilder = operationBuilder;
        this.sourceCodeDecoratorHelper = sourceCodeDecoratorHelper;
    }

    public PcmModelCreationHelper(AnalysisResult analysisResult, SourceCodeDecoratorHelper sourceCodeDecoratorHelper) {
        this(new OperationBuilder(analysisResult.getRoot(), null, analysisResult), analysisResult.getSourceCodeDecoratorRepository(), sourceCodeDecoratorHelper);
    }

    public OperationSignature createOperationSignatureInInterfaceForJaMoPPMemberAndUpdateSourceCodeDecorator(OperationInterface opInterface, Repository repo, Member jaMoPPMember) {
        if (!(jaMoPPMember instanceof Method) && !(jaMoPPMember instanceof Constructor)) {
            return null;
        }
        OperationSignature opSignature = RepositoryFactory.eINSTANCE.createOperationSignature();
        opSignature.setEntityName(jaMoPPMember.getName());
        if (jaMoPPMember instanceof Method var5_6) {
            if (jaMoPPMethod.getTypeReference() != null && jaMoPPMethod.getTypeReference().getTarget() != null) {
                DataType returnType = this.getDataTypeAndUpdateSourceCodeDecorator(repo, jaMoPPMethod.getTypeReference().getTarget(), (ArrayTypeable)jaMoPPMethod.getTypeReference());
                opSignature.setReturnType__OperationSignature(returnType);
            } else {
                logger.info((Object)("Could not find an approoriate type for: " + jaMoPPMethod + " in class " + (jaMoPPMember != null ? jaMoPPMember.getContainingConcreteClassifier() : "null") + " use Object instead"));
                DataType defaultDataType = this.operationBuilder.returnDefaultDataType((Commentable)jaMoPPMethod, repo);
                opSignature.setReturnType__OperationSignature(defaultDataType);
            }
            for (tools.mdsd.jamopp.model.java.parameters.Parameter jaMoPPParam : jaMoPPMethod.getParameters()) {
                this.createParameterAndAddParameter(repo, opSignature, jaMoPPParam);
            }
        } else {
            if (jaMoPPMember instanceof Constructor jaMoPPParam) {
                for (tools.mdsd.jamopp.model.java.parameters.Parameter ctorParam : ctor.getParameters()) {
                    this.createParameterAndAddParameter(repo, opSignature, ctorParam);
                }
            }
        }
        OperationSignature retOpSignature = this.hasSignature(opSignature, opInterface);
        if (retOpSignature == opSignature) {
            opInterface.getSignatures__OperationInterface().add((Object)opSignature);
            this.sourceCodeDecoratorHelper.createMethodLevelSourceCodeLink((Signature)opSignature, jaMoPPMember);
        }
        return retOpSignature;
    }

    public EventGroup createEventGroupAndEventTypeAndUpdateSourceCodeDecorator(ConcreteClassifier observedEventDataType, Repository repository, tools.mdsd.jamopp.model.java.parameters.Parameter observedJaMoPPParameter, Member jaMoPPMember) {
        EventGroup eventGroup = this.createEventGroupAndUpdateSCDM(observedEventDataType);
        this.createEventType(eventGroup, repository, observedEventDataType, observedJaMoPPParameter, jaMoPPMember);
        return eventGroup;
    }

    private EventType createEventType(EventGroup eventGroup, Repository repoitory, ConcreteClassifier observedEventDataType, tools.mdsd.jamopp.model.java.parameters.Parameter observedJaMoPPParameter, Member jaMoPPMember) {
        EventType eventType = RepositoryFactory.eINSTANCE.createEventType();
        eventType.setEntityName(observedEventDataType.getName());
        eventGroup.getEventTypes__EventGroup().add((Object)eventType);
        Parameter parameter = this.createParameter(repoitory, observedJaMoPPParameter);
        this.sourceCodeDecoratorHelper.createMethodLevelSourceCodeLink((Signature)eventType, jaMoPPMember);
        eventType.setParameter__EventType(parameter);
        return eventType;
    }

    private EventGroup createEventGroupAndUpdateSCDM(ConcreteClassifier jaMoPPClassifier) {
        EventGroup eventGroup = RepositoryFactory.eINSTANCE.createEventGroup();
        eventGroup.setEntityName(jaMoPPClassifier.getName());
        this.sourceCodeDecoratorHelper.createInterfaceSourceCodeLink((Interface)eventGroup, jaMoPPClassifier);
        return eventGroup;
    }

    private DataType getDataTypeAndUpdateSourceCodeDecorator(Repository repo, Type jaMoPPType, ArrayTypeable arrayTypeable) {
        return this.operationBuilder.getType(jaMoPPType, repo, arrayTypeable);
    }

    private void createParameterAndAddParameter(Repository repo, OperationSignature opSignature, tools.mdsd.jamopp.model.java.parameters.Parameter jaMoPPParam) {
        Parameter pcmParam = this.createParameter(repo, jaMoPPParam);
        opSignature.getParameters__OperationSignature().add((Object)pcmParam);
    }

    private Parameter createParameter(Repository repo, tools.mdsd.jamopp.model.java.parameters.Parameter jaMoPPParam) {
        Parameter pcmParam = RepositoryFactory.eINSTANCE.createParameter();
        pcmParam.setParameterName(jaMoPPParam.getName());
        if (jaMoPPParam.getTypeReference() != null && jaMoPPParam.getTypeReference().getTarget() != null) {
            DataType dataType = this.getDataTypeAndUpdateSourceCodeDecorator(repo, jaMoPPParam.getTypeReference().getTarget(), (ArrayTypeable)jaMoPPParam.getTypeReference());
            pcmParam.setDataType__Parameter(dataType);
        } else {
            logger.info((Object)("No PCM param build for parameter: " + jaMoPPParam + " for parameter " + (jaMoPPParam != null ? jaMoPPParam.getContainingConcreteClassifier() : "null") + " use Object instead"));
            DataType defaultDataType = this.operationBuilder.returnDefaultDataType((Commentable)jaMoPPParam, repo);
            pcmParam.setDataType__Parameter(defaultDataType);
        }
        return pcmParam;
    }

    private OperationSignature hasSignature(OperationSignature newOpSignature, OperationInterface opInterface) {
        for (OperationSignature opSignature : opInterface.getSignatures__OperationInterface()) {
            if (!this.signatureEquals(opSignature, newOpSignature)) continue;
            return opSignature;
        }
        return newOpSignature;
    }

    private boolean signatureEquals(OperationSignature opSignature, OperationSignature newOpSignature) {
        if (opSignature == newOpSignature) {
            return true;
        }
        if (opSignature == null == (newOpSignature != null) || !this.entityNameEquals(opSignature, newOpSignature) || !this.dataTypeEquals(opSignature.getReturnType__OperationSignature(), newOpSignature.getReturnType__OperationSignature()) || opSignature.getParameters__OperationSignature().size() != newOpSignature.getParameters__OperationSignature().size()) {
            return false;
        }
        int i = 0;
        Parameter oldParam = null;
        Parameter newParam = null;
        while (i < opSignature.getParameters__OperationSignature().size()) {
            oldParam = (Parameter)opSignature.getParameters__OperationSignature().get(i);
            newParam = (Parameter)newOpSignature.getParameters__OperationSignature().get(i);
            if (!this.dataTypeEquals(newParam.getDataType__Parameter(), oldParam.getDataType__Parameter())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean entityNameEquals(OperationSignature first, OperationSignature secound) {
        if (first == null && secound == null) {
            return true;
        }
        if (first == null == (secound != null)) {
            return false;
        }
        return first.getEntityName().equals(secound.getEntityName());
    }

    private boolean dataTypeEquals(DataType first, DataType secound) {
        if (first == null && secound == null) {
            return true;
        }
        if (first == null == (secound != null)) {
            return false;
        }
        return first.equals(secound);
    }

    public OperationInterface createOperationInterfaceAndUpdateSCDM(ConcreteClassifier concreteClassifier) {
        OperationInterface opInterface = RepositoryFactory.eINSTANCE.createOperationInterface();
        opInterface.setEntityName(concreteClassifier.getName());
        this.sourceCodeDecoratorHelper.createInterfaceSourceCodeLink((Interface)opInterface, concreteClassifier);
        return opInterface;
    }
}

