/*
 * Decompiled with CFR 0.152.
 */
package org.somox.configuration;

import de.uka.ipd.sdq.workflow.configuration.AbstractComposedJobConfiguration;
import de.uka.ipd.sdq.workflow.configuration.IJobConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.somox.configuration.FileLocationConfiguration;

public abstract class AbstractMoxConfiguration
extends AbstractComposedJobConfiguration
implements IJobConfiguration {
    private static final Logger logger = Logger.getLogger((String)AbstractMoxConfiguration.class.getSimpleName());
    private static final String SOMOX_OUTPUT_FOLDER_DEFAULT = "/model";
    public static final String SOMOX_OUTPUT_FOLDER = "org.somox.outputfile";
    public static final String SOMOX_PROJECT_NAME = "org.somox.project";
    public static final String SOMOX_ANALYZER_INPUT_FILE = "org.somox.analyzer.inputfile";
    public static final String SOMOX_ANALYZER_REVERSE_ENGINEER_INTERFACES_NOT_ASSIGNED_TO_INTERFACES = "org.somox.analyzer.ReverseEngineerInterfacesNotAssignedToComponent";
    public static final String SOMOX_ANALYZER_REVERSE_ENGINEER_INTERNAL_METHODS_AS_RESOURCE_DEMANDING_INTERNAL_BEHAVIOUR = "org.somox.analyzer.ReverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour";
    private final FileLocationConfiguration locations = new FileLocationConfiguration();
    private boolean reverseEngineerInterfacesNotAssignedToComponent;
    private boolean reverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour;

    public FileLocationConfiguration getFileLocations() {
        return this.locations;
    }

    public boolean isReverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour() {
        return this.reverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour;
    }

    public void setReverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour(boolean reverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour) {
        this.reverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour = reverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour;
    }

    public boolean isReverseEngineerInterfacesNotAssignedToComponent() {
        return this.reverseEngineerInterfacesNotAssignedToComponent;
    }

    public void setReverseEngineerInterfacesNotAssignedToComponent(boolean reverseEngineerInterfacesNotAssignedToComponent) {
        this.reverseEngineerInterfacesNotAssignedToComponent = reverseEngineerInterfacesNotAssignedToComponent;
    }

    public void applyAttributeMap(Map<String, Object> attributeMap) {
        logger.debug((Object)"SoMoX configuration extended by these attributes:");
        for (String key : attributeMap.keySet()) {
            String keyname = key.toString();
            if (!keyname.contains("org.somox")) continue;
            logger.debug((Object)(key + "=" + attributeMap.get(key)));
        }
        FileLocationConfiguration fileLocations = this.getFileLocations();
        if (attributeMap.get(SOMOX_PROJECT_NAME) != null) {
            fileLocations.setProjectNames(Set.of((String)attributeMap.get(SOMOX_PROJECT_NAME)));
        }
        if (attributeMap.get(SOMOX_ANALYZER_INPUT_FILE) != null) {
            fileLocations.setAnalyserInputFile((String)attributeMap.get(SOMOX_ANALYZER_INPUT_FILE));
        }
        if (attributeMap.get(SOMOX_OUTPUT_FOLDER) != null) {
            fileLocations.setOutputFolder((String)attributeMap.get(SOMOX_OUTPUT_FOLDER));
        } else if (fileLocations.getProjectNames() != null && fileLocations.getProjectNames().size() > 0) {
            fileLocations.setOutputFolder("/" + fileLocations.getProjectNames().iterator().next() + SOMOX_OUTPUT_FOLDER_DEFAULT);
        }
        if (attributeMap.get(SOMOX_ANALYZER_REVERSE_ENGINEER_INTERFACES_NOT_ASSIGNED_TO_INTERFACES) != null) {
            boolean allInterfacesStrategy = (Boolean)attributeMap.get(SOMOX_ANALYZER_REVERSE_ENGINEER_INTERFACES_NOT_ASSIGNED_TO_INTERFACES);
            this.setReverseEngineerInterfacesNotAssignedToComponent(allInterfacesStrategy);
        }
        if (attributeMap.get(SOMOX_ANALYZER_REVERSE_ENGINEER_INTERNAL_METHODS_AS_RESOURCE_DEMANDING_INTERNAL_BEHAVIOUR) != null) {
            boolean reverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour = (Boolean)attributeMap.get(SOMOX_ANALYZER_REVERSE_ENGINEER_INTERNAL_METHODS_AS_RESOURCE_DEMANDING_INTERNAL_BEHAVIOUR);
            this.setReverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour(reverseEngineerInternalMethodsAsResourceDemandingInternalBehaviour);
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(SOMOX_PROJECT_NAME, this.getFileLocations().getProjectNames());
        result.put(SOMOX_ANALYZER_INPUT_FILE, this.getFileLocations().getAnalyserInputFile());
        result.put(SOMOX_ANALYZER_REVERSE_ENGINEER_INTERFACES_NOT_ASSIGNED_TO_INTERFACES, this.isReverseEngineerInterfacesNotAssignedToComponent());
        result.put(SOMOX_OUTPUT_FOLDER, this.getFileLocations().getOutputFolder());
        return result;
    }
}

