/*
 * Decompiled with CFR 0.152.
 */
package org.somox.filter.tests;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class EclipseAstFactory {
    private static final ThreadLocal<ASTParser> AST_PARSER = ThreadLocal.withInitial(() -> ASTParser.newParser((int)8));

    public CompilationUnit getCompilationUnit(java.nio.file.Path path) throws IOException {
        return this.getCompilationUnit(path, false);
    }

    public CompilationUnit getCompilationUnit(java.nio.file.Path path, boolean withBindings) throws IOException {
        Path eclipsePath = new Path(path.toString());
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IFile eclipseResource = rootWorkspace.getFileForLocation((IPath)eclipsePath);
        IJavaElement eclipseElement = JavaCore.create((IFile)eclipseResource);
        if (eclipseElement == null || eclipseElement.getElementType() != 5) {
            throw new IllegalArgumentException(path + " is not a valid compilation unit of the analysed project.");
        }
        return this.getCompilationUnit((ICompilationUnit)eclipseElement, withBindings);
    }

    public CompilationUnit getCompilationUnit(ICompilationUnit compilationUnit, boolean withBindings) throws IOException {
        ASTParser parser = AST_PARSER.get();
        parser.setKind(8);
        parser.setSource(compilationUnit);
        parser.setResolveBindings(withBindings);
        return (CompilationUnit)parser.createAST(null);
    }
}

