/*
 * Decompiled with CFR 0.152.
 */
package org.somox.filter;

import java.util.List;
import org.apache.log4j.Logger;
import org.somox.filter.BaseFilter;
import org.somox.kdmhelper.KDMHelper;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Method;

public class DataObjectFilter
extends BaseFilter<ConcreteClassifier> {
    private static final Logger logger = Logger.getLogger(DataObjectFilter.class);
    private final String[] filteredPrefixes = new String[]{"is", "get", "set", "equals", "hashcode"};

    @Override
    public boolean passes(ConcreteClassifier object) {
        if (object instanceof EnumConstant) {
            return true;
        }
        List allMethods = KDMHelper.getMethods((ConcreteClassifier)object);
        for (Method m : allMethods) {
            if (!m.isPublic() || !this.isNotGetterOrSetter(m)) continue;
            return true;
        }
        logger.debug((Object)("Removed GAST Class " + object.toString() + " from component candidates as it is a datatype"));
        return false;
    }

    private boolean isNotGetterOrSetter(Method m) {
        boolean result = false;
        String simpleMethodName = m.getName().toLowerCase();
        String[] stringArray = this.filteredPrefixes;
        int n = this.filteredPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            result |= simpleMethodName.startsWith(prefix);
            ++n2;
        }
        return !result;
    }
}

