/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.somox.gast2seff.visitors.BasicFunctionClassificationStrategy;
import org.somox.gast2seff.visitors.FunctionCallClassificationVisitor;
import org.somox.gast2seff.visitors.IFunctionClassificationStrategy;
import org.somox.gast2seff.visitors.MethodCallFinder;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.statements.Statement;

public abstract class AbstractFunctionClassificationStrategy
implements IFunctionClassificationStrategy {
    private final Logger logger = Logger.getLogger(BasicFunctionClassificationStrategy.class);
    private final MethodCallFinder methodCallFinder;

    public AbstractFunctionClassificationStrategy(MethodCallFinder methodCallFinder) {
        this.methodCallFinder = methodCallFinder;
    }

    @Override
    public List<BitSet> classifySimpleStatement(Statement object) {
        List<Method> methods = this.methodCallFinder.getMethodCalls(object);
        ArrayList<BitSet> result = new ArrayList<BitSet>(methods.size());
        for (Method method : methods) {
            BitSet currentBitSet = new BitSet();
            if (method != null) {
                if (this.isExternalCall(method)) {
                    this.logger.debug((Object)("Found external call: " + method.getName()));
                    currentBitSet.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
                } else if (this.isEmitEventCall(method)) {
                    this.logger.debug((Object)("Found emit event call: " + method.getName()));
                    currentBitSet.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EMITEVENT));
                } else if (this.isLibraryCall(method)) {
                    this.logger.debug((Object)("Found library call: " + method.getName()));
                    currentBitSet.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.LIBRARY));
                } else {
                    this.logger.debug((Object)("Found internal call: " + method.getName()));
                    currentBitSet.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.INTERNAL));
                }
            }
            result.add(currentBitSet);
        }
        if (result.isEmpty()) {
            result.add(new BitSet());
        }
        return result;
    }

    @Override
    public void mergeFunctionCallType(BitSet myType, Collection<BitSet> functionCallTypes) {
        if (myType == null || functionCallTypes == null) {
            this.logger.debug((Object)("myType: " + myType + " and/or functionCallTypes: " + functionCallTypes + " is null. mergeFunctionCallType can not be applied"));
            return;
        }
        for (BitSet functionCallType : functionCallTypes) {
            if (functionCallType == null) {
                this.logger.debug((Object)("current functionCallType in " + functionCallTypes + " is null. mergeFunctionCallType can not be applied for the functionCallType."));
                continue;
            }
            myType.or(functionCallType);
        }
    }

    protected abstract boolean isExternalCall(Method var1);

    protected boolean isEmitEventCall(Method method) {
        return false;
    }

    protected abstract boolean isLibraryCall(Method var1);
}

