/*
 * Decompiled with CFR 0.152.
 */
package org.somox.kdmhelper;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.somox.kdmhelper.SoMoXUtil;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.splevo.jamopp.extraction.JaMoPPSoftwareModelExtractor;
import tools.mdsd.jamopp.model.java.containers.CompilationUnit;

public class KDMReader {
    private final Root root = new Root();
    private static final Logger logger = Logger.getLogger((String)KDMReader.class.getName());

    public Root getRoot() {
        return this.root;
    }

    public void loadProject(String ... projects) throws IOException {
        JaMoPPSoftwareModelExtractor softwareModelExtractor = new JaMoPPSoftwareModelExtractor();
        Path cacheFileDir = Paths.get(System.getProperty("java.io.tmpdir", "/tmp/"), "JaMoPPGeneratorJobCacheDirSoMoX");
        logger.trace((Object)("Start loading projects: " + Arrays.toString(projects)));
        ArrayList<File> sourceFolderPaths = new ArrayList<File>();
        if (SoMoXUtil.isStandalone()) {
            String[] stringArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                String projectPath = stringArray[n2];
                sourceFolderPaths.add(new File(projectPath));
                ++n2;
            }
        } else {
            String[] stringArray = projects;
            int n = projects.length;
            int n3 = 0;
            while (n3 < n) {
                String projectName = stringArray[n3];
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IProject project = workspaceRoot.getProject(projectName);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject.exists()) {
                    sourceFolderPaths.add(project.getRawLocation().toFile());
                } else {
                    logger.warn((Object)String.format("Project %s is not a java project in this workspace. Ignoring it.", projectName));
                }
                ++n3;
            }
        }
        softwareModelExtractor.extractSoftwareModelFromFolders(sourceFolderPaths, (IProgressMonitor)new NullProgressMonitor(), cacheFileDir.toString(), true);
        this.addModelsToRoot(softwareModelExtractor.getSourceResources());
        logger.trace((Object)"Finished reading projects.");
    }

    public void loadProject(IProject ... projects) throws IOException {
        ArrayList<String> projectPaths = new ArrayList<String>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            projectPaths.add(project.getLocation().toString());
            ++n2;
        }
        this.loadPathes();
    }

    private void loadPathes() {
        throw new RuntimeException("not implemented yet");
    }

    public void addModelsToRoot(Collection<Resource> resources) {
        for (Resource resource : resources) {
            this.root.addModels(this.getModelsFromResource(resource));
        }
    }

    private Collection<CompilationUnit> getModelsFromResource(Resource resource) {
        ArrayList<CompilationUnit> modelList = new ArrayList<CompilationUnit>();
        for (EObject obj : resource.getContents()) {
            if (!(obj instanceof CompilationUnit var5_5)) continue;
            modelList.add((CompilationUnit)model);
        }
        return modelList;
    }
}

