/*
 * generated by Xtext
 */
package org.somox.metrics.dsl.ui.internal;

import java.util.Collections;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.shared.SharedStateModule;
import org.eclipse.xtext.util.Modules2;
import org.osgi.framework.BundleContext;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;

/**
 * This class was generated. Customizations should only happen in a newly
 * introduced subclass.
 */
public class MetricDSLActivator extends AbstractUIPlugin {

    public static final String ORG_SOMOX_METRICS_DSL_METRICDSL = "org.somox.metrics.dsl.MetricDSL";

    private static final Logger logger = Logger.getLogger(MetricDSLActivator.class);

    private static MetricDSLActivator INSTANCE;

    private final Map<String, Injector> injectors = Collections
            .synchronizedMap(Maps.<String, Injector>newHashMapWithExpectedSize(1));

    @Override
    public void start(final BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    @Override
    public void stop(final BundleContext context) throws Exception {
        injectors.clear();
        INSTANCE = null;
        super.stop(context);
    }

    public static MetricDSLActivator getInstance() {
        return INSTANCE;
    }

    public Injector getInjector(final String language) {
        synchronized (injectors) {
            Injector injector = injectors.get(language);
            if (injector == null) {
                injectors.put(language, injector = createInjector(language));
            }
            return injector;
        }
    }

    protected Injector createInjector(final String language) {
        try {
            final Module runtimeModule = getRuntimeModule(language);
            final Module sharedStateModule = getSharedStateModule();
            final Module uiModule = getUiModule(language);
            final Module mergedModule = Modules2.mixin(runtimeModule, sharedStateModule, uiModule);
            return Guice.createInjector(mergedModule);
        } catch (final Exception e) {
            logger.error("Failed to create injector for " + language);
            logger.error(e.getMessage(), e);
            throw new RuntimeException("Failed to create injector for " + language, e);
        }
    }

    protected Module getRuntimeModule(final String grammar) {
        if (ORG_SOMOX_METRICS_DSL_METRICDSL.equals(grammar)) {
            return new org.somox.metrics.dsl.MetricDSLRuntimeModule();
        }

        throw new IllegalArgumentException(grammar);
    }

    protected Module getUiModule(final String grammar) {
        if (ORG_SOMOX_METRICS_DSL_METRICDSL.equals(grammar)) {
            return new org.somox.metrics.dsl.ui.MetricDSLUiModule(this);
        }

        throw new IllegalArgumentException(grammar);
    }

    protected Module getSharedStateModule() {
        return new SharedStateModule();
    }

}
