/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.somox.metrics.Activator;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;

public class MetricsRegistry {
    private static final String METRIC_CLASS_ATTRIBUTE = "class";
    private static final String METRIC_ATTRIBUTE_NAME = "metric";
    private static final String METRIC_FORMULA_ATTRIBUTE_NAME = "metricformula";
    private static final String ORG_SOMOX_CORE_METRIC_EXTENSION_ID = "org.somox.core.metric";
    private static final Logger LOG = Logger.getLogger(MetricsRegistry.class);
    private static final Map<MetricID, IMetric> registeredMetrics = Collections.unmodifiableMap(MetricsRegistry.internalGetRegisteredMetrics());

    public static final Map<MetricID, IMetric> getRegisteredMetrics() {
        return registeredMetrics;
    }

    private static Map<MetricID, IMetric> internalGetRegisteredMetrics() {
        IConfigurationElement metricExtension;
        IConfigurationElement[] metricExtensions;
        HashMap<MetricID, IMetric> allMetrics = new HashMap<MetricID, IMetric>();
        IConfigurationElement[] iConfigurationElementArray = metricExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(ORG_SOMOX_CORE_METRIC_EXTENSION_ID);
        int n = metricExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            metricExtension = iConfigurationElementArray[n2];
            if (METRIC_ATTRIBUTE_NAME.equals(metricExtension.getName())) {
                MetricsRegistry.parseBasicMetric(allMetrics, metricExtension);
            }
            ++n2;
        }
        iConfigurationElementArray = metricExtensions;
        n = metricExtensions.length;
        n2 = 0;
        while (n2 < n) {
            metricExtension = iConfigurationElementArray[n2];
            if (METRIC_FORMULA_ATTRIBUTE_NAME.equals(metricExtension.getName())) {
                MetricsRegistry.parseMetricDefinitionModel(allMetrics, metricExtension);
            }
            ++n2;
        }
        return allMetrics;
    }

    private static void parseMetricDefinitionModel(Map<MetricID, IMetric> allMetrics, IConfigurationElement metricExtension) {
    }

    private static void parseBasicMetric(Map<MetricID, IMetric> allMetrics, IConfigurationElement metricExtension) {
        Object o = null;
        try {
            o = metricExtension.createExecutableExtension(METRIC_CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", "Warning: Specified Analyzer Metric " + metricExtension.getName() + " cannot be loaded."));
            throw new RuntimeException("Eclipse core failure", e);
        }
        if (o == null || !(o instanceof IMetric)) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", "Warning: Specified Analyzer Metric " + metricExtension.getName() + " cannot be loaded."));
            throw new RuntimeException("Eclipse core failure. Could not instanciate metric", null);
        }
        allMetrics.put(((IMetric)o).getMID(), (IMetric)o);
    }
}

