/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.dslvisitor;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.somox.metrics.Activator;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.dsl.metricDSL.ExternalMetric;
import org.somox.metrics.dsl.metricDSL.InternalMetric;
import org.somox.metrics.dsl.metricDSL.Metric;
import org.somox.metrics.dsl.metricDSL.RatioMetric;
import org.somox.metrics.dsl.metricDSL.StepwiseMetric;
import org.somox.metrics.dsl.metricDSL.WeightedMetric;
import org.somox.metrics.dsl.metricDSL.util.MetricDSLSwitch;
import org.somox.metrics.dslvisitor.ConfigurableRatioMetric;
import org.somox.metrics.dslvisitor.ConfigurableStepwiseMetric;
import org.somox.metrics.dslvisitor.ConfigurableWeightedComposedMetric;

public class DSLConfigurationVisitor
extends MetricDSLSwitch<IMetric> {
    private final Map<MetricID, IMetric> registeredMetrics;

    public DSLConfigurationVisitor(Map<MetricID, IMetric> registeredMetrics) {
        this.registeredMetrics = registeredMetrics;
    }

    public IMetric caseInternalMetric(InternalMetric object) {
        if (object.getDefinition() == null) {
            return null;
        }
        return (IMetric)this.doSwitch((EObject)object.getDefinition());
    }

    public IMetric caseRatioMetric(RatioMetric object) {
        return new ConfigurableRatioMetric(((Metric)object.eContainer()).getName(), object);
    }

    public IMetric caseStepwiseMetric(StepwiseMetric object) {
        return new ConfigurableStepwiseMetric(((Metric)object.eContainer()).getName(), object);
    }

    public IMetric caseWeightedMetric(WeightedMetric object) {
        return new ConfigurableWeightedComposedMetric(((Metric)object.eContainer()).getName(), object);
    }

    public IMetric caseExternalMetric(ExternalMetric object) {
        MetricID metricID = new MetricID(object.getName());
        if (!this.registeredMetrics.containsKey(metricID)) {
            Activator.getPlugin().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", "Unable to find referenced metric"));
            throw new RuntimeException("Failed to import external metric as it is not registered.");
        }
        return this.registeredMetrics.get(metricID);
    }
}

