/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.hierarchy;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class TreeNode<T> {
    T element;
    List<TreeNode<T>> children;

    public TreeNode() {
        this.element = null;
        this.children = new LinkedList<TreeNode<T>>();
    }

    public TreeNode(T element) {
        if (element == null) {
            throw new IllegalArgumentException("Element must not be null");
        }
        this.element = element;
        this.children = new LinkedList<TreeNode<T>>();
    }

    public boolean isRoot() {
        return this.element == null;
    }

    public T getElement() {
        return this.element;
    }

    public void addChild(TreeNode<T> child) {
        this.children.add(child);
    }

    public List<TreeNode<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public int getHeight() {
        int result = 0;
        for (TreeNode<T> child : this.children) {
            result = Math.max(result, child.getHeight());
        }
        return result + (this.isRoot() ? 0 : 1);
    }
}

