/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.somox.filter.BaseFilter;
import org.somox.filter.NotFilter;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.SourceClassEdgeFilter;
import org.somox.metrics.helper.TargetClassEdgeFilter;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;

public class AccessCacheGraph {
    private final Logger logger = Logger.getLogger(AccessCacheGraph.class);
    private final DefaultDirectedGraph<ConcreteClassifier, ClassAccessGraphEdge> accessGraph;

    public AccessCacheGraph(DefaultDirectedGraph<ConcreteClassifier, ClassAccessGraphEdge> accessGraph) {
        this.accessGraph = accessGraph;
    }

    public long calculateNumberOfAccessesToClassesInSet(Set<ConcreteClassifier> sourceClasses, Set<ConcreteClassifier> targetClasses) {
        if (sourceClasses == null || targetClasses == null) {
            throw new IllegalArgumentException("Source or target classes must not be null");
        }
        TargetClassEdgeFilter filter = new TargetClassEdgeFilter(targetClasses);
        return this.getNumberOfFilteredOutgoingAccesses(sourceClasses, filter);
    }

    public long calculateNumberOfIncommingAccesses(Set<ConcreteClassifier> sourceClasses) {
        NotFilter filter = new NotFilter((BaseFilter)new SourceClassEdgeFilter(sourceClasses));
        return this.getNumberOfFilteredIncomingAccesses(sourceClasses, (BaseFilter<ClassAccessGraphEdge>)filter);
    }

    public long calculateNumberOfExternalAccesses(Set<ConcreteClassifier> sourceClasses) {
        NotFilter filter = new NotFilter((BaseFilter)new TargetClassEdgeFilter(sourceClasses));
        long result = this.getNumberOfFilteredOutgoingAccesses(sourceClasses, (BaseFilter<ClassAccessGraphEdge>)filter);
        if (this.logger.isDebugEnabled()) {
            Set<ConcreteClassifier> otherClasses = this.substractSet(this.accessGraph.vertexSet(), sourceClasses);
            assert (result == this.calculateNumberOfAccessesToClassesInSet(sourceClasses, otherClasses));
        }
        return result;
    }

    public long calculateNumberOfInternalAccesses(Set<ConcreteClassifier> sourceClasses) {
        TargetClassEdgeFilter filter = new TargetClassEdgeFilter(sourceClasses);
        long result = this.getNumberOfFilteredOutgoingAccesses(sourceClasses, filter);
        if (this.logger.isDebugEnabled()) assert (result == this.calculateNumberOfAccessesToClassesInSet(sourceClasses, sourceClasses));
        return result;
    }

    private Set<ConcreteClassifier> substractSet(Set<ConcreteClassifier> source, Set<ConcreteClassifier> setToRemove) {
        HashSet<ConcreteClassifier> otherClasses = new HashSet<ConcreteClassifier>();
        for (ConcreteClassifier clazz : source) {
            if (setToRemove.contains(clazz)) continue;
            otherClasses.add(clazz);
        }
        return otherClasses;
    }

    private long getNumberOfFilteredOutgoingAccesses(Set<ConcreteClassifier> sourceClasses, BaseFilter<ClassAccessGraphEdge> filter) {
        if (sourceClasses == null) {
            throw new IllegalArgumentException("Source classes must not be null.");
        }
        long numberOfReferences = 0L;
        for (ConcreteClassifier clazz : sourceClasses) {
            try {
                clazz.toString().startsWith("I");
                this.accessGraph.vertexSet().contains(clazz);
                assert (this.accessGraph.vertexSet().contains(clazz));
                if (this.accessGraph.outDegreeOf((Object)clazz) <= 0) continue;
                for (ClassAccessGraphEdge edge : filter.filter((Iterable)this.accessGraph.outgoingEdgesOf((Object)clazz))) {
                    numberOfReferences += (long)edge.getCount();
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("This should never happen as outDegree was > 0", e);
            }
        }
        return numberOfReferences;
    }

    private long getNumberOfFilteredIncomingAccesses(Set<ConcreteClassifier> sourceClasses, BaseFilter<ClassAccessGraphEdge> filter) {
        long numberOfReferences = 0L;
        for (ConcreteClassifier clazz : sourceClasses) {
            try {
                assert (this.accessGraph.vertexSet().contains(clazz));
                if (this.accessGraph.inDegreeOf((Object)clazz) <= 0) continue;
                for (ClassAccessGraphEdge edge : filter.filter((Iterable)this.accessGraph.incomingEdgesOf((Object)clazz))) {
                    numberOfReferences += (long)edge.getCount();
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("This should never happen as outDegree was > 0", e);
            }
        }
        return numberOfReferences;
    }
}

