/*
 * Decompiled with CFR 0.152.
 */
package org.somox.ui.runconfig.tabs;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ModelAnalyzerInputTab
extends AbstractLaunchConfigurationTab {
    private static final String OUTPUT_POSTFIX = "model";
    private ProjectSelector projectSelector;
    private Text outputText;

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Set selectedProjectNames = this.getSelectedProjects().map(IResource::getName).collect(Collectors.toSet());
        configuration.setAttribute("org.somox.project", selectedProjectNames);
        configuration.setAttribute("org.somox.outputfile", this.outputText.getText());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        Label projectsLabel = new Label(container, 0);
        projectsLabel.setText("Projects to analyse:");
        this.projectSelector = new ProjectSelector(container, 2048);
        this.projectSelector.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.projectSelector.treeViewer.addSelectionChangedListener(event -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
            if (this.outputText.getText().isEmpty() && this.getSelectedProjects().count() == 1L) {
                this.useContainerForOutput((IContainer)this.getSelectedProjects().findAny().get());
            }
        });
        Label outputLabel = new Label(container, 0);
        outputLabel.setText("Analysis output:");
        this.outputText = new Text(container, 2048);
        this.outputText.setLayoutData((Object)new GridData(4, 128, true, false));
        this.outputText.addModifyListener(event -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Button browseOutputButton = new Button(container, 0);
        browseOutputButton.setText("Browse\u2026");
        browseOutputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IContainer[] selectedContainers = WorkspaceResourceDialog.openFolderSelection((Shell)ModelAnalyzerInputTab.this.getShell(), (String)"Select output folder", (String)"Select a folder to put the analysis results in.", (boolean)false, null, null);
                if (selectedContainers.length > 0) {
                    ModelAnalyzerInputTab.this.useContainerForOutput(selectedContainers[0]);
                }
            }
        });
        this.setControl((Control)container);
    }

    private void useContainerForOutput(IContainer container) {
        String newOutputText = container.getFullPath().append(OUTPUT_POSTFIX).toString();
        this.outputText.setText(newOutputText);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        Set<IProject> inputProjects = this.getProjectsFrom(configuration);
        Object[] selectedProjects = (IProject[])inputProjects.stream().filter(IResource::exists).toArray(IProject[]::new);
        int projectsNotFound = inputProjects.size() - selectedProjects.length;
        if (projectsNotFound > 0) {
            String removedProjects = inputProjects.stream().filter(project -> !project.exists()).map(IResource::getName).collect(Collectors.joining(", ", "\u201c", "\u201d"));
            this.setMessage("The project" + (projectsNotFound > 1 ? "s" : "") + " " + removedProjects + " could not be found in the workspace and " + (projectsNotFound > 1 ? "were" : "was") + " removed from the configuration.");
            this.setDirty(true);
        }
        this.projectSelector.treeViewer.setCheckedElements(selectedProjects);
        String outputFolder = "";
        try {
            outputFolder = configuration.getAttribute("org.somox.outputfile", "");
        }
        catch (CoreException coreException) {}
        this.outputText.setText(outputFolder);
        if (outputFolder.isEmpty() && selectedProjects.length > 0) {
            this.useContainerForOutput((IContainer)selectedProjects[0]);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String outputFolderString;
        this.setErrorMessage(null);
        Set<IProject> projects = this.getProjectsFrom(launchConfig);
        if (projects.isEmpty()) {
            this.setErrorMessage("No projects to analyse selected!");
            return false;
        }
        try {
            outputFolderString = launchConfig.getAttribute("org.somox.outputfile", "");
        }
        catch (CoreException coreException) {
            outputFolderString = "";
        }
        if (outputFolderString.isEmpty()) {
            this.setErrorMessage("No output folder defined!");
            return false;
        }
        if (!Path.isValidPosixPath((String)outputFolderString) && !Path.isValidWindowsPath((String)outputFolderString)) {
            this.setErrorMessage("The output folder path \u201c" + outputFolderString + "\u201d is not a valid path!");
            return false;
        }
        Path outputFolder = new Path(outputFolderString);
        String firstSegment = outputFolder.segment(0);
        if (!ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(firstSegment)) && !new File(firstSegment).exists()) {
            this.setErrorMessage("The output folder\u2019s project \u201c" + firstSegment + "\u201d does not exist in the workspace!");
            return false;
        }
        return true;
    }

    public String getName() {
        return "General";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean canSave() {
        return true;
    }

    private Stream<IProject> getSelectedProjects() {
        return Arrays.stream(this.projectSelector.treeViewer.getCheckedElements()).map(IProject.class::cast);
    }

    private Set<IProject> getProjectsFrom(ILaunchConfiguration launchConfiguration) {
        Set<Object> inputProject;
        try {
            inputProject = launchConfiguration.getAttributes().get("org.somox.project");
        }
        catch (CoreException coreException) {
            inputProject = Collections.emptySet();
        }
        Set<Object> selectedProjectNames = inputProject instanceof String ? Collections.singleton((String)((Object)inputProject)) : (inputProject instanceof Set ? inputProject : Collections.emptySet());
        return selectedProjectNames.stream().map(arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getProject(arg_0)).collect(Collectors.toSet());
    }

    private class ProjectSelector
    extends FilteredTree {
        private CheckboxTreeViewer treeViewer;

        public ProjectSelector(Composite parent, int treeStyle) {
            super(parent, treeStyle, new PatternFilter(), true, false);
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            this.treeViewer = new CheckboxTreeViewer(parent, style);
            this.treeViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot().getProjects());
            return this.treeViewer;
        }

        private class ProjectContentProvider
        implements ITreeContentProvider {
            private IProject[] projects;

            private ProjectContentProvider() {
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.projects = (IProject[])newInput;
            }

            public Object[] getElements(Object inputElement) {
                return this.projects;
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        }
    }
}

