/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simulation.abstractsimengine;

import de.uka.ipd.sdq.simulation.abstractsimengine.IEntity;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEvent;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEventFactory;
import java.util.Optional;

public abstract class SimpleEventBasedSimEntity
implements IEntity {
    private Optional<ISimEvent<SimpleEventBasedSimEntity>> entityEvent = Optional.empty();
    private final ISimEventFactory eventFactory;
    private final String name;

    protected SimpleEventBasedSimEntity(ISimEventFactory eventFactory, String name) {
        this.eventFactory = eventFactory;
        this.name = name;
    }

    @Override
    public boolean isScheduled() {
        return this.entityEvent.isPresent();
    }

    public Optional<Double> getNextOccurence() {
        return this.entityEvent.map(ISimEvent::scheduledAtTime);
    }

    public void activate(double initialDelay) {
        this.entityEvent = Optional.of(this.eventFactory.createSimEvent(this::eventRoutine, this.name));
        this.entityEvent.get().schedule(this, initialDelay);
    }

    @Override
    public void reschedule(double d) {
        if (this.entityEvent.isEmpty()) {
            this.activate(d);
        } else {
            this.entityEvent.get().schedule(this, d);
        }
    }

    public void unschedule() {
        if (this.entityEvent.isPresent()) {
            this.entityEvent.get().removeEvent();
            this.entityEvent = Optional.empty();
        }
    }

    private void eventRoutine(SimpleEventBasedSimEntity e) {
        this.entityRoutine().ifPresentOrElse(this::reschedule, () -> {
            Optional<ISimEvent<SimpleEventBasedSimEntity>> optional = this.entityEvent = null;
        });
    }

    protected abstract Optional<Double> entityRoutine();
}

