/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulation.abstractsimengine.ssj;

import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractSimProcessDelegator;
import de.uka.ipd.sdq.simulation.abstractsimengine.processes.ISimProcessStrategy;
import de.uka.ipd.sdq.simulation.abstractsimengine.processes.ProcessState;
import de.uka.ipd.sdq.simulation.abstractsimengine.processes.SimProcessThreadingStrategy;
import de.uka.ipd.sdq.simulation.abstractsimengine.processes.SimulatedProcess;
import org.apache.log4j.Logger;
import org.palladiosimulator.simulation.abstractsimengine.ssj.SSJExperiment;
import umontreal.ssj.simevents.Event;
import umontreal.ssj.simevents.Simulator;

public class SSJSimProcess
extends SimulatedProcess {
    public static final Logger logger = Logger.getLogger(SSJSimProcess.class);
    public final AbstractSimProcessDelegator myAbstractProcess;
    private final Simulator sim;
    private final SSJExperiment ssjExperiment;

    public SSJSimProcess(AbstractSimProcessDelegator myProcess, String name) {
        super((ISimProcessStrategy)new SimProcessThreadingStrategy());
        this.myAbstractProcess = myProcess;
        this.ssjExperiment = (SSJExperiment)this.myAbstractProcess.getModel().getSimulationControl();
        this.sim = this.ssjExperiment.getSimulator();
        this.startProcess(this.processStrategy);
    }

    public void scheduleAt(double delay) {
        if (!this.isTerminated()) {
            if (this.myProcessState != ProcessState.SUSPENDED) {
                throw new IllegalStateException("Tried to schedule thread which was not suspended [" + this.myAbstractProcess.getId() + "]");
            }
            if (!this.simIsRunning()) {
                this.resume();
            }
            new Event(this.sim){

                public void actions() {
                    if (!SSJSimProcess.this.isTerminated()) {
                        SSJSimProcess.this.resume();
                    }
                }
            }.schedule(delay);
        }
    }

    public void passivate(double delay) {
        if (!this.isTerminated()) {
            if (this.myProcessState != ProcessState.RUNNING) {
                throw new IllegalStateException("Tried to passivate thread which was not running [" + this.myAbstractProcess.getId() + "]");
            }
            if (!this.simIsRunning()) {
                this.resume();
            }
            new Event(this.sim){

                public void actions() {
                    if (!SSJSimProcess.this.isTerminated()) {
                        SSJSimProcess.this.resume();
                    }
                }
            }.schedule(delay);
            this.suspend();
        }
    }

    private boolean simIsRunning() {
        return !this.ssjExperiment.getSimulator().isStopped();
    }

    protected AbstractSimProcessDelegator getAbstractProcess() {
        return this.myAbstractProcess;
    }

    public boolean isScheduled() {
        throw new UnsupportedOperationException();
    }

    public void reschedule(double delay) {
        throw new UnsupportedOperationException();
    }
}

