/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulation.abstractsimengine.ssj;

import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractSimEntityDelegator;
import de.uka.ipd.sdq.simulation.abstractsimengine.IEntity;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEvent;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimRunnable;
import org.apache.log4j.Logger;
import org.palladiosimulator.simulation.abstractsimengine.ssj.SSJEntity;
import org.palladiosimulator.simulation.abstractsimengine.ssj.SSJExperiment;
import umontreal.ssj.simevents.Event;

public class SSJSimEvent<E extends IEntity>
extends Event
implements ISimEvent<E> {
    private static final Logger logger = Logger.getLogger(SSJSimEvent.class);
    private final ISimRunnable<E> myAbstractEvent;
    private final SSJExperiment simulationControl;
    private E who;

    public SSJSimEvent(ISimRunnable<E> myEvent, SSJExperiment simControl, String name) {
        super(simControl.getSimulator());
        this.simulationControl = simControl;
        this.myAbstractEvent = myEvent;
    }

    public void actions() {
        if (this.simulationControl.checkStopConditions()) {
            if (this.simulationControl.isRunning()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Executing Stop Event");
                }
                this.simulationControl.stop();
            }
        } else {
            AbstractSimEntityDelegator abstractEntity = (AbstractSimEntityDelegator)this.who;
            SSJEntity ssjEntity = (SSJEntity)abstractEntity.getEncapsulatedEntity();
            ssjEntity.isScheduled = false;
            ssjEntity.nextEventForThisEntity = null;
            this.myAbstractEvent.eventRoutine(ssjEntity.getEncapsulatedEntity());
        }
    }

    public void schedule(E resource, double delay) {
        this.who = resource;
        if (this.who instanceof AbstractSimEntityDelegator) {
            AbstractSimEntityDelegator abstractEntity = (AbstractSimEntityDelegator)this.who;
            if (abstractEntity.getEncapsulatedEntity() instanceof SSJEntity) {
                SSJEntity ssjEntity = (SSJEntity)abstractEntity.getEncapsulatedEntity();
                ssjEntity.isScheduled = true;
                ssjEntity.nextEventForThisEntity = this;
            } else {
                logger.warn((Object)("Unsupported entity type contained in abstract sim entity delegator: " + abstractEntity.getEncapsulatedEntity().getClass().getName()));
            }
        }
        this.schedule(delay);
    }

    public void removeEvent() {
        this.cancel();
    }

    public double scheduledAtTime() {
        return this.time();
    }
}

