/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.scheduler.resources.active;

import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.resources.active.AbstractActiveResource;
import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceTableManager
implements IResourceTableManager {
    private final Map<ISchedulableProcess, AbstractActiveResource> currentResourceTable = new ConcurrentHashMap<ISchedulableProcess, AbstractActiveResource>();

    @Override
    public AbstractActiveResource getLastResource(ISchedulableProcess process) {
        return this.currentResourceTable.get(process);
    }

    @Override
    public void setLastResource(ISchedulableProcess process, AbstractActiveResource resource) {
        if (!this.currentResourceTable.containsKey(process)) {
            process.addTerminatedObserver(resource);
        }
        this.currentResourceTable.put(process, resource);
    }

    @Override
    public void notifyTerminated(ISchedulableProcess simProcess) {
        this.currentResourceTable.remove(simProcess);
    }

    @Override
    public void waitForProcesses() {
        for (ISchedulableProcess process : this.currentResourceTable.keySet()) {
            if (process.isFinished()) continue;
            try {
                process.activate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        assert (this.currentResourceTable.size() == 0);
    }
}

