/*
 * Decompiled with CFR 0.152.
 */
package emfprofiles.custom.wizards;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.session.UserSession;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class ViewPointUtil {
    private ViewPointUtil() {
    }

    public static Optional<URI> getRepresentationsURI(IProject project) {
        IResource representationResource = project.findMember("representations.aird");
        return Optional.ofNullable(representationResource).map(IResource::getFullPath).map(IPath::toString).map(p -> URI.createPlatformResourceURI((String)p, (boolean)true));
    }

    public static void selectViewpointsByName(Session session, Collection<String> viewpointNames, boolean createRepresentation, IProgressMonitor monitor) {
        Collection viewpoints = ViewpointRegistry.getInstance().getViewpoints().stream().filter(v -> viewpointNames.contains(v.getName())).collect(Collectors.toList());
        ViewPointUtil.selectViewpoints(session, viewpoints, createRepresentation, monitor);
    }

    public static void selectViewpoints(Session session, Collection<Viewpoint> viewpoints, boolean createRepresentation, IProgressMonitor monitor) {
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        Collection viewpointNamesToSelect = viewpoints.stream().filter(v -> !selectedViewpoints.contains(v)).map(IdentifiedElement::getName).collect(Collectors.toList());
        UserSession.from((Session)session).selectViewpoints((Iterable)viewpointNamesToSelect);
    }
}

