/*
 * Decompiled with CFR 0.152.
 */
package emfprofiles.custom.wizards;

import emfprofiles.custom.wizards.ViewPointUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.diagram.part.EMFProfileDiagramEditorUtil;
import org.modelversioning.emfprofile.project.EMFProfileProjectNatureUtil;
import org.modelversioning.emfprofile.project.ui.wizard.ProfileProjectData;

public class EMFProfilesProjectOperation
extends WorkspaceModifyOperation {
    private static final String BUILD_PROP_FILE_NAME = "build.properties";
    private static final String PDE_PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    private static final String VIEWPOINT_NAME = "emfprofiles.viewpoint";
    private ProfileProjectData projectData;
    private IProject project;
    private Resource profileDiagramResource;

    public EMFProfilesProjectOperation(ProfileProjectData projectData) {
        this.projectData = projectData;
        this.project = projectData.getProjectHandle();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        subMonitor.beginTask("Creating new EMF Profile project", 5);
        subMonitor.subTask("Creating project");
        this.createProject((IProgressMonitor)subMonitor.newChild(1));
        subMonitor.worked(1);
        subMonitor.subTask("Creating contents");
        this.createContents((IProgressMonitor)subMonitor.newChild(1));
        subMonitor.worked(1);
        subMonitor.subTask("Setting up the modeling project");
        this.setUpModelingProject();
        subMonitor.worked(1);
        this.projectData.getProjectHandle().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.configureNatures(this.project);
        subMonitor.subTask("Creating manifest");
        this.createPluginXml((IProgressMonitor)subMonitor.newChild(1));
        this.configureBinBuildProperties();
        this.createManifest(this.projectData.getProjectHandle().getLocation().toString());
        subMonitor.worked(1);
        this.projectData.getProjectHandle().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private void setUpModelingProject() throws CoreException {
        ModelingProjectManager.INSTANCE.convertToModelingProject(this.projectData.getProjectHandle(), (IProgressMonitor)new NullProgressMonitor());
        URI representationsURI = ViewPointUtil.getRepresentationsURI(this.projectData.getProjectHandle()).orElseThrow(() -> new CoreException((IStatus)new Status(4, "emfprofiles.custom", "The representation URI could not be found.")));
        Session session = SessionManager.INSTANCE.getSession(representationsURI, (IProgressMonitor)new NullProgressMonitor());
        ArrayList<String> viewpointNames = new ArrayList<String>();
        viewpointNames.add(VIEWPOINT_NAME);
        ViewPointUtil.selectViewpointsByName(session, viewpointNames, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void createProject(IProgressMonitor monitor) throws CoreException {
        if (!this.project.exists()) {
            if (!Platform.getLocation().equals((Object)this.projectData.getLocationPath())) {
                IProjectDescription desc = this.project.getWorkspace().newProjectDescription(this.project.getName());
                desc.setLocation(this.projectData.getLocationPath());
                this.project.create(desc, monitor);
            } else {
                this.project.create(monitor);
            }
            this.project.open(null);
        }
    }

    private void configureNatures(IProject project) throws CoreException {
        if (!project.hasNature(PDE_PLUGIN_NATURE)) {
            this.addPDENature();
        }
        if (!project.hasNature("org.modelversioning.emfprofile.project.nature")) {
            EMFProfileProjectNatureUtil.addNature((IProject)project);
        }
    }

    public void addPDENature() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        String[] natures = description.getNatureIds();
        if (!Arrays.asList(natures).contains(PDE_PLUGIN_NATURE)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = PDE_PLUGIN_NATURE;
            description.setNatureIds(newNatures);
            this.project.setDescription(description, null);
        }
    }

    private void createPluginXml(IProgressMonitor monitor) throws CoreException {
        IFile pluginXmlFile = this.project.getFile("plugin.xml");
        if (!pluginXmlFile.exists()) {
            StringBuffer pluginXmlContent = new StringBuffer();
            pluginXmlContent.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            pluginXmlContent.append("<?eclipse version=\"3.4\"?>\n");
            pluginXmlContent.append("<plugin>\n");
            pluginXmlContent.append("  <extension point=\"org.modelversioning.emfprofile.profile\">\n");
            pluginXmlContent.append("     <profile profile_resource=\"profile.emfprofile_diagram\"/>\n");
            pluginXmlContent.append("  </extension>\n");
            pluginXmlContent.append("</plugin>\n");
            ByteArrayInputStream source = new ByteArrayInputStream(pluginXmlContent.toString().getBytes());
            pluginXmlFile.create((InputStream)source, true, monitor);
        }
    }

    private void configureBinBuildProperties() throws CoreException {
        IFile buildPropFile = this.project.getFile(BUILD_PROP_FILE_NAME);
        if (!buildPropFile.exists()) {
            StringBuffer buildPropContent = new StringBuffer();
            buildPropContent.append("bin.includes = ");
            buildPropContent.append("plugin.xml,\\\n");
            buildPropContent.append("               ");
            buildPropContent.append("META-INF/,\\\n");
            buildPropContent.append("               ");
            buildPropContent.append("profile.emfprofile_diagram\n");
            ByteArrayInputStream source = new ByteArrayInputStream(buildPropContent.toString().getBytes());
            buildPropFile.create((InputStream)source, true, null);
        }
    }

    protected void createContents(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            this.createProfile(monitor, this.project);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void createProfile(IProgressMonitor monitor, IProject project) throws IOException {
        this.profileDiagramResource = EMFProfileDiagramEditorUtil.createDiagram((URI)EMFProfileProjectNatureUtil.getDefaultProfileDiagramURI((IProject)project), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)0));
        this.setProfileDiagramData();
        this.saveProfileDiagramResource();
    }

    private void saveProfileDiagramResource() throws IOException {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)this.profileDiagramResource);
        this.profileDiagramResource.save(null);
        ((BasicCommandStack)editingDomain.getCommandStack()).saveIsDone();
    }

    private void setProfileDiagramData() {
        final Profile profile = this.getProfileFromResource();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)this.profileDiagramResource);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                profile.setName(EMFProfilesProjectOperation.this.projectData.getProfileName());
                profile.setNsURI(EMFProfilesProjectOperation.this.projectData.getProfileNamespace());
            }
        });
    }

    private Profile getProfileFromResource() {
        if (this.profileDiagramResource == null) {
            return null;
        }
        TreeIterator contents = this.profileDiagramResource.getAllContents();
        while (contents.hasNext()) {
            EObject next = (EObject)contents.next();
            if (!(next instanceof Profile)) continue;
            return (Profile)next;
        }
        return null;
    }

    private void createManifest(String projectPath) {
        String metainfPath = String.valueOf(projectPath) + '/' + "META-INF";
        File metainf = new File(metainfPath);
        metainf.mkdir();
        String manifestPath = String.valueOf(metainfPath) + '/' + "MANIFEST.MF";
        File manifest = new File(manifestPath);
        File buildFile = new File(String.valueOf(projectPath) + '/' + BUILD_PROP_FILE_NAME);
        try {
            manifest.createNewFile();
            buildFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(manifest));
            writer.write("Manifest-Version: 1.0\n");
            writer.write("Bundle-ManifestVersion: 2\n");
            writer.write("Bundle-Name: " + this.projectData.getProfileName() + "\n");
            writer.write("Bundle-SymbolicName: " + this.projectData.getProfileNamespace() + "." + this.projectData.getProfileName() + " ;singleton:=true\n");
            writer.write("Bundle-Version: 1.0.0.qualifier\n");
            writer.write("Bundle-RequiredExecutionEnvironment: JavaSE-1.8\n");
            writer.write("Require-Bundle: org.modelversioning.emfprofile,org.modelversioning.emfprofile.registry\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

