/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.featureconfig;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConfigState implements Enumerator
{
    SELECTED(0, "SELECTED", "SELECTED"),
    ELIMINATED(1, "ELIMINATED", "ELIMINATED"),
    DEFAULT(2, "DEFAULT", "DEFAULT");

    public static final int SELECTED_VALUE = 0;
    public static final int ELIMINATED_VALUE = 1;
    public static final int DEFAULT_VALUE = 2;
    private static final ConfigState[] VALUES_ARRAY;
    public static final List<ConfigState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConfigState[]{SELECTED, ELIMINATED, DEFAULT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConfigState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConfigState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConfigState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConfigState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConfigState get(int value) {
        switch (value) {
            case 0: {
                return SELECTED;
            }
            case 1: {
                return ELIMINATED;
            }
            case 2: {
                return DEFAULT;
            }
        }
        return null;
    }

    private ConfigState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

