/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.featureinstance;

import de.uka.ipd.sdq.dialogs.error.ErrorDisplayDialog;
import de.uka.ipd.sdq.featureconfig.ConfigNode;
import de.uka.ipd.sdq.featureconfig.ConfigState;
import de.uka.ipd.sdq.featureconfig.Configuration;
import de.uka.ipd.sdq.featureconfig.FeatureConfig;
import de.uka.ipd.sdq.featureconfig.impl.featureconfigFactoryImpl;
import de.uka.ipd.sdq.featureinstance.FeatureConfigCreationWizard;
import de.uka.ipd.sdq.featureinstance.FeatureConfigFunctionality;
import de.uka.ipd.sdq.featureinstance.FeatureModelInstanceContributor;
import de.uka.ipd.sdq.featureinstance.TreeContentProvider;
import de.uka.ipd.sdq.featureinstance.TreeLabelProvider;
import de.uka.ipd.sdq.featuremodel.ChildRelation;
import de.uka.ipd.sdq.featuremodel.Feature;
import de.uka.ipd.sdq.featuremodel.FeatureDiagram;
import de.uka.ipd.sdq.featuremodel.FeatureGroup;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class FeatureModelInstanceEditor
extends MultiPageEditorPart
implements ISelectionProvider,
IEditingDomainProvider {
    protected ISelectionChangedListener selectionChangedListener;
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected AdapterFactoryEditingDomain editingDomain;
    protected CheckboxTreeViewer treeViewer;
    protected PropertySheetPage propertySheetPage;
    protected ICheckStateListener listener;
    protected Resource resource;
    protected FeatureDiagram featureDiagram;
    protected Object root;
    protected TreeViewer contentOutlineViewer;
    protected IContentOutlinePage contentOutlinePage;
    protected boolean dirtyFlag = false;
    protected FeatureConfig defaultConfig;
    protected FeatureConfig overridesConfig;
    protected FeatureConfigFunctionality functions = new FeatureConfigFunctionality();
    protected Composite comp;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListener = listener;
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListener = null;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        this.selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FeatureModelInstanceEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.treeViewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("Validate"));
        ((FeatureModelInstanceContributor)this.getEditorSite().getActionBarContributor()).fillContextMenu(manager);
    }

    public FeatureModelInstanceEditor() {
        this.editingDomain = this.functions.initializeEditingDomain();
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid input");
        }
        super.init(site, input);
    }

    protected void createResource(URI uri) {
        if (uri == null) {
            URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
            this.resource = null;
            try {
                this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
            }
            catch (Exception e) {
                this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
            }
        } else {
            URI resourceURI = uri;
            this.resource = null;
            try {
                this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
            }
            catch (Exception e) {
                this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
            }
        }
    }

    protected Resource getResource() {
        return this.resource;
    }

    protected URI startFileWizard(String fileName, String message) {
        FeatureConfigCreationWizard myWiz = new FeatureConfigCreationWizard(fileName, message);
        myWiz.init(this.getEditorSite().getWorkbenchWindow().getWorkbench(), (IStructuredSelection)this.getSelection());
        WizardDialog dialog = new WizardDialog(null, (IWizard)myWiz);
        dialog.create();
        dialog.open();
        return myWiz.getNewResource();
    }

    protected URI startOpenDialog(String fileName) {
        LoadResourceAction.LoadResourceDialog myDialog = new LoadResourceAction.LoadResourceDialog(this.getContainer().getShell(), (EditingDomain)this.editingDomain);
        myDialog.setBlockOnOpen(true);
        myDialog.open();
        if (myDialog.getReturnCode() == 1) {
            return null;
        }
        List uriList = myDialog.getURIs();
        if (uriList.isEmpty()) {
            return null;
        }
        return (URI)uriList.get(0);
    }

    protected void createNewConfigResource(URI newResourceURI, FeatureDiagram featureDiagram, FeatureConfig defaultRef) {
        if (newResourceURI == null) {
            throw new NullPointerException("No Config file stored in resource!");
        }
        this.resource = this.resource.getResourceSet().createResource(newResourceURI);
        featureconfigFactoryImpl factory = new featureconfigFactoryImpl();
        Configuration newConfig = factory.createConfiguration();
        newConfig.setName(String.valueOf(featureDiagram.getName()) + "_config");
        FeatureConfig newOverrides = factory.createFeatureConfig();
        newConfig.getConfigOverrides().add((Object)newOverrides);
        if (defaultRef == null) {
            defaultRef = factory.createFeatureConfig();
        }
        newConfig.setDefaultConfig(defaultRef);
        ConfigNode rootConfigNode = factory.createConfigNode();
        rootConfigNode.setConfigState(ConfigState.ELIMINATED);
        rootConfigNode.setOrigin(featureDiagram.getRootFeature());
        newOverrides.getConfignode().add((Object)rootConfigNode);
        this.resource.getContents().add((Object)newConfig);
        this.defaultConfig = defaultRef;
        this.overridesConfig = newOverrides;
        try {
            this.resource.load(Collections.EMPTY_MAP);
            this.resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            ErrorDisplayDialog errord = new ErrorDisplayDialog(this.getContainer().getShell(), new Throwable("Could not load or save the Resource!"));
            errord.open();
        }
    }

    protected FeatureDiagram getFeatureDiagram(Resource resource) {
        EList tempList = resource.getContents();
        Iterator tempIterator = tempList.iterator();
        if (!tempIterator.hasNext()) {
            return null;
        }
        EObject newResource = (EObject)tempIterator.next();
        if (!(newResource instanceof FeatureDiagram)) {
            return null;
        }
        return (FeatureDiagram)newResource;
    }

    protected void handleFileCases(String fileExtension, String path, String fileName) {
        if (fileExtension.equals("featuremodel")) {
            this.featureDiagram = this.getFeatureDiagram(this.resource);
            boolean valid = true;
            if (this.featureDiagram == null) {
                ErrorDisplayDialog errord = new ErrorDisplayDialog(this.getContainer().getShell(), new Throwable("Loaded *.featuremodel file is not valid! The FeatureDiagram object cannot be accessed."));
                errord.open();
                valid = false;
            }
            File myFile = new File(String.valueOf(path) + ".featureconfig");
            if (valid && myFile.exists()) {
                boolean answer = MessageDialog.openQuestion(null, (String)"Load FeatureConfig ?", (String)("A file named \"" + fileName + ".featureconfig\" was found. Should it be loaded?"));
                if (answer) {
                    ErrorDisplayDialog errord;
                    Resource existingResource = this.resource.getResourceSet().createResource(URI.createFileURI((String)myFile.getPath()));
                    try {
                        existingResource.load(Collections.EMPTY_MAP);
                    }
                    catch (IOException e) {
                        errord = new ErrorDisplayDialog(this.getContainer().getShell(), new Throwable("Existing featureconfig file couldn't be loaded!"));
                        errord.open();
                        valid = false;
                    }
                    if (this.functions.isFeatureDiagramReferenceCorrect(existingResource)) {
                        existingResource = this.handleConfigCases(existingResource);
                        try {
                            this.resource = existingResource;
                            this.resource.load(Collections.EMPTY_MAP);
                            this.resource.save(Collections.EMPTY_MAP);
                        }
                        catch (IOException e) {
                            errord = new ErrorDisplayDialog(this.getContainer().getShell(), new Throwable("Resource couldn't be loaded or saved!"));
                            errord.open();
                            valid = false;
                        }
                    } else {
                        URI newResourceURI = this.startFileWizard(fileName, "Loaded configuration file references wrong diagram. Create a new config file.");
                        this.createNewConfigResource(newResourceURI, this.featureDiagram, null);
                    }
                } else {
                    URI newResourceURI = this.startFileWizard(fileName, "Create a new config file for the loaded diagram.");
                    this.createNewConfigResource(newResourceURI, this.featureDiagram, null);
                }
            } else if (valid) {
                URI configPath = this.startOpenDialog(fileName);
                if (configPath == null) {
                    URI newResourceURI = this.startFileWizard(fileName, "File selection dialog has been cancelled. Create a new config resource.");
                    this.createNewConfigResource(newResourceURI, this.featureDiagram, null);
                } else {
                    ErrorDisplayDialog errord;
                    Resource existingResource = this.resource.getResourceSet().createResource(configPath);
                    try {
                        existingResource.load(Collections.EMPTY_MAP);
                    }
                    catch (IOException e) {
                        errord = new ErrorDisplayDialog(this.getContainer().getShell(), new Throwable("Resource couldn't be loaded or saved!"));
                        errord.open();
                        valid = false;
                    }
                    if (this.functions.isFeatureDiagramReferenceCorrect(existingResource)) {
                        existingResource = this.handleConfigCases(existingResource);
                        try {
                            this.resource = existingResource;
                            this.resource.load(Collections.EMPTY_MAP);
                            this.resource.save(Collections.EMPTY_MAP);
                        }
                        catch (IOException e) {
                            errord = new ErrorDisplayDialog(this.getContainer().getShell(), new Throwable("Resource couldn't be loaded or saved!"));
                            errord.open();
                            valid = false;
                        }
                    } else {
                        ErrorDisplayDialog errord2 = new ErrorDisplayDialog(this.getContainer().getShell(), new Throwable("The selected *.featureconfig file references the wrong FeatureDiagram! A new FileWizard will be started."));
                        errord2.open();
                        URI newResourceURI = this.startFileWizard(fileName, "Loaded configuration file references wrong diagram. Create a new config file.");
                        this.createNewConfigResource(newResourceURI, this.featureDiagram, null);
                    }
                }
            }
        } else if (fileExtension.equals("featureconfig")) {
            this.handleConfigCases(this.resource);
        } else {
            ErrorDisplayDialog errord = new ErrorDisplayDialog(this.getContainer().getShell(), new Throwable("Editor supports only *.featuremodel and *.featureconfig files!"));
            errord.open();
            URI newResourceURI = this.startOpenDialog("");
            this.createResource(newResourceURI);
        }
    }

    protected Resource handleConfigCases(Resource resource) {
        Configuration configuration = this.functions.getConfiguration(resource);
        EList tempOverrides = configuration.getConfigOverrides();
        FeatureConfig tempDefault = configuration.getDefaultConfig();
        if (tempOverrides != null && !tempOverrides.isEmpty() || tempDefault != null) {
            if (tempOverrides == null && tempDefault != null) {
                EList configList = tempDefault.getConfignode();
                if (!configList.isEmpty()) {
                    this.featureDiagram = this.functions.navigateToFeatureDiagram(((ConfigNode)configList.iterator().next()).getOrigin(), this.editingDomain);
                    String fileName = resource.getURI().trimFileExtension().lastSegment();
                    URI newResourceURI = this.startFileWizard(fileName, "Only a default configuration was found. Create a new file with a overrides configuration!");
                    this.createNewConfigResource(newResourceURI, this.featureDiagram, tempDefault);
                }
            } else if (tempOverrides != null && !tempOverrides.isEmpty() && tempDefault == null) {
                FeatureConfig featureConfig = (FeatureConfig)tempOverrides.get(0);
                EList configList = featureConfig.getConfignode();
                if (!configList.isEmpty()) {
                    this.featureDiagram = this.functions.navigateToFeatureDiagram(((ConfigNode)configList.iterator().next()).getOrigin(), this.editingDomain);
                    this.overridesConfig = featureConfig;
                }
            } else {
                FeatureConfig featureConfig;
                EList configList;
                boolean configPresent = false;
                if (!tempOverrides.isEmpty() && !(configList = (featureConfig = (FeatureConfig)tempOverrides.get(0)).getConfignode()).isEmpty()) {
                    this.featureDiagram = this.functions.navigateToFeatureDiagram(((ConfigNode)configList.iterator().next()).getOrigin(), this.editingDomain);
                    this.overridesConfig = featureConfig;
                    configPresent = true;
                }
                if (!(configList = tempDefault.getConfignode()).isEmpty()) {
                    if (configPresent) {
                        this.defaultConfig = tempDefault;
                    } else {
                        this.featureDiagram = this.functions.navigateToFeatureDiagram(((ConfigNode)configList.iterator().next()).getOrigin(), this.editingDomain);
                        String fileName = resource.getURI().trimFileExtension().lastSegment();
                        URI newResourceURI = this.startFileWizard(fileName, "Only a default configuration was found. Create a new file with a overrides configuration!");
                        this.createNewConfigResource(newResourceURI, this.featureDiagram, tempDefault);
                    }
                }
            }
        }
        return resource;
    }

    protected void createPages() {
        this.createResource(null);
        this.createEditor();
    }

    protected void createEditor() {
        String fileExtension = this.resource.getURI().fileExtension();
        String fileName = this.resource.getURI().trimFileExtension().lastSegment();
        String path = Platform.getLocation() + this.resource.getURI().trimFileExtension().toPlatformString(true);
        this.handleFileCases(fileExtension, path, fileName);
        if (this.featureDiagram != null && this.overridesConfig != null) {
            this.comp = new Composite(this.getContainer(), 0);
            this.comp.setLayout((Layout)new FillLayout());
            this.createViewer(this.featureDiagram);
            int index = this.addPage((Control)this.comp);
            this.setPageText(index, "");
            EditingDomainActionBarContributor contrib = this.getActionBarContributor();
            if (contrib instanceof FeatureModelInstanceContributor) {
                ((FeatureModelInstanceContributor)contrib).setConfiguration(this.functions.getConfiguration(this.resource));
                ((FeatureModelInstanceContributor)contrib).setShell(this.getContainer().getShell());
            }
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    public void createViewer(FeatureDiagram root) {
        Feature curRoot;
        this.treeViewer = new CheckboxTreeViewer(this.comp);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewer.setInput((Object)root);
        this.treeViewer.expandAll();
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        if (root != null) {
            this.treeViewer.setGrayed((Object)root.getRootFeature(), true);
            curRoot = root.getRootFeature();
            this.functions.grayFeatureGroups(curRoot.getChildrelation(), this.treeViewer);
        }
        if (this.defaultConfig != null) {
            this.functions.markDefaultConfig(this.defaultConfig, this.treeViewer);
        }
        if (this.overridesConfig != null) {
            this.functions.markOverridesConfig(this.overridesConfig, this.treeViewer);
        }
        this.listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof FeatureGroup) {
                    FeatureModelInstanceEditor.this.treeViewer.setChecked(event.getElement(), !event.getChecked());
                } else {
                    Object parent = FeatureModelInstanceEditor.this.editingDomain.getParent(event.getElement());
                    if (event.getElement() instanceof Feature && FeatureModelInstanceEditor.this.functions.checkMandatory((Feature)event.getElement(), FeatureModelInstanceEditor.this.editingDomain)) {
                        if (parent instanceof ChildRelation) {
                            parent = FeatureModelInstanceEditor.this.editingDomain.getParent(parent);
                        }
                        if (FeatureModelInstanceEditor.this.treeViewer.getChecked(parent)) {
                            FeatureModelInstanceEditor.this.treeViewer.setChecked(event.getElement(), true);
                        }
                    }
                    if (parent != null && !(parent instanceof FeatureDiagram)) {
                        if (FeatureModelInstanceEditor.this.treeViewer.getGrayed(event.getElement())) {
                            FeatureModelInstanceEditor.this.treeViewer.setGrayed(event.getElement(), false);
                        }
                        if (event.getChecked()) {
                            FeatureModelInstanceEditor.this.dirtyFlag = true;
                            FeatureModelInstanceEditor.this.functions.uncheckInModel((Feature)event.getElement(), true, FeatureModelInstanceEditor.this.overridesConfig);
                            FeatureModelInstanceEditor.this.functions.checkParents(event.getElement(), FeatureModelInstanceEditor.this.treeViewer, FeatureModelInstanceEditor.this.overridesConfig, FeatureModelInstanceEditor.this.editingDomain);
                        } else {
                            FeatureModelInstanceEditor.this.functions.uncheckInModel((Feature)event.getElement(), false, FeatureModelInstanceEditor.this.overridesConfig);
                            FeatureModelInstanceEditor.this.functions.uncheckParents(event.getElement(), FeatureModelInstanceEditor.this.treeViewer, FeatureModelInstanceEditor.this.overridesConfig, FeatureModelInstanceEditor.this.editingDomain);
                        }
                    } else {
                        FeatureModelInstanceEditor.this.treeViewer.setChecked(event.getElement(), !event.getChecked());
                    }
                }
            }
        };
        this.treeViewer.addCheckStateListener(this.listener);
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
        if (root != null) {
            curRoot = root.getRootFeature();
            this.functions.selectMandatoryFeatures(curRoot.getChildrelation(), this.treeViewer, this.overridesConfig);
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : FeatureModelInstanceEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !FeatureModelInstanceEditor.this.functions.isPersisted(resource, FeatureModelInstanceEditor.this.editingDomain) || FeatureModelInstanceEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        resource.save(saveOptions);
                    }
                    catch (IOException exception) {
                        ErrorDisplayDialog errord = new ErrorDisplayDialog(FeatureModelInstanceEditor.this.getContainer().getShell(), new Throwable("Resource couldn't be loaded or saved!"));
                        errord.open();
                    }
                    first = false;
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.dirtyFlag = false;
            this.firePropertyChange(257);
        }
        catch (InvocationTargetException e) {
            ErrorDisplayDialog errord = new ErrorDisplayDialog(this.getContainer().getShell(), new Throwable("Resource couldn't be saved!"));
            errord.open();
        }
        catch (InterruptedException e) {
            ErrorDisplayDialog errord = new ErrorDisplayDialog(this.getContainer().getShell(), new Throwable("Resource couldn't be saved!"));
            errord.open();
        }
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }
}

