/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.featureinstance;

import de.uka.ipd.sdq.featureconfig.ConfigNode;
import de.uka.ipd.sdq.featureconfig.ConfigState;
import de.uka.ipd.sdq.featureconfig.Configuration;
import de.uka.ipd.sdq.featureconfig.FeatureConfig;
import de.uka.ipd.sdq.featureconfig.impl.featureconfigFactoryImpl;
import de.uka.ipd.sdq.featureconfig.provider.featureconfigItemProviderAdapterFactory;
import de.uka.ipd.sdq.featuremodel.ChildRelation;
import de.uka.ipd.sdq.featuremodel.Feature;
import de.uka.ipd.sdq.featuremodel.FeatureDiagram;
import de.uka.ipd.sdq.featuremodel.FeatureGroup;
import de.uka.ipd.sdq.featuremodel.Simple;
import de.uka.ipd.sdq.featuremodel.provider.featuremodelItemProviderAdapterFactory;
import de.uka.ipd.sdq.identifier.provider.IdentifierItemProviderAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.viewers.CheckboxTreeViewer;

public class FeatureConfigFunctionality {
    public Configuration getConfiguration(Resource resource) {
        EList tempList = resource.getContents();
        Iterator tempIterator = tempList.iterator();
        if (!tempIterator.hasNext()) {
            return null;
        }
        EObject newResource = (EObject)tempIterator.next();
        if (!(newResource instanceof Configuration)) {
            return null;
        }
        return (Configuration)newResource;
    }

    public void uncheckParents(Object current, CheckboxTreeViewer treeViewer, FeatureConfig overridesConfig, AdapterFactoryEditingDomain editingDomain) {
        Object parent;
        boolean checked = this.getAnyChecked(current, treeViewer, editingDomain);
        if (!checked && (parent = editingDomain.getParent(current)) != null && !(parent instanceof FeatureDiagram)) {
            treeViewer.setChecked(parent, false);
            if (parent instanceof Feature) {
                this.uncheckInModel((Feature)parent, false, overridesConfig);
            }
            this.uncheckParents(parent, treeViewer, overridesConfig, editingDomain);
        }
    }

    private boolean getAnyChecked(Object current, CheckboxTreeViewer treeViewer, AdapterFactoryEditingDomain editingDomain) {
        boolean checked;
        block5: {
            ChildRelation childRel;
            Object parent;
            block4: {
                parent = editingDomain.getParent(current);
                checked = false;
                if (!(parent instanceof FeatureGroup)) break block4;
                EList children = ((FeatureGroup)parent).getChildren();
                for (Feature next : children) {
                    if (!treeViewer.getChecked((Object)next)) continue;
                    checked = true;
                }
                break block5;
            }
            if (!(parent instanceof Feature) || (childRel = ((Feature)parent).getChildrelation()) instanceof FeatureGroup) break block5;
            EList childrenMan = ((Simple)childRel).getMandatoryChildren();
            EList childrenOpt = ((Simple)childRel).getOptionalChildren();
            for (Feature next : childrenMan) {
                if (!treeViewer.getChecked((Object)next)) continue;
                checked = true;
            }
            if (!checked) {
                for (Feature next : childrenOpt) {
                    if (!treeViewer.getChecked((Object)next)) continue;
                    checked = true;
                }
            }
        }
        return checked;
    }

    protected void checkParents(Object current, CheckboxTreeViewer treeViewer, FeatureConfig overridesConfig, AdapterFactoryEditingDomain editingDomain) {
        Object parent = editingDomain.getParent(current);
        if (parent != null && !treeViewer.getChecked(parent)) {
            if (!(parent instanceof FeatureGroup)) {
                treeViewer.setChecked(parent, true);
            }
            if (parent instanceof Feature) {
                this.uncheckInModel((Feature)parent, true, overridesConfig);
            }
            this.checkParents(parent, treeViewer, overridesConfig, editingDomain);
        }
    }

    public FeatureDiagram navigateToFeatureDiagram(Feature feature, AdapterFactoryEditingDomain editingDomain) {
        Object parent = editingDomain.getParent((Object)feature);
        while (parent != null && !(parent instanceof FeatureDiagram)) {
            parent = editingDomain.getParent(parent);
        }
        return (FeatureDiagram)parent;
    }

    public AdapterFactoryEditingDomain initializeEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new featureconfigItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new featuremodelItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new IdentifierItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        return new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public boolean isFeatureDiagramReferenceCorrect(Resource existingResource) {
        Iterator configIterator;
        EList configList;
        Configuration configuration = this.getConfiguration(existingResource);
        boolean correct = false;
        if (configuration == null) {
            return correct;
        }
        EList tempOverrides = configuration.getConfigOverrides();
        FeatureConfig tempDefault = configuration.getDefaultConfig();
        if (tempOverrides != null && !tempOverrides.isEmpty() && !(configList = ((FeatureConfig)tempOverrides.get(0)).getConfignode()).isEmpty()) {
            configIterator = configList.iterator();
            while (configIterator.hasNext()) {
                if (((ConfigNode)configIterator.next()).getOrigin() == null) continue;
                correct = true;
            }
        }
        if (!correct && tempDefault != null && !(configList = tempDefault.getConfignode()).isEmpty()) {
            configIterator = configList.iterator();
            while (configIterator.hasNext()) {
                if (((ConfigNode)configIterator.next()).getOrigin() == null) continue;
                correct = true;
            }
        }
        return correct;
    }

    public void selectMandatoryFeatures(ChildRelation curRelation, CheckboxTreeViewer treeViewer, FeatureConfig overridesConfig) {
        block3: {
            block4: {
                if (curRelation == null) break block3;
                if (!(curRelation instanceof FeatureGroup)) break block4;
                EList nodes = ((FeatureGroup)curRelation).getChildren();
                Iterator nodesIter = nodes.iterator();
                while (nodesIter.hasNext()) {
                    this.selectMandatoryFeatures(((Feature)nodesIter.next()).getChildrelation(), treeViewer, overridesConfig);
                }
                break block3;
            }
            if (!(curRelation instanceof Simple)) break block3;
            EList mandFeatures = ((Simple)curRelation).getMandatoryChildren();
            EList optFeatures = ((Simple)curRelation).getOptionalChildren();
            for (Feature next : mandFeatures) {
                treeViewer.setChecked((Object)next, true);
                this.uncheckInModel(next, true, overridesConfig);
                this.selectMandatoryFeatures(next.getChildrelation(), treeViewer, overridesConfig);
            }
            Iterator featureIter = optFeatures.iterator();
            while (featureIter.hasNext()) {
                this.selectMandatoryFeatures(((Feature)featureIter.next()).getChildrelation(), treeViewer, overridesConfig);
            }
        }
    }

    public void uncheckInModel(Feature element, boolean state, FeatureConfig overridesConfig) {
        int hash = element.hashCode();
        boolean found = false;
        for (ConfigNode next : overridesConfig.getConfignode()) {
            if (next.getOrigin().hashCode() != hash) continue;
            found = true;
            if (state) {
                next.setConfigState(ConfigState.SELECTED);
                continue;
            }
            next.setConfigState(ConfigState.ELIMINATED);
        }
        if (!found) {
            featureconfigFactoryImpl factory = new featureconfigFactoryImpl();
            ConfigNode newConfig = factory.createConfigNode();
            newConfig.setOrigin(element);
            if (state) {
                newConfig.setConfigState(ConfigState.SELECTED);
            } else {
                newConfig.setConfigState(ConfigState.ELIMINATED);
            }
            overridesConfig.getConfignode().add((Object)newConfig);
        }
    }

    public void markDefaultConfig(FeatureConfig defaultConfig, CheckboxTreeViewer treeViewer) {
        EList defaultNodes = defaultConfig.getConfignode();
        for (ConfigNode next : defaultNodes) {
            Feature referenced = next.getOrigin();
            if (next.getConfigState().getValue() == 0) {
                treeViewer.setGrayChecked((Object)referenced, true);
                continue;
            }
            if (next.getConfigState().getValue() != 1) continue;
            treeViewer.setGrayChecked((Object)referenced, false);
        }
    }

    public void markOverridesConfig(FeatureConfig overridesConfig, CheckboxTreeViewer treeViewer) {
        EList overridesNodes = overridesConfig.getConfignode();
        for (ConfigNode next : overridesNodes) {
            Feature referenced = next.getOrigin();
            if (next.getConfigState().getValue() == 0) {
                treeViewer.setGrayed((Object)referenced, false);
                treeViewer.setChecked((Object)referenced, true);
                continue;
            }
            if (next.getConfigState().getValue() != 1) continue;
            treeViewer.setGrayed((Object)referenced, false);
            treeViewer.setChecked((Object)referenced, false);
        }
    }

    public boolean checkMandatory(Feature node, AdapterFactoryEditingDomain editingDomain) {
        Object parent = editingDomain.getParent((Object)node);
        boolean mandatory = false;
        if (parent instanceof Simple) {
            EList featureList = ((Simple)parent).getMandatoryChildren();
            for (Feature current : featureList) {
                if (current != node) continue;
                mandatory = true;
            }
        }
        return mandatory;
    }

    public void grayFeatureGroups(ChildRelation curRelation, CheckboxTreeViewer treeViewer) {
        block3: {
            block4: {
                if (curRelation == null) break block3;
                if (!(curRelation instanceof FeatureGroup)) break block4;
                treeViewer.setGrayed((Object)curRelation, true);
                EList nodes = ((FeatureGroup)curRelation).getChildren();
                Iterator nodesIter = nodes.iterator();
                while (nodesIter.hasNext()) {
                    this.grayFeatureGroups(((Feature)nodesIter.next()).getChildrelation(), treeViewer);
                }
                break block3;
            }
            if (!(curRelation instanceof Simple)) break block3;
            EList mandFeatures = ((Simple)curRelation).getMandatoryChildren();
            EList optFeatures = ((Simple)curRelation).getOptionalChildren();
            Iterator featureIter = mandFeatures.iterator();
            while (featureIter.hasNext()) {
                this.grayFeatureGroups(((Feature)featureIter.next()).getChildrelation(), treeViewer);
            }
            featureIter = optFeatures.iterator();
            while (featureIter.hasNext()) {
                this.grayFeatureGroups(((Feature)featureIter.next()).getChildrelation(), treeViewer);
            }
        }
    }

    protected boolean isPersisted(Resource resource, AdapterFactoryEditingDomain editingDomain) {
        boolean result = false;
        try {
            InputStream stream = editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

