/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.blackboard;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class SavePartitionToDiskJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private final Logger logger = Logger.getLogger(SavePartitionToDiskJob.class);
    private MDSDBlackboard blackboard;
    private final String partitionID;
    private Map<String, Object> saveOptions = null;

    public SavePartitionToDiskJob(String partitionID) {
        this.partitionID = partitionID;
    }

    public SavePartitionToDiskJob(String partitionID, Map<String, Object> saveOptions) {
        this.partitionID = partitionID;
        this.saveOptions = saveOptions;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Saving partition " + this.partitionID));
        }
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition(this.partitionID);
        try {
            partition.storeAllResources(this.saveOptions);
        }
        catch (IOException e) {
            throw new JobFailedException("Failed to save models", (Throwable)e);
        }
    }

    public String getName() {
        return "Store all resources of a partion to disk";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

