/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.configuration;

import de.uka.ipd.sdq.workflow.configuration.IJobConfiguration;
import de.uka.ipd.sdq.workflow.configuration.InvalidWorkflowJobConfigurationException;

public abstract class AbstractJobConfiguration
implements IJobConfiguration,
Cloneable {
    protected boolean isFixed = false;

    public void validateAndFreeze() throws InvalidWorkflowJobConfigurationException {
        if (!this.isValid()) {
            throw new InvalidWorkflowJobConfigurationException(this.getErrorMessage());
        }
        this.isFixed = true;
    }

    public boolean isFrozen() {
        return this.isFixed;
    }

    protected void checkFixed() {
        if (this.isFixed) {
            throw new UnsupportedOperationException("Configuration cannot be changed any longer after fixing it");
        }
    }

    @Override
    public abstract String getErrorMessage();

    @Override
    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    @Override
    public abstract void setDefaults();

    protected Object clone() throws CloneNotSupportedException {
        AbstractJobConfiguration config = (AbstractJobConfiguration)super.clone();
        config.isFixed = this.isFixed;
        return config;
    }
}

