/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.jobs;

import de.uka.ipd.sdq.workflow.ExecutionTimeLoggingProgressMonitor;
import de.uka.ipd.sdq.workflow.WorkflowFailedException;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;

public class DynamicSequentialJob
extends SequentialJob {
    public DynamicSequentialJob() {
        this("Dynamic Sequential Job");
    }

    public DynamicSequentialJob(String name) {
        super(name);
    }

    public DynamicSequentialJob(boolean cleanUpImmediately) {
        super(cleanUpImmediately);
    }

    public DynamicSequentialJob(String name, boolean cleanUpImmediately) {
        super(name, cleanUpImmediately);
        this.setName(name);
    }

    @Override
    protected void executeWithDelayedCleanUp(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(monitor, 1);
        subProgressMonitor.beginTask(String.valueOf(this.getName()) + " Execution", -1);
        while (!this.isEmpty()) {
            if (monitor.isCanceled()) {
                throw new UserCanceledException();
            }
            IJob job = this.removeFirst();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Palladio Workflow-Engine: Running job " + job.getName()));
            }
            subProgressMonitor.subTask(job.getName());
            this.myExecutedJobs.push(job);
            this.executeJob(job, (IProgressMonitor)subProgressMonitor);
            subProgressMonitor.worked(1);
        }
        subProgressMonitor.done();
    }

    @Override
    protected void executeWithImmediateCleanUp(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(monitor, 1);
        subProgressMonitor.beginTask(String.valueOf(this.getName()) + " Execution", -1);
        subProgressMonitor.worked(0);
        while (!this.isEmpty()) {
            Exception workflowException;
            block7: {
                if (monitor.isCanceled()) {
                    throw new UserCanceledException();
                }
                IJob job = this.removeFirst();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Palladio Workflow-Engine: Running job " + job.getName()));
                }
                subProgressMonitor.subTask(job.getName());
                workflowException = null;
                try {
                    this.executeJob(job, (IProgressMonitor)subProgressMonitor);
                }
                catch (Exception e) {
                    workflowException = e;
                }
                subProgressMonitor.worked(1);
                subProgressMonitor.subTask("Cleaning up job " + job.getName());
                try {
                    job.cleanup((IProgressMonitor)subProgressMonitor);
                }
                catch (CleanupFailedException e) {
                    if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block7;
                    this.logger.warn((Object)("Failed to cleanup job " + job.getName()));
                }
            }
            subProgressMonitor.worked(1);
            if (workflowException == null) continue;
            throw new WorkflowFailedException("A workflow job failed", workflowException);
        }
        subProgressMonitor.done();
    }

    protected void executeJob(IJob job, IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        job.execute(monitor);
    }
}

