/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.AbstractCompositeJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IProgressMonitor;

public class ParallelJob
extends AbstractCompositeJob {
    private int threadPoolSize = -1;
    private ExecutorService executorService;
    private ExecutorCompletionService<Throwable> executorCompletionService;
    private HashMap<Future<Throwable>, JobCallable> futures = new HashMap();

    public ParallelJob() {
        this(-1);
    }

    public ParallelJob(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        this.setupExecutor();
    }

    @Override
    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        for (IJob job : this.myJobs) {
            JobCallable task = new JobCallable(job, monitor);
            Future<Throwable> future = this.executorCompletionService.submit(task);
            this.futures.put(future, task);
        }
        boolean singleJobFailed = false;
        Throwable failedJobException = null;
        while (this.futures.size() > 0 && !singleJobFailed && !monitor.isCanceled()) {
            try {
                Future<Throwable> completedTask = this.executorCompletionService.take();
                Throwable result = completedTask.get();
                if (result != null) {
                    singleJobFailed = true;
                    failedJobException = result;
                    continue;
                }
                this.myExecutedJobs.add(this.futures.get(completedTask).getJob());
                this.futures.remove(completedTask);
            }
            catch (InterruptedException e) {
                throw new JobFailedException("Failed waiting for job to finish", e);
            }
            catch (ExecutionException e) {
                throw new JobFailedException("Failed waiting for job to finish", e);
            }
        }
        if (singleJobFailed) {
            throw new JobFailedException("A parallel child job failed", failedJobException);
        }
        if (monitor.isCanceled()) {
            throw new UserCanceledException();
        }
    }

    private void setupExecutor() {
        this.executorService = this.threadPoolSize < 0 ? Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()) : Executors.newFixedThreadPool(this.threadPoolSize);
        this.executorCompletionService = new ExecutorCompletionService(this.executorService);
    }

    private class JobCallable
    implements Callable<Throwable> {
        private IJob job;
        private IProgressMonitor monitor;

        public JobCallable(IJob job, IProgressMonitor monitor) {
            this.job = job;
            this.monitor = monitor;
        }

        @Override
        public Throwable call() {
            try {
                this.job.execute(this.monitor);
            }
            catch (Exception e) {
                return e;
            }
            return null;
        }

        public IJob getJob() {
            return this.job;
        }
    }
}

