/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.oaw;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowContextDefaultImpl;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitorAdapter;
import org.eclipse.xtend.expression.AbstractExpressionsUsingWorkflowComponent;

public abstract class AbstractOAWWorkflowJobBridge<T extends AbstractExpressionsUsingWorkflowComponent>
implements IJob {
    private final Logger logger = Logger.getLogger(AbstractOAWWorkflowJobBridge.class);
    protected T oawJob = null;
    private HashMap<String, Object> slotContents;

    public AbstractOAWWorkflowJobBridge(T job) {
        this(job, new HashMap<String, Object>());
    }

    public AbstractOAWWorkflowJobBridge(T job, HashMap<String, Object> slotContents) {
        this.oawJob = job;
        this.slotContents = slotContents;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        IssuesImpl issues = new IssuesImpl();
        WorkflowContextDefaultImpl ctx = new WorkflowContextDefaultImpl();
        this.setupContext((WorkflowContext)ctx);
        try {
            this.setupOAWJob(this.oawJob);
            this.logger.debug((Object)"Validating oAW configuration settings...");
            this.oawJob.checkConfiguration((Issues)issues);
            if (issues.hasErrors()) {
                String message = issues.toString();
                throw new JobFailedException("oAW Job configuration is invalid: " + message);
            }
            this.logger.debug((Object)"Running oAW task....");
            this.oawJob.invoke((WorkflowContext)ctx, (ProgressMonitor)new ProgressMonitorAdapter(monitor), (Issues)issues);
            if (issues.hasErrors()) {
                throw new JobFailedException("oAW Job failed");
            }
        }
        catch (Exception e) {
            throw new JobFailedException("oAW Failed", (Throwable)e);
        }
    }

    protected void setupContext(WorkflowContext ctx) {
        for (String slot : this.slotContents.keySet()) {
            ctx.set(slot, this.slotContents.get(slot));
        }
    }

    protected abstract void setupOAWJob(T var1);

    public String getName() {
        return this.oawJob.getId() == null ? "oAW Job" : this.oawJob.getId();
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }
}

