/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;

public class JobProxy
implements IJob {
    private final String name;
    private final Supplier<IJob> jobSupplier;
    private IJob delegate = null;

    public JobProxy(Supplier<IJob> jobSupplier) {
        this.name = "Unresolved Job Proxy";
        this.jobSupplier = jobSupplier;
    }

    public JobProxy(String name, Supplier<IJob> jobSupplier) {
        this.name = name;
        this.jobSupplier = jobSupplier;
    }

    protected IJob supplyJob() {
        return this.delegate != null ? this.delegate : this.jobSupplier.get();
    }

    @Override
    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.delegate = this.supplyJob();
        this.delegate.execute(monitor);
    }

    @Override
    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
        if (this.delegate == null) {
            throw new CleanupFailedException("The proxy job has not been executed before.");
        }
        this.delegate.cleanup(monitor);
    }

    @Override
    public String getName() {
        return this.delegate == null ? this.name : this.delegate.getName();
    }
}

